/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.IEmbedResolver;
import com.adobe.flash.compiler.common.SourceLocation;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.exceptions.CodegenInterruptedException;
import com.adobe.flash.compiler.internal.projects.ASProject;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLCompilerDirectiveNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLFileNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.internal.units.EmbedCompilationUnit;
import com.adobe.flash.compiler.internal.units.EmbedCompilationUnitFactory;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.mxml.IMXMLEmbedNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLFileNode;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.utils.FilenameNormalization;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

class MXMLEmbedNode
extends MXMLCompilerDirectiveNodeBase
implements IMXMLEmbedNode,
IEmbedResolver {
    private String containingSourceFilename = null;

    MXMLEmbedNode(MXMLNodeBase parent) {
        super(parent);
        if (parent != null) {
            this.setContainingSourceFilename();
        }
    }

    @Override
    public void setParent(NodeBase parent) {
        super.setParent(parent);
        if (parent != null) {
            this.setContainingSourceFilename();
        }
    }

    private void setContainingSourceFilename() {
        IMXMLFileNode fileNode = (IMXMLFileNode)this.getAncestorOfType(IMXMLFileNode.class);
        this.containingSourceFilename = FilenameNormalization.normalize(fileNode.getSourcePath());
    }

    @Override
    public void initializeFromText(MXMLTreeBuilder builder, String text, SourceLocation location) {
        this.parseTextAndSetAttributes(builder, text, location, "Embed");
        MXMLFileNode fileNode = builder.getFileNode();
        fileNode.addEmbedNode(this);
    }

    @Override
    public EmbedCompilationUnit resolveCompilationUnit(ICompilerProject project, Collection<ICompilerProblem> problems) throws InterruptedException {
        assert (project instanceof ASProject);
        return EmbedCompilationUnitFactory.getCompilationUnit((ASProject)project, this.containingSourceFilename, this, this.attributes, problems);
    }

    @Override
    public EmbedCompilationUnit resolveCompilationUnit(ICompilerProject project) throws InterruptedException {
        assert (project instanceof ASProject);
        ArrayList ignoredProblems = new ArrayList();
        return this.resolveCompilationUnit(project, (Collection)ignoredProblems);
    }

    @Override
    public IClassDefinition getClassReference(ICompilerProject project) {
        IClassDefinition classReference = super.getClassReference(project);
        if (classReference != null) {
            return classReference;
        }
        try {
            LinkedList problems = new LinkedList();
            ICompilationUnit cu = this.resolveCompilationUnit(project, (Collection)problems);
            if (cu == null) {
                return null;
            }
            this.setClassReference((FlexProject)project, ((EmbedCompilationUnit)cu).getName());
        }
        catch (InterruptedException e) {
            throw new CodegenInterruptedException(e);
        }
        return super.getClassReference(project);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLEmbedID;
    }

    @Override
    public String getName() {
        return "Embed";
    }
}

