/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.internal.scopes.MXMLFileScope;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLLibraryNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLModelNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLPrivateNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.problems.MXMLPrivateTagLocationProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.mxml.IMXMLDocumentNode;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;

public class MXMLDocumentNode
extends MXMLClassDefinitionNode
implements IMXMLDocumentNode {
    protected final Map<String, String> rootAttributes = new HashMap<String, String>();
    private static ImmutableSet<String> SKIP_ATTRIBUTES = ImmutableSet.of((Object)"excludeFrom", (Object)"includeIn", (Object)"itemCreationPolicy", (Object)"frameRate", (Object)"pageTitle", (Object)"preloader", (Object[])new String[]{"rsl", "runtimeDPIProvider", "scriptRecursionLimit", "scriptTimeLimit", "splashScreenImage", "theme", "useDirectBlit", "useGPU", "usePreloader", "Library"});

    public MXMLDocumentNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLDocumentID;
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLFileScope fileScope = builder.getFileScope();
        MXMLNodeBase childNode = null;
        if (fileScope.isLibraryTag(childTag)) {
            childNode = new MXMLLibraryNode(this);
        } else if (fileScope.isModelTag(childTag)) {
            childNode = new MXMLModelNode(this);
        } else if (fileScope.isPrivateTag(childTag)) {
            if (childTag.getNextSibling(true) != null) {
                MXMLPrivateTagLocationProblem problem = new MXMLPrivateTagLocationProblem(childTag);
                builder.addProblem(problem);
            } else {
                childNode = new MXMLPrivateNode(this);
            }
        } else {
            super.processChildTag(builder, tag, childTag, info);
        }
        if (childNode != null) {
            childNode.initializeFromTag(builder, childTag);
            info.addChildNode(childNode);
        }
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        String name = attribute.getName();
        this.rootAttributes.put(name, attribute.getRawValue());
        if (!SKIP_ATTRIBUTES.contains((Object)name)) {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }
}

