/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLDesignLayerNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLInstanceNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLSpecifierNode;
import com.google.common.base.Strings;

class MXMLDesignLayerNode
extends MXMLInstanceNode
implements IMXMLDesignLayerNode {
    MXMLDesignLayerNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLDesignLayerID;
    }

    @Override
    public String getName() {
        return "DesignLayer";
    }

    @Override
    public int getHoistedChildCount() {
        int result = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            IASNode child = this.getChild(i);
            if (child instanceof IMXMLSpecifierNode) continue;
            if (child instanceof IMXMLDesignLayerNode) {
                IMXMLDesignLayerNode designLayerNode = (IMXMLDesignLayerNode)child;
                result += designLayerNode.getHoistedChildCount();
                continue;
            }
            if (child instanceof IMXMLInstanceNode) {
                ++result;
                continue;
            }
            throw new IllegalStateException((Object)((Object)child.getNodeID()) + " is unexpected child of DesignLayer.");
        }
        return result;
    }

    @Override
    public boolean skipCodeGeneration() {
        IMXMLPropertySpecifierNode[] propertySpecifierNodes = this.getPropertySpecifierNodes();
        boolean hasNoPropertySpecifiers = propertySpecifierNodes == null || propertySpecifierNodes.length == 0;
        boolean hasNoID = Strings.isNullOrEmpty((String)this.getID());
        return hasNoPropertySpecifiers && hasNoID;
    }
}

