/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.MXMLFileScope;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.problems.MXMLEmptyAttributeProblem;
import com.adobe.flash.compiler.problems.MXMLInvalidDefinitionNameProblem;
import com.adobe.flash.compiler.problems.MXMLRequiredAttributeProblem;
import com.adobe.flash.compiler.problems.MXMLSemanticProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLClassDefinitionNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLDefinitionNode;

class MXMLDefinitionNode
extends MXMLNodeBase
implements IMXMLDefinitionNode {
    private String definitionName;
    private MXMLClassDefinitionNode containedClassDefinitionNode;

    MXMLDefinitionNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLDefinitionID;
    }

    @Override
    public String getName() {
        return "Definition";
    }

    @Override
    public int getChildCount() {
        return this.containedClassDefinitionNode != null ? 1 : 0;
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.containedClassDefinitionNode : null;
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("name")) {
            String rawValue;
            if (this.definitionName == null && (rawValue = attribute.getRawValue()) != null) {
                this.definitionName = attribute.getMXMLDialect().trim(rawValue);
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        boolean handled = false;
        if (this.containedClassDefinitionNode == null) {
            IClassDefinition tagDefinition;
            MXMLSemanticProblem problem;
            this.containedClassDefinitionNode = new MXMLClassDefinitionNode(this);
            handled = true;
            FlexProject project = builder.getProject();
            IDefinition tagDef = builder.getFileScope().resolveTagToDefinition(childTag);
            if (tagDef == null) {
                problem = new MXMLSemanticProblem(childTag);
                builder.addProblem(problem);
            }
            if (!(tagDef instanceof IClassDefinition)) {
                problem = new MXMLSemanticProblem(childTag);
                builder.addProblem(problem);
            }
            if ((tagDefinition = (IClassDefinition)tagDef).isFinal()) {
                MXMLSemanticProblem problem2 = new MXMLSemanticProblem(childTag);
                builder.addProblem(problem2);
            }
            MXMLFileScope fileScope = builder.getFileScope();
            ClassDefinition definitionTagClass = fileScope.getClassDefinitionForDefinitionTag(tag);
            assert (tagDefinition == definitionTagClass.resolveBaseClass(project));
            this.containedClassDefinitionNode.setClassReference(project, tagDefinition);
            this.containedClassDefinitionNode.setClassDefinition(definitionTagClass);
            this.containedClassDefinitionNode.initializeFromTag(builder, childTag);
            int nameStart = definitionTagClass.getNameStart();
            int nameEnd = definitionTagClass.getNameEnd();
            definitionTagClass.setNode(this.containedClassDefinitionNode);
            definitionTagClass.setNameLocation(nameStart, nameEnd);
        }
        if (!handled) {
            super.processChildTag(builder, tag, childTag, info);
        }
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        if (this.definitionName == null) {
            MXMLRequiredAttributeProblem problem = new MXMLRequiredAttributeProblem(tag, "name");
            builder.addProblem(problem);
            this.markInvalidForCodeGen();
        } else if (this.definitionName.isEmpty()) {
            MXMLEmptyAttributeProblem problem = new MXMLEmptyAttributeProblem(tag.getTagAttributeData("name"));
            builder.addProblem(problem);
            this.markInvalidForCodeGen();
        } else if (!MXMLDefinitionNode.isValidXMLTagName(this.definitionName)) {
            MXMLInvalidDefinitionNameProblem problem = new MXMLInvalidDefinitionNameProblem(tag.getTagAttributeData("name"), this.definitionName);
            builder.addProblem(problem);
            this.markInvalidForCodeGen();
        }
    }

    @Override
    public String getDefinitionName() {
        return this.definitionName;
    }

    @Override
    public IMXMLClassDefinitionNode getContainedClassDefinitionNode() {
        return this.containedClassDefinitionNode;
    }

    @Override
    public IClassDefinition getContainedClassDefinition() {
        return this.containedClassDefinitionNode != null ? this.containedClassDefinitionNode.getClassDefinition() : null;
    }
}

