/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.SourceLocation;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.IVariableDefinition;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.parsing.ISourceFragment;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLArrayNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLUnitData;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLClassNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLDeferredInstanceNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLInstanceNode;
import java.util.List;

class MXMLDeferredInstanceNode
extends MXMLInstanceNode
implements IMXMLDeferredInstanceNode {
    private IMXMLInstanceNode childNode;

    MXMLDeferredInstanceNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLDeferredInstanceID;
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.childNode : null;
    }

    @Override
    public int getChildCount() {
        return this.childNode == null ? 0 : 1;
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        FlexProject project = builder.getProject();
        IDefinition definition = builder.getFileScope().resolveTagToDefinition(childTag);
        if (definition instanceof ClassDefinition) {
            String qname = project.getDeferredInstanceFromFunctionClass();
            this.setClassReference(project, qname);
            builder.addExpressionDependency(qname);
            this.childNode = MXMLInstanceNode.createInstanceNode(builder, definition.getQualifiedName(), this);
            ((MXMLInstanceNode)this.childNode).setClassReference(project, (ClassDefinition)definition);
            ((MXMLInstanceNode)this.childNode).initializeFromTag(builder, childTag);
        }
    }

    void initializeDefaultProperty(MXMLTreeBuilder builder, IVariableDefinition defaultPropertyDefinition, List<MXMLUnitData> contentUnits) {
        String instanceType;
        FlexProject project = builder.getProject();
        assert (contentUnits.isEmpty() || !builder.getFileScope().isScriptTag(contentUnits.get(0))) : "Script tags should not start a default property!";
        assert (contentUnits.isEmpty() || !builder.getFileScope().isScriptTag(contentUnits.get(contentUnits.size() - 1))) : "Trailing script tags should be removed from default property content units!";
        this.setLocation(builder, contentUnits);
        this.setClassReference(project, project.getDeferredInstanceFromFunctionClass());
        boolean isSingleArrayTag = false;
        int n = contentUnits.size();
        if (n == 1 && contentUnits.get(0) instanceof MXMLTagData) {
            MXMLTagData tag = (MXMLTagData)contentUnits.get(0);
            IDefinition definition = builder.getFileScope().resolveTagToDefinition(tag);
            isSingleArrayTag = definition.getQualifiedName().equals("Array");
        }
        if ("Array".equals(instanceType = defaultPropertyDefinition.getInstanceType(project)) && !isSingleArrayTag) {
            this.childNode = new MXMLArrayNode(this);
            ((MXMLArrayNode)this.childNode).initializeDefaultProperty(builder, defaultPropertyDefinition, contentUnits);
        } else if (n == 1 && !isSingleArrayTag) {
            MXMLTagData tag = (MXMLTagData)contentUnits.get(0);
            IDefinition type = builder.getFileScope().resolveTagToDefinition(tag);
            if (type instanceof ClassDefinition) {
                IClassDefinition tagClass = (IClassDefinition)type;
                MXMLInstanceNode childInstanceNode = MXMLInstanceNode.createInstanceNode(builder, type.getQualifiedName(), this);
                childInstanceNode.setClassReference(project, tagClass);
                this.childNode = childInstanceNode;
                childInstanceNode.initializeFromTag(builder, tag);
            }
        }
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        if (this.childNode == null) {
            SourceLocation location = info.getSourceLocation();
            if (location == null) {
                location = tag.getLocationOfChildUnits();
            }
            ISourceFragment[] sourceFragments = info.getSourceFragments();
            this.initializeFromFragments(builder, location, sourceFragments);
        }
    }

    public void initializeFromFragments(MXMLTreeBuilder builder, SourceLocation location, ISourceFragment[] fragments) {
        FlexProject project = builder.getProject();
        String qname = project.getDeferredInstanceFromClassClass();
        this.setClassReference(project, qname);
        builder.addExpressionDependency(qname);
        this.childNode = new MXMLClassNode(this);
        ((MXMLClassNode)this.childNode).setClassReference(project, this.childNode.getName());
        ((MXMLClassNode)this.childNode).initializeFromFragments(builder, location, fragments);
    }

    @Override
    public IMXMLClassNode getClassNode() {
        return this.childNode instanceof IMXMLClassNode ? (IMXMLClassNode)this.childNode : null;
    }

    @Override
    public IMXMLInstanceNode getInstanceNode() {
        return !(this.childNode instanceof IMXMLClassNode) ? this.childNode : null;
    }
}

