/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.MXMLFileScope;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLComponentNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLModelNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLDeclarationsNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLInstanceNode;

class MXMLDeclarationsNode
extends MXMLNodeBase
implements IMXMLDeclarationsNode {
    private IMXMLInstanceNode[] declarationInstances;

    MXMLDeclarationsNode(NodeBase parent) {
        super(parent);
    }

    @Override
    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLFileScope fileScope = builder.getFileScope();
        if (fileScope.isComponentTag(childTag)) {
            MXMLComponentNode componentNode = new MXMLComponentNode(this);
            componentNode.initializeFromTag(builder, childTag);
            info.addChildNode(componentNode);
        } else if (fileScope.isModelTag(childTag)) {
            MXMLModelNode modelNode = new MXMLModelNode(this);
            modelNode.initializeFromTag(builder, childTag);
            info.addChildNode(modelNode);
        } else {
            FlexProject project = builder.getProject();
            IDefinition definition = builder.getFileScope().resolveTagToDefinition(childTag);
            if (definition instanceof ClassDefinition) {
                MXMLInstanceNode instanceNode = MXMLInstanceNode.createInstanceNode(builder, definition.getQualifiedName(), this);
                instanceNode.setClassReference(project, (IClassDefinition)definition);
                instanceNode.initializeFromTag(builder, childTag);
                info.addChildNode(instanceNode);
            } else {
                super.processChildTag(builder, tag, childTag, info);
            }
        }
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        this.declarationInstances = info.getChildNodeList().toArray(new MXMLInstanceNode[0]);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLDeclarationsID;
    }

    @Override
    public IASNode getChild(int i) {
        return this.declarationInstances != null ? this.declarationInstances[i] : null;
    }

    @Override
    public int getChildCount() {
        return this.declarationInstances != null ? this.declarationInstances.length : 0;
    }

    @Override
    public String getName() {
        return "Declarations";
    }

    @Override
    public IMXMLInstanceNode[] getDeclarationInstanceNodes() {
        return this.declarationInstances;
    }

    void setDeclarationInstanceNodes(IMXMLInstanceNode[] declarationInstances) {
        this.declarationInstances = declarationInstances;
    }
}

