/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.SourceLocation;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.parsing.ISourceFragment;
import com.adobe.flash.compiler.internal.parsing.SourceFragment;
import com.adobe.flash.compiler.internal.parsing.SourceFragmentsReader;
import com.adobe.flash.compiler.internal.parsing.as.ASParser;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.LiteralNode;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLConcatenatedDataBindingNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLSingleDataBindingNode;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.ILiteralNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLSingleDataBindingNode;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class MXMLDataBindingParser {
    private static final char LEFT_BRACE = '{';
    private static final char RIGHT_BRACE = '}';
    private static final char BACKSLASH = '\\';

    MXMLDataBindingParser() {
    }

    public static Object parse(IMXMLNode parent, SourceLocation sourceLocation, ISourceFragment[] fragments, Collection<ICompilerProblem> problems, Workspace workspace, MXMLDialect mxmlDialect) {
        assert (fragments != null) : "Expected an array of source fragments";
        ListMultimap<ISourceFragment, Integer> scanResult = MXMLDataBindingParser.scan(fragments);
        if (scanResult == null) {
            return SourceFragmentsReader.concatLogicalText(fragments);
        }
        List<FragmentList> splitResult = MXMLDataBindingParser.split(fragments, scanResult);
        return MXMLDataBindingParser.createNode(parent, sourceLocation, splitResult, problems, workspace, mxmlDialect);
    }

    private static ListMultimap<ISourceFragment, Integer> scan(ISourceFragment[] fragments) {
        LinkedListMultimap result = null;
        int nesting = 0;
        ISourceFragment leftBraceFragment = null;
        int leftBraceCharIndex = -1;
        boolean escape = false;
        for (ISourceFragment fragment : fragments) {
            String text = fragment.getLogicalText();
            int n = text.length();
            block6: for (int i = 0; i < n; ++i) {
                switch (text.charAt(i)) {
                    default: {
                        escape = false;
                        continue block6;
                    }
                    case '{': {
                        if (nesting == 0 & !escape) {
                            leftBraceFragment = fragment;
                            leftBraceCharIndex = i;
                        }
                        ++nesting;
                        escape = false;
                        continue block6;
                    }
                    case '}': {
                        if (--nesting == 0) {
                            if (result == null) {
                                result = LinkedListMultimap.create();
                            }
                            result.put((Object)leftBraceFragment, (Object)leftBraceCharIndex);
                            result.put((Object)fragment, (Object)i);
                        }
                        escape = false;
                        continue block6;
                    }
                    case '\\': {
                        escape = true;
                    }
                }
            }
        }
        return result;
    }

    private static List<FragmentList> split(ISourceFragment[] fragments, ListMultimap<ISourceFragment, Integer> scanResult) {
        ArrayList<FragmentList> result = new ArrayList<FragmentList>();
        boolean inDataBinding = false;
        ArrayList currentList = null;
        for (ISourceFragment fragment : fragments) {
            List braceIndices = scanResult.get((Object)fragment);
            if (braceIndices == null) {
                if (currentList == null) {
                    currentList = MXMLDataBindingParser.newFragmentList(result, inDataBinding);
                }
                currentList.add(fragment);
                continue;
            }
            braceIndices.add(fragment.getLogicalText().length());
            int beginIndex = 0;
            Iterator i$ = braceIndices.iterator();
            while (i$.hasNext()) {
                int braceIndex = (Integer)i$.next();
                ISourceFragment subfragment = ((SourceFragment)fragment).subfragment(beginIndex, braceIndex);
                if (subfragment != null) {
                    currentList = MXMLDataBindingParser.newFragmentList(result, inDataBinding);
                    currentList.add(subfragment);
                }
                beginIndex = braceIndex + 1;
                inDataBinding = !inDataBinding;
            }
        }
        return result;
    }

    private static FragmentList newFragmentList(List<FragmentList> result, boolean inDataBinding) {
        FragmentList list = inDataBinding ? new DataBindingFragmentList() : new NonDataBindingFragmentList();
        result.add(list);
        return list;
    }

    private static IASNode createNode(IMXMLNode parent, SourceLocation sourceLocation, List<FragmentList> listOfFragmentLists, Collection<ICompilerProblem> problems, Workspace workspace, MXMLDialect mxmlDialect) {
        IASNode child;
        MXMLConcatenatedDataBindingNode node = new MXMLConcatenatedDataBindingNode((NodeBase)((Object)parent));
        node.setLocation(sourceLocation.getSourcePath(), sourceLocation.getAbsoluteStart(), sourceLocation.getAbsoluteEnd(), sourceLocation.getLine(), sourceLocation.getColumn());
        ArrayList<IASNode> children = new ArrayList<IASNode>();
        for (FragmentList fragmentList : listOfFragmentLists) {
            if (fragmentList instanceof DataBindingFragmentList) {
                children.add(MXMLDataBindingParser.createDataBindingNode(node, sourceLocation, fragmentList, problems, workspace));
                continue;
            }
            if (!(fragmentList instanceof NonDataBindingFragmentList)) continue;
            children.add(MXMLDataBindingParser.createStringLiteralNode(node, sourceLocation, fragmentList));
        }
        if (children.isEmpty()) {
            assert (listOfFragmentLists.isEmpty());
            children.add(MXMLDataBindingParser.createEmptyDatabindingNode(node, sourceLocation));
        }
        MXMLDataBindingParser.trim(children, mxmlDialect);
        node.setChildren(children.toArray(new IASNode[0]));
        if (node.getChildCount() == 1 && (child = node.getChild(0)) instanceof IMXMLSingleDataBindingNode) {
            return child;
        }
        return node;
    }

    private static ILiteralNode createStringLiteralNode(MXMLConcatenatedDataBindingNode parent, SourceLocation sourceLocation, List<ISourceFragment> fragmentList) {
        ISourceFragment[] fragments = fragmentList.toArray(new ISourceFragment[0]);
        String text = SourceFragmentsReader.concatLogicalText(fragments);
        LiteralNode stringLiteralNode = new LiteralNode(ILiteralNode.LiteralType.STRING, text);
        stringLiteralNode.setParent(parent);
        ISourceFragment firstFragment = fragments[0];
        ISourceFragment lastFragment = fragments[fragments.length - 1];
        stringLiteralNode.setSourcePath(sourceLocation.getSourcePath());
        stringLiteralNode.setStart(firstFragment.getPhysicalStart());
        stringLiteralNode.setEnd(lastFragment.getPhysicalStart() + lastFragment.getPhysicalText().length());
        stringLiteralNode.setLine(firstFragment.getPhysicalLine());
        stringLiteralNode.setColumn(firstFragment.getPhysicalColumn());
        return stringLiteralNode;
    }

    private static IMXMLSingleDataBindingNode createDataBindingNode(IMXMLNode parent, SourceLocation sourceLocation, List<ISourceFragment> fragments, Collection<ICompilerProblem> problems, Workspace workspace) {
        MXMLSingleDataBindingNode result = new MXMLSingleDataBindingNode((NodeBase)((Object)parent));
        ISourceFragment firstFragment = fragments.get(0);
        ISourceFragment lastFragment = fragments.get(fragments.size() - 1);
        result.setSourcePath(sourceLocation.getSourcePath());
        result.setStart(firstFragment.getPhysicalStart() - 1);
        result.setEnd(lastFragment.getPhysicalStart() + lastFragment.getPhysicalText().length() + 1);
        result.setLine(firstFragment.getPhysicalLine());
        result.setColumn(firstFragment.getPhysicalColumn() - 1);
        SourceFragmentsReader reader = new SourceFragmentsReader(sourceLocation.getSourcePath(), fragments.toArray(new ISourceFragment[0]));
        IExpressionNode expressionNode = ASParser.parseDataBinding(workspace, reader, problems);
        if (expressionNode == null) {
            expressionNode = new LiteralNode(ILiteralNode.LiteralType.STRING, "");
        }
        ((ExpressionNodeBase)expressionNode).setParent(result);
        result.setExpressionNode(expressionNode);
        return result;
    }

    private static IMXMLSingleDataBindingNode createEmptyDatabindingNode(IMXMLNode parent, SourceLocation sourceLocation) {
        MXMLSingleDataBindingNode result = new MXMLSingleDataBindingNode((NodeBase)((Object)parent));
        result.setSourceLocation((NodeBase)((Object)parent));
        LiteralNode expressionNode = new LiteralNode(ILiteralNode.LiteralType.STRING, "");
        ((ExpressionNodeBase)expressionNode).setParent(result);
        result.setExpressionNode(expressionNode);
        return result;
    }

    private static void trim(List<IASNode> children, MXMLDialect mxmlDialect) {
        assert (children != null && !children.isEmpty());
        IASNode firstChild = children.get(0);
        MXMLDataBindingParser.removeIfWhitespace(children, firstChild, mxmlDialect);
        int n = children.size();
        IASNode lastChild = children.get(n - 1);
        MXMLDataBindingParser.removeIfWhitespace(children, lastChild, mxmlDialect);
    }

    private static void removeIfWhitespace(List<IASNode> children, IASNode child, MXMLDialect mxmlDialect) {
        String text;
        if (child instanceof ILiteralNode && mxmlDialect.isWhitespace(text = ((ILiteralNode)child).getValue())) {
            children.remove(child);
        }
        assert (!children.isEmpty());
    }

    private static class NonDataBindingFragmentList
    extends FragmentList {
        private NonDataBindingFragmentList() {
        }
    }

    private static class DataBindingFragmentList
    extends FragmentList {
        private DataBindingFragmentList() {
        }
    }

    private static abstract class FragmentList
    extends ArrayList<ISourceFragment> {
        private FragmentList() {
        }
    }
}

