/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.MXMLFileScope;
import com.adobe.flash.compiler.internal.scopes.TypeScope;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLFactoryNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.problems.MXMLSemanticProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLClassDefinitionNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLComponentNode;

class MXMLComponentNode
extends MXMLFactoryNode
implements IMXMLComponentNode {
    private String className;
    private MXMLClassDefinitionNode containedClassDefinitionNode;

    MXMLComponentNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLComponentID;
    }

    @Override
    public String getName() {
        IClassDefinition classDefinition = this.getContainedClassDefinition();
        return classDefinition != null ? classDefinition.getBaseName() : "";
    }

    @Override
    public int getChildCount() {
        return this.containedClassDefinitionNode != null ? 1 : 0;
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.containedClassDefinitionNode : null;
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("className")) {
            String rawValue;
            if (this.className == null && (rawValue = attribute.getRawValue()) != null) {
                this.className = attribute.getMXMLDialect().trim(rawValue);
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        boolean handled = false;
        if (this.containedClassDefinitionNode == null) {
            IClassDefinition tagDefinition;
            MXMLSemanticProblem problem;
            this.containedClassDefinitionNode = new MXMLClassDefinitionNode(this);
            handled = true;
            FlexProject project = builder.getProject();
            IDefinition tagDef = builder.getFileScope().resolveTagToDefinition(childTag);
            if (tagDef == null) {
                problem = new MXMLSemanticProblem(childTag);
                builder.addProblem(problem);
            }
            if (!(tagDef instanceof IClassDefinition)) {
                problem = new MXMLSemanticProblem(childTag);
                builder.addProblem(problem);
            }
            if ((tagDefinition = (IClassDefinition)tagDef).isFinal()) {
                MXMLSemanticProblem problem2 = new MXMLSemanticProblem(childTag);
                builder.addProblem(problem2);
            }
            MXMLFileScope fileScope = builder.getFileScope();
            ClassDefinition fxComponentClassDefinition = fileScope.getClassDefinitionForComponentTag(tag);
            assert (fxComponentClassDefinition != null) : "MXMLScopeBuilder failed to build a class for an fx:Component";
            TypeScope componentClassScope = (TypeScope)fxComponentClassDefinition.getContainedScope();
            this.containedClassDefinitionNode.setScope(componentClassScope);
            this.containedClassDefinitionNode.setClassReference(project, tagDefinition);
            this.containedClassDefinitionNode.setClassDefinition(fxComponentClassDefinition);
            int nameStart = fxComponentClassDefinition.getNameStart();
            int nameEnd = fxComponentClassDefinition.getNameEnd();
            fxComponentClassDefinition.setNode(this.containedClassDefinitionNode);
            fxComponentClassDefinition.setNameLocation(nameStart, nameEnd);
            this.containedClassDefinitionNode.initializeFromTag(builder, childTag);
        }
        if (!handled) {
            super.processChildTag(builder, tag, childTag, info);
        }
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public IMXMLClassDefinitionNode getContainedClassDefinitionNode() {
        return this.containedClassDefinitionNode;
    }

    @Override
    public IClassDefinition getContainedClassDefinition() {
        return this.containedClassDefinitionNode != null ? this.containedClassDefinitionNode.getClassDefinition() : null;
    }
}

