/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.SourceLocation;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLCompilerDirectiveNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLEmbedNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLResourceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.problems.EmbedTypeNotEmbeddableProblem;
import com.adobe.flash.compiler.problems.MXMLUnrecognizedCompilerDirectiveProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.mxml.IMXMLNode;

class MXMLCompilerDirectiveParser {
    MXMLCompilerDirectiveParser() {
    }

    public static MXMLInstanceNode parse(MXMLTreeBuilder builder, IMXMLNode parent, SourceLocation location, String text, ITypeDefinition type) {
        String atFunctionName = MXMLCompilerDirectiveParser.getAtFunctionName(text);
        if (atFunctionName == null) {
            return null;
        }
        return MXMLCompilerDirectiveParser.parseAtFunction(builder, parent, location, atFunctionName, text, type);
    }

    private static String getAtFunctionName(String value) {
        int openParen;
        if ((value = value.trim()).length() > 1 && value.charAt(0) == '@' && (openParen = value.indexOf(40)) > 1 && value.indexOf(41) > openParen) {
            return value.substring(1, openParen);
        }
        return null;
    }

    private static MXMLCompilerDirectiveNodeBase parseAtFunction(MXMLTreeBuilder builder, IMXMLNode parent, SourceLocation location, String functionName, String text, ITypeDefinition type) {
        MXMLCompilerDirectiveNodeBase result = null;
        if ("Embed".equals(functionName)) {
            FlexProject project = builder.getProject();
            ITypeDefinition stringType = project.getBuiltinType(IASLanguageConstants.BuiltinType.STRING);
            ITypeDefinition classType = project.getBuiltinType(IASLanguageConstants.BuiltinType.CLASS);
            if (stringType.isInstanceOf(type, (ICompilerProject)project) || classType.isInstanceOf(type, (ICompilerProject)project)) {
                result = new MXMLEmbedNode((MXMLNodeBase)parent);
                result.initializeFromText(builder, text, location);
            } else {
                EmbedTypeNotEmbeddableProblem problem = new EmbedTypeNotEmbeddableProblem(location, type.getBaseName());
                builder.addProblem(problem);
            }
        } else if ("Resource".equals(functionName)) {
            result = new MXMLResourceNode((NodeBase)((Object)parent), type);
            result.initializeFromText(builder, text, location);
        } else {
            builder.addProblem(new MXMLUnrecognizedCompilerDirectiveProblem(location, functionName));
        }
        if (result != null) {
            result.setSourceLocation(location);
        }
        return result;
    }
}

