/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.IEffectDefinition;
import com.adobe.flash.compiler.definitions.IEventDefinition;
import com.adobe.flash.compiler.definitions.ISetterDefinition;
import com.adobe.flash.compiler.definitions.IStyleDefinition;
import com.adobe.flash.compiler.definitions.IVariableDefinition;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.ASProjectScope;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLEffectSpecifierNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLEventSpecifierNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLPropertySpecifierNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLReparentNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLScriptNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLSpecifierNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLStyleSpecifierNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLTextData;
import com.adobe.flash.compiler.mxml.MXMLUnitData;
import com.adobe.flash.compiler.problems.MXMLDuplicateChildTagProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLClassReferenceNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLEventSpecifierNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLSpecifierNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class MXMLClassReferenceNodeBase
extends MXMLNodeBase
implements IMXMLClassReferenceNode {
    private IClassDefinition classReference;
    private boolean isMXMLObject = false;
    private boolean isContainer = false;
    private boolean isVisualElementContainer = false;
    private boolean isDeferredInstantiationUIComponent = false;
    private IMXMLNode[] children;
    private Map<String, IMXMLPropertySpecifierNode> propertyNodeMap;
    private Map<String, IMXMLEventSpecifierNode> eventNodeMap;
    private Map<String, Collection<IMXMLSpecifierNode>> suffixSpecifierMap;
    private IVariableDefinition defaultPropertyDefinition;
    private boolean defaultPropertyDefinitionInitialized = false;
    private boolean processingDefaultProperty = false;
    private boolean processedDefaultProperty = false;
    private MXMLPropertySpecifierNode defaultPropertyNode;
    private List<MXMLUnitData> defaultPropertyContentUnits;

    MXMLClassReferenceNodeBase(NodeBase parent) {
        super(parent);
    }

    @Override
    public IASNode getChild(int i) {
        return this.children != null ? this.children[i] : null;
    }

    @Override
    public int getChildCount() {
        return this.children != null ? this.children.length : 0;
    }

    @Override
    public String getName() {
        return this.classReference != null ? this.classReference.getQualifiedName() : "";
    }

    @Override
    public IClassDefinition getClassReference(ICompilerProject project) {
        return this.classReference;
    }

    @Override
    public boolean isMXMLObject() {
        return this.isMXMLObject;
    }

    @Override
    public boolean isContainer() {
        return this.isContainer;
    }

    @Override
    public boolean isVisualElementContainer() {
        return this.isVisualElementContainer;
    }

    @Override
    public boolean isDeferredInstantiationUIComponent() {
        return this.isDeferredInstantiationUIComponent;
    }

    void setClassReference(FlexProject project, IClassDefinition classReference) {
        this.classReference = classReference;
        String mxmlObjectInterface = project.getMXMLObjectInterface();
        this.isMXMLObject = classReference.isInstanceOf(mxmlObjectInterface, (ICompilerProject)project);
        String visualElementContainerInterface = project.getVisualElementContainerInterface();
        this.isVisualElementContainer = classReference.isInstanceOf(visualElementContainerInterface, (ICompilerProject)project);
        String containerInterface = project.getContainerInterface();
        this.isContainer = classReference.isInstanceOf(containerInterface, (ICompilerProject)project);
        String deferredInstantiationUIComponentInterface = project.getDeferredInstantiationUIComponentInterface();
        this.isDeferredInstantiationUIComponent = classReference.isInstanceOf(deferredInstantiationUIComponentInterface, (ICompilerProject)project);
    }

    void setClassReference(FlexProject project, String qname) {
        ASProjectScope projectScope = project.getScope();
        IDefinition definition = projectScope.findDefinitionByName(qname);
        if (definition instanceof IClassDefinition) {
            this.setClassReference(project, (IClassDefinition)definition);
        }
    }

    void setChildren(IMXMLNode[] children) {
        this.children = children;
        if (children != null) {
            for (IMXMLNode child : children) {
                if (child instanceof IMXMLPropertySpecifierNode) {
                    if (this.propertyNodeMap == null) {
                        this.propertyNodeMap = new HashMap<String, IMXMLPropertySpecifierNode>();
                    }
                    this.propertyNodeMap.put(child.getName(), (IMXMLPropertySpecifierNode)child);
                } else if (child instanceof IMXMLEventSpecifierNode) {
                    if (this.eventNodeMap == null) {
                        this.eventNodeMap = new HashMap<String, IMXMLEventSpecifierNode>();
                    }
                    this.eventNodeMap.put(child.getName(), (IMXMLEventSpecifierNode)child);
                }
                if (!(child instanceof IMXMLSpecifierNode) || this.suffixSpecifierMap != null) continue;
                this.suffixSpecifierMap = new HashMap<String, Collection<IMXMLSpecifierNode>>();
            }
        }
    }

    @Override
    public IMXMLPropertySpecifierNode getPropertySpecifierNode(String name) {
        return this.propertyNodeMap != null ? this.propertyNodeMap.get(name) : null;
    }

    @Override
    public IMXMLPropertySpecifierNode[] getPropertySpecifierNodes() {
        return this.propertyNodeMap != null ? this.propertyNodeMap.values().toArray(new IMXMLPropertySpecifierNode[0]) : null;
    }

    @Override
    public IMXMLEventSpecifierNode getEventSpecifierNode(String name) {
        return this.eventNodeMap != null ? this.eventNodeMap.get(name) : null;
    }

    @Override
    public IMXMLEventSpecifierNode[] getEventSpecifierNodes() {
        return this.eventNodeMap != null ? this.eventNodeMap.values().toArray(new IMXMLEventSpecifierNode[0]) : null;
    }

    @Override
    public IMXMLSpecifierNode[] getSpecifierNodesWithSuffix(String suffix) {
        return this.suffixSpecifierMap != null ? this.suffixSpecifierMap.get(suffix).toArray(new IMXMLSpecifierNode[0]) : null;
    }

    @Override
    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLSpecifierNodeBase childNode = this.createSpecifierNode(builder, attribute.getName());
        if (childNode != null) {
            childNode.setLocation(attribute);
            childNode.setSuffix(builder, attribute.getStateName());
            childNode.initializeFromAttribute(builder, attribute, info);
            info.addChildNode(childNode);
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        if (info.hasSpecifierWithName(childTag.getShortName(), childTag.getStateName())) {
            MXMLDuplicateChildTagProblem problem = new MXMLDuplicateChildTagProblem(childTag);
            builder.addProblem(problem);
            return;
        }
        FlexProject project = builder.getProject();
        MXMLSpecifierNodeBase childNode = this.createSpecifierNode(builder, childTag.getShortName());
        if (childNode != null) {
            this.processNonDefaultPropertyContentUnit(builder, info);
            childNode.setSuffix(builder, childTag.getStateName());
            childNode.initializeFromTag(builder, childTag);
            info.addChildNode(childNode);
        } else if (builder.getFileScope().isScriptTag(childTag) && builder.getMXMLDialect().isEqualToOrBefore(MXMLDialect.MXML_2009)) {
            if (!this.processingDefaultProperty) {
                MXMLScriptNode scriptNode = new MXMLScriptNode(this);
                scriptNode.initializeFromTag(builder, childTag);
                info.addChildNode(scriptNode);
            } else {
                this.processDefaultPropertyContentUnit(builder, childTag, info);
            }
        } else if (builder.getFileScope().isReparentTag(childTag)) {
            MXMLReparentNode reparentNode = new MXMLReparentNode(this);
            reparentNode.initializeFromTag(builder, childTag);
            info.addChildNode(reparentNode);
        } else {
            IDefinition definition = builder.getFileScope().resolveTagToDefinition(childTag);
            if (definition instanceof ClassDefinition) {
                IVariableDefinition defaultPropertyDefinition = this.getDefaultPropertyDefinition(builder);
                if (defaultPropertyDefinition != null && !this.processedDefaultProperty) {
                    this.processDefaultPropertyContentUnit(builder, childTag, info);
                } else {
                    this.processNonDefaultPropertyContentUnit(builder, info);
                    MXMLInstanceNode instanceNode = MXMLInstanceNode.createInstanceNode(builder, definition.getQualifiedName(), this);
                    instanceNode.setClassReference(project, (IClassDefinition)definition);
                    instanceNode.initializeFromTag(builder, childTag);
                    info.addChildNode(instanceNode);
                }
            } else {
                this.processNonDefaultPropertyContentUnit(builder, info);
                super.processChildTag(builder, tag, childTag, info);
            }
        }
    }

    private IVariableDefinition getDefaultPropertyDefinition(MXMLTreeBuilder builder) {
        if (!this.defaultPropertyDefinitionInitialized) {
            FlexProject project = builder.getProject();
            String defaultPropertyName = this.classReference.getDefaultPropertyName(project);
            if (defaultPropertyName != null) {
                this.defaultPropertyDefinition = (IVariableDefinition)project.resolveSpecifier(this.classReference, defaultPropertyName);
            }
            this.defaultPropertyDefinitionInitialized = true;
        }
        return this.defaultPropertyDefinition;
    }

    private void processDefaultPropertyContentUnit(MXMLTreeBuilder builder, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        if (!this.processingDefaultProperty) {
            this.processingDefaultProperty = true;
            String defaultPropertyName = this.getDefaultPropertyDefinition(builder).getBaseName();
            this.defaultPropertyNode = (MXMLPropertySpecifierNode)this.createSpecifierNode(builder, defaultPropertyName);
            info.addChildNode(this.defaultPropertyNode);
            this.defaultPropertyContentUnits = new ArrayList<MXMLUnitData>(1);
        }
        this.defaultPropertyContentUnits.add(childTag);
    }

    private void processNonDefaultPropertyContentUnit(MXMLTreeBuilder builder, MXMLNodeBase.MXMLNodeInfo info) {
        if (this.processingDefaultProperty) {
            int lastNonScriptTagIndex;
            this.processingDefaultProperty = false;
            this.processedDefaultProperty = true;
            assert (this.defaultPropertyContentUnits.size() > 0);
            assert (!builder.getFileScope().isScriptTag(this.defaultPropertyContentUnits.get(0))) : "First default property content unit must not be a script tag!";
            for (lastNonScriptTagIndex = this.defaultPropertyContentUnits.size() - 1; lastNonScriptTagIndex > 0; --lastNonScriptTagIndex) {
                MXMLUnitData unitData = this.defaultPropertyContentUnits.get(lastNonScriptTagIndex);
                if (!builder.getFileScope().isScriptTag(unitData)) break;
            }
            assert (lastNonScriptTagIndex >= 0);
            assert (lastNonScriptTagIndex < this.defaultPropertyContentUnits.size());
            List<MXMLUnitData> trailingScriptTags = this.defaultPropertyContentUnits.subList(lastNonScriptTagIndex + 1, this.defaultPropertyContentUnits.size());
            List<MXMLUnitData> defaultPropertyContentUnitsWithoutTrailingScriptTags = this.defaultPropertyContentUnits.subList(0, lastNonScriptTagIndex + 1);
            IVariableDefinition defaultPropertyDefinition = this.getDefaultPropertyDefinition(builder);
            this.defaultPropertyNode.initializeDefaultProperty(builder, defaultPropertyDefinition, defaultPropertyContentUnitsWithoutTrailingScriptTags);
            for (MXMLUnitData scriptTagData : trailingScriptTags) {
                assert (builder.getFileScope().isScriptTag(scriptTagData));
                MXMLScriptNode scriptNode = new MXMLScriptNode(this);
                scriptNode.initializeFromTag(builder, (MXMLTagData)scriptTagData);
                info.addChildNode(scriptNode);
            }
        }
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        IVariableDefinition defaultPropertyDefinition = this.getDefaultPropertyDefinition(builder);
        if (defaultPropertyDefinition != null) {
            MXMLSpecifierNodeBase childNode = this.createSpecifierNode(builder, defaultPropertyDefinition.getBaseName());
            if (childNode != null) {
                childNode.initializeFromText(builder, text, info);
                info.addChildNode(childNode);
            }
        } else {
            super.processChildNonWhitespaceUnit(builder, tag, text, info);
        }
    }

    protected MXMLSpecifierNodeBase createSpecifierNode(MXMLTreeBuilder builder, String specifierName) {
        MXMLSpecifierNodeBase specifierNode = null;
        FlexProject project = builder.getProject();
        IDefinition specifierDefinition = project.resolveSpecifier(this.classReference, specifierName);
        if (specifierDefinition instanceof ISetterDefinition || specifierDefinition instanceof IVariableDefinition) {
            specifierNode = new MXMLPropertySpecifierNode(this);
        } else if (specifierDefinition instanceof IEventDefinition) {
            specifierNode = new MXMLEventSpecifierNode(this);
        } else if (specifierDefinition instanceof IStyleDefinition) {
            specifierNode = new MXMLStyleSpecifierNode(this);
        } else if (specifierDefinition instanceof IEffectDefinition) {
            specifierNode = new MXMLEffectSpecifierNode(this);
        }
        if (specifierNode != null) {
            specifierNode.setDefinition(specifierDefinition);
        } else if (this.classReference.isDynamic()) {
            specifierNode = new MXMLPropertySpecifierNode(this);
            ((MXMLPropertySpecifierNode)specifierNode).setDynamicName(specifierName);
        }
        return specifierNode;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        this.processNonDefaultPropertyContentUnit(builder, info);
        this.setChildren(info.getChildNodeList().toArray(new IMXMLNode[0]));
        if (this.isContainer) {
            FlexProject project = builder.getProject();
            builder.addExpressionDependency(project.getUIComponentDescriptorClass());
        }
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getName());
        sb.append('\"');
        return true;
    }
}

