/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.SourceLocation;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.internal.parsing.ISourceFragment;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.tree.as.MemberAccessExpressionNode;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLClassNode;

class MXMLClassNode
extends MXMLExpressionNodeBase
implements IMXMLClassNode {
    private static final Object DEFAULT = null;

    MXMLClassNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLClassID;
    }

    @Override
    public String getName() {
        return "Class";
    }

    @Override
    public ITypeDefinition getValue(ICompilerProject project) {
        IDefinition d;
        assert (this.getExpressionNode() instanceof IExpressionNode) : "getValue() shouldn't be getting called on a non-expression MXMLClassNode";
        IExpressionNode expressionNode = (IExpressionNode)this.getExpressionNode();
        if (expressionNode != null && (d = expressionNode.resolve(project)) instanceof ITypeDefinition) {
            return (ITypeDefinition)d;
        }
        return null;
    }

    @Override
    public MXMLExpressionNodeBase.ExpressionType getExpressionType() {
        return MXMLExpressionNodeBase.ExpressionType.CLASS;
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        NodeBase expressionNode = this.parseExpressionNodeFromFragments(builder, tag, info, DEFAULT);
        this.setExpressionNode(expressionNode);
        if (expressionNode instanceof MemberAccessExpressionNode) {
            ((MemberAccessExpressionNode)expressionNode).setStemAsPackage(true);
        }
        super.initializationComplete(builder, tag, info);
    }

    protected void initializeFromFragments(MXMLTreeBuilder builder, SourceLocation location, ISourceFragment[] fragments) {
        this.setLocation(location);
        FlexProject project = builder.getProject();
        this.setClassReference(project, "Class");
        ITypeDefinition type = builder.getBuiltinType(this.getName());
        MXMLClassDefinitionNode classNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
        NodeBase expressionNode = builder.parseExpressionNode(type, fragments, location, FLAGS, DEFAULT, classNode, true);
        this.setExpressionNode(expressionNode);
        if (expressionNode instanceof MemberAccessExpressionNode) {
            ((MemberAccessExpressionNode)expressionNode).setStemAsPackage(true);
        }
    }

    @Override
    public void initialize(MXMLTreeBuilder builder, SourceLocation location, String type, NodeBase expressionNode) {
        super.initialize(builder, location, type, expressionNode);
        if (expressionNode instanceof MemberAccessExpressionNode) {
            ((MemberAccessExpressionNode)expressionNode).setStemAsPackage(true);
        }
    }
}

