/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.asdoc.IASDocComment;
import com.adobe.flash.compiler.common.ASModifier;
import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.common.IMetaInfo;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.metadata.IMetaTag;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.scopes.MXMLFileScope;
import com.adobe.flash.compiler.internal.scopes.TypeScope;
import com.adobe.flash.compiler.internal.tree.as.ImportNode;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLBindingNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassReferenceNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLDeclarationsNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLImplementsNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLImplicitImportNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLMetadataNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLScriptNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLStyleNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.IStateDefinition;
import com.adobe.flash.compiler.mxml.IStateGroupDefinition;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.StateDefinition;
import com.adobe.flash.compiler.mxml.StateGroupDefinition;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.scopes.IASScope;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.IImportNode;
import com.adobe.flash.compiler.tree.as.IScopedNode;
import com.adobe.flash.compiler.tree.metadata.IMetaTagsNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLClassDefinitionNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLDeclarationsNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLEventSpecifierNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLFileNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLInstanceNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLMetadataNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLReparentNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLScriptNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLSpecifierNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLStateNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLStyleSpecifierNode;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class MXMLClassDefinitionNode
extends MXMLClassReferenceNodeBase
implements IMXMLClassDefinitionNode,
IScopedNode {
    private static final String GENERATED_ID_BASE = "#";
    private IClassDefinition classDefinition;
    private String[] implementedInterfaces;
    private IASScope scope;
    private Map<String, IMXMLInstanceNode> idMap;
    private Map<String, StateDefinition> stateMap;
    private Map<String, StateGroupDefinition> groupMap;
    private List<IMXMLNode> stateDependentNodeList;
    private ArrayListMultimap<String, IMXMLNode> stateDependentNodeMap;
    private String initialState;
    private int generatedIDCounter = 0;
    Map<IMXMLInstanceNode, String> generatedIDMap = new HashMap<IMXMLInstanceNode, String>();
    private IMXMLMetadataNode[] metadataNodes;
    private IMXMLScriptNode[] scriptNodes;
    private IMXMLDeclarationsNode[] declarationsNodes;
    private int componentCount = 0;
    private boolean hasDataBindings;
    private IASDocComment asDocComment;

    MXMLClassDefinitionNode(NodeBase parent) {
        super(parent);
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        super.initializationComplete(builder, tag, info);
        this.reprocessStateNodes();
        this.reprocessStateDependentNodes(builder);
        FlexProject project = builder.getProject();
        IClassDefinition classReference = this.getClassReference(project);
        String qname = classReference.getQualifiedName();
        builder.addDependency(qname, DependencyType.INHERITANCE);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("implements")) {
            String rawValue = attribute.getRawValue();
            if (rawValue != null) {
                this.implementedInterfaces = attribute.getMXMLDialect().splitAndTrim(rawValue);
            }
            MXMLImplementsNode interfaceNode = new MXMLImplementsNode(this);
            interfaceNode.initializeFromAttribute(builder, attribute);
            info.addChildNode(interfaceNode);
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLFileScope fileScope = builder.getFileScope();
        MXMLNodeBase childNode = null;
        if (fileScope.isDeclarationsTag(childTag)) {
            childNode = new MXMLDeclarationsNode(this);
        } else if (fileScope.isScriptTag(childTag) && builder.getMXMLDialect().isEqualToOrAfter(MXMLDialect.MXML_2012)) {
            childNode = new MXMLScriptNode(this);
        } else if (fileScope.isStyleTag(childTag)) {
            childNode = new MXMLStyleNode(this);
        } else if (fileScope.isMetadataTag(childTag)) {
            childNode = new MXMLMetadataNode(this);
        } else if (fileScope.isBindingTag(childTag)) {
            childNode = new MXMLBindingNode(this);
            this.setHasDataBindings();
        } else {
            super.processChildTag(builder, tag, childTag, info);
        }
        if (childNode != null) {
            childNode.initializeFromTag(builder, childTag);
            info.addChildNode(childNode);
        }
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLClassDefinitionID;
    }

    @Override
    public String getPackageName() {
        return this.classDefinition.getPackageName();
    }

    @Override
    public IClassDefinition getClassDefinition() {
        return this.classDefinition;
    }

    void setClassDefinition(IClassDefinition classDefinition) {
        this.classDefinition = classDefinition;
        this.setScope((TypeScope)classDefinition.getContainedScope());
    }

    IMXMLInstanceNode addNodeWithID(String id, IMXMLInstanceNode node) {
        if (this.idMap == null) {
            this.idMap = new HashMap<String, IMXMLInstanceNode>();
        }
        return this.idMap.put(id, node);
    }

    @Override
    public IMXMLInstanceNode getNodeWithID(String id) {
        return this.idMap != null ? this.idMap.get(id) : null;
    }

    @Override
    public Set<String> getStateNames() {
        if (this.stateMap == null) {
            return new HashSet<String>(0);
        }
        return this.stateMap.keySet();
    }

    @Override
    public Set<IStateDefinition> getStates() {
        if (this.stateMap == null) {
            return new HashSet<IStateDefinition>(0);
        }
        HashSet<IStateDefinition> states = new HashSet<IStateDefinition>(this.stateMap.size());
        states.addAll(this.stateMap.values());
        return states;
    }

    public IMXMLStateNode getStateNode(String stateName) {
        if (this.stateMap == null) {
            return null;
        }
        return this.stateMap.get(stateName).getNode();
    }

    @Override
    public IStateDefinition getStateByName(String stateName) {
        if (this.stateMap == null) {
            return null;
        }
        return this.stateMap.get(stateName);
    }

    @Override
    public IStateGroupDefinition getStateGroupByName(String groupName) {
        if (this.groupMap == null) {
            return null;
        }
        return this.groupMap.get(groupName);
    }

    public boolean isState(String stateName) {
        if (this.stateMap == null) {
            return false;
        }
        return this.stateMap.containsKey(stateName);
    }

    @Override
    public Set<String> getStateGroupNames() {
        if (this.groupMap == null) {
            return new HashSet<String>(0);
        }
        return this.groupMap.keySet();
    }

    @Override
    public Set<IStateGroupDefinition> getStateGroups() {
        if (this.groupMap == null) {
            return new HashSet<IStateGroupDefinition>(0);
        }
        HashSet<IStateGroupDefinition> groups = new HashSet<IStateGroupDefinition>(this.groupMap.size());
        groups.addAll(this.groupMap.values());
        return groups;
    }

    private String[] getStatesInGroup(String groupName) {
        return this.groupMap.get(groupName).getIncludedStates();
    }

    private boolean isStateGroup(String groupName) {
        if (this.groupMap == null) {
            return false;
        }
        return this.groupMap.containsKey(groupName);
    }

    @Override
    public List<IMXMLNode> getNodesDependentOnState(String stateName) {
        return this.stateDependentNodeMap != null ? this.stateDependentNodeMap.get((Object)stateName) : null;
    }

    @Override
    public List<IMXMLNode> getAllStateDependentNodes() {
        return this.stateDependentNodeList;
    }

    @Override
    public String getInitialState() {
        return this.initialState;
    }

    private void reprocessStateNodes() {
        Set<String> states = this.getStateNames();
        if (states == null) {
            return;
        }
        for (String state : states) {
            IMXMLStateNode stateNode = this.getStateNode(state);
            String[] stateGroups = stateNode.getStateGroups();
            if (stateGroups == null) continue;
            for (String stateGroup : stateGroups) {
                this.addStateToStateGroup(stateGroup, state);
            }
        }
    }

    private void addStateToStateGroup(String groupName, String stateName) {
        if (this.groupMap == null) {
            this.groupMap = new HashMap<String, StateGroupDefinition>();
        }
        StateDefinition state = this.stateMap.get(stateName);
        StateGroupDefinition group = this.groupMap.get(groupName);
        if (group == null) {
            group = new StateGroupDefinition(groupName, this.getDefinition());
            this.groupMap.put(groupName, group);
        }
        state.addGroup(group);
        group.addState(state);
    }

    private void reprocessStateDependentNodes(MXMLTreeBuilder builder) {
        if (this.stateDependentNodeList == null) {
            return;
        }
        boolean haveInstanceOverride = false;
        boolean havePropertyOverride = false;
        boolean haveStyleOverride = false;
        boolean haveEventOverride = false;
        for (IMXMLNode node : this.stateDependentNodeList) {
            if (node instanceof IMXMLInstanceNode || node instanceof IMXMLReparentNode) {
                haveInstanceOverride = true;
                String[] includeIn = null;
                if (node instanceof IMXMLInstanceNode) {
                    includeIn = ((IMXMLInstanceNode)node).getIncludeIn();
                } else if (node instanceof IMXMLReparentNode) {
                    includeIn = ((IMXMLReparentNode)node).getIncludeIn();
                }
                String[] excludeFrom = null;
                if (node instanceof IMXMLInstanceNode) {
                    excludeFrom = ((IMXMLInstanceNode)node).getExcludeFrom();
                } else if (node instanceof IMXMLReparentNode) {
                    excludeFrom = ((IMXMLReparentNode)node).getExcludeFrom();
                }
                Set<String> statesContainingInstance = null;
                if (includeIn != null) {
                    statesContainingInstance = this.processIncludeIn(includeIn);
                } else if (excludeFrom != null) {
                    statesContainingInstance = this.processExcludeFrom(excludeFrom);
                }
                if (statesContainingInstance == null) continue;
                for (String state : statesContainingInstance) {
                    this.addStateDependentNode(state, node);
                }
                continue;
            }
            if (!(node instanceof IMXMLSpecifierNode)) continue;
            if (node instanceof IMXMLPropertySpecifierNode) {
                havePropertyOverride = true;
            } else if (node instanceof IMXMLStyleSpecifierNode) {
                haveStyleOverride = true;
            } else if (node instanceof IMXMLEventSpecifierNode) {
                haveEventOverride = true;
            }
            String suffix = ((IMXMLSpecifierNode)node).getSuffix();
            if (this.isState(suffix)) {
                this.addStateDependentNode(suffix, node);
                continue;
            }
            if (!this.isStateGroup(suffix)) continue;
            for (String state : this.getStatesInGroup(suffix)) {
                this.addStateDependentNode(state, node);
            }
        }
        FlexProject project = builder.getProject();
        if (haveInstanceOverride) {
            builder.addExpressionDependency(project.getInstanceOverrideClass());
        }
        if (havePropertyOverride) {
            builder.addExpressionDependency(project.getPropertyOverrideClass());
        }
        if (haveStyleOverride) {
            builder.addExpressionDependency(project.getStyleOverrideClass());
        }
        if (haveEventOverride) {
            builder.addExpressionDependency(project.getEventOverrideClass());
        }
    }

    private Set<String> processIncludeIn(String[] includeIn) {
        HashSet<String> applicableStates = new HashSet<String>();
        for (String item : includeIn) {
            if (this.isState(item)) {
                applicableStates.add(item);
                continue;
            }
            if (!this.isStateGroup(item)) continue;
            for (String state : this.getStatesInGroup(item)) {
                applicableStates.add(state);
            }
        }
        return applicableStates;
    }

    private Set<String> processExcludeFrom(String[] excludeFrom) {
        HashSet<String> applicableStates = new HashSet<String>();
        for (String state : this.getStateNames()) {
            applicableStates.add(state);
        }
        for (String item : excludeFrom) {
            if (this.isState(item)) {
                applicableStates.remove(item);
                continue;
            }
            if (!this.isStateGroup(item)) continue;
            for (String state : this.getStatesInGroup(item)) {
                applicableStates.remove(state);
            }
        }
        return applicableStates;
    }

    void generateID(IMXMLInstanceNode instanceNode) {
        if (instanceNode != null && instanceNode.getID() == null) {
            String id = GENERATED_ID_BASE + this.generatedIDCounter++;
            this.generatedIDMap.put(instanceNode, id);
        }
    }

    void addStateDependentNode(MXMLTreeBuilder builder, IMXMLNode node) {
        if (this.stateDependentNodeList == null) {
            this.stateDependentNodeList = new ArrayList<IMXMLNode>();
        }
        this.stateDependentNodeList.add(node);
        IMXMLInstanceNode instanceNode = null;
        if (node instanceof IMXMLInstanceNode) {
            instanceNode = (IMXMLInstanceNode)node;
        } else if (node instanceof IMXMLSpecifierNode && node.getParent() instanceof IMXMLInstanceNode) {
            instanceNode = (IMXMLInstanceNode)node.getParent();
        }
        this.generateID(instanceNode);
    }

    @Override
    public String getGeneratedID(IMXMLInstanceNode instanceNode) {
        return this.generatedIDMap.get(instanceNode);
    }

    private void addStateDependentNode(String state, IMXMLNode node) {
        if (this.stateDependentNodeMap == null) {
            this.stateDependentNodeMap = ArrayListMultimap.create();
        }
        this.stateDependentNodeMap.put((Object)state, (Object)node);
    }

    IMXMLStateNode addStateNode(IMXMLStateNode node) {
        StateDefinition oldState;
        if (this.stateMap == null) {
            this.stateMap = new HashMap<String, StateDefinition>();
            this.initialState = node.getStateName();
        }
        return (oldState = this.stateMap.put(node.getStateName(), (StateDefinition)node.getDefinition())) != null ? oldState.getNode() : null;
    }

    @Override
    public IMXMLMetadataNode[] getMetadataNodes() {
        return this.metadataNodes;
    }

    @Override
    public IMXMLScriptNode[] getScriptNodes() {
        return this.scriptNodes;
    }

    @Override
    public IMXMLDeclarationsNode[] getDeclarationsNodes() {
        return this.declarationsNodes;
    }

    @Override
    void setChildren(IMXMLNode[] children) {
        super.setChildren(children);
        if (children != null) {
            ArrayList<IMXMLMetadataNode> metadataNodes = new ArrayList<IMXMLMetadataNode>();
            ArrayList<IMXMLScriptNode> scriptNodes = new ArrayList<IMXMLScriptNode>();
            ArrayList<IMXMLDeclarationsNode> declarationsNodes = new ArrayList<IMXMLDeclarationsNode>();
            for (IMXMLNode child : children) {
                if (child instanceof IMXMLMetadataNode) {
                    metadataNodes.add((IMXMLMetadataNode)child);
                    continue;
                }
                if (child instanceof IMXMLScriptNode) {
                    scriptNodes.add((IMXMLScriptNode)child);
                    continue;
                }
                if (!(child instanceof IMXMLDeclarationsNode)) continue;
                declarationsNodes.add((IMXMLDeclarationsNode)child);
            }
            this.metadataNodes = metadataNodes.toArray(new IMXMLMetadataNode[0]);
            this.scriptNodes = scriptNodes.toArray(new IMXMLScriptNode[0]);
            this.declarationsNodes = declarationsNodes.toArray(new IMXMLDeclarationsNode[0]);
        }
    }

    @Override
    public IScopedNode getScopedNode() {
        return this;
    }

    @Override
    public IASScope getScope() {
        return this.scope;
    }

    public void setScope(TypeScope scope) {
        this.scope = scope;
    }

    @Override
    public void getAllImports(Collection<String> imports) {
        ArrayList<IImportNode> importNodes = new ArrayList<IImportNode>();
        this.getAllImportNodes(importNodes);
        for (IImportNode importNode : importNodes) {
            imports.add(importNode.getImportName());
        }
    }

    @Override
    public void getAllImportNodes(Collection<IImportNode> imports) {
        IMXMLFileNode fileNode = (IMXMLFileNode)this.getAncestorOfType(IMXMLFileNode.class);
        ICompilerProject project = fileNode.getCompilerProject();
        for (String qname : ((ClassDefinition)this.classDefinition).getImplicitImports()) {
            imports.add(new MXMLImplicitImportNode(project, qname));
        }
        fileNode.getAllImportNodes(imports);
        for (IMXMLScriptNode scriptNode : this.getScriptNodes()) {
            for (IASNode node : scriptNode.getASNodes()) {
                if (node instanceof ImportNode) {
                    imports.add((IImportNode)node);
                    continue;
                }
                ((NodeBase)node).collectImportNodes(imports);
            }
        }
    }

    @Override
    public IExpressionNode getNameExpressionNode() {
        return null;
    }

    @Override
    public int getNameStart() {
        return -1;
    }

    @Override
    public int getNameEnd() {
        return -1;
    }

    @Override
    public int getNameAbsoluteStart() {
        return this.getNameStart();
    }

    @Override
    public int getNameAbsoluteEnd() {
        return this.getNameEnd();
    }

    @Override
    public String getQualifiedName() {
        return this.classDefinition.getQualifiedName();
    }

    @Override
    public String getShortName() {
        return this.classDefinition.getBaseName();
    }

    @Override
    public boolean hasModifier(ASModifier modifier) {
        return this.classDefinition.hasModifier(modifier);
    }

    @Override
    public boolean hasNamespace(String namespace) {
        return this.getNamespace().equals(namespace);
    }

    @Override
    public String getNamespace() {
        return "public";
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public IMetaTagsNode getMetaTags() {
        return null;
    }

    @Override
    public IMetaInfo[] getMetaInfos() {
        return this.classDefinition.getAllMetaTags();
    }

    @Override
    public IClassDefinition getDefinition() {
        return this.classDefinition;
    }

    private void dumpStateDependentNodes() {
        Set<String> states = this.getStateNames();
        if (states == null) {
            return;
        }
        for (String state : states) {
            System.out.println("State " + state);
            List<IMXMLNode> nodes = this.getNodesDependentOnState(state);
            if (nodes == null) continue;
            for (IMXMLNode node : nodes) {
                System.out.println("  " + node);
            }
        }
    }

    @Override
    public String getBaseClassName() {
        return this.getDefinition().getBaseClassAsDisplayString();
    }

    @Override
    public String[] getImplementedInterfaces() {
        return this.getDefinition().getImplementedInterfacesAsDisplayStrings();
    }

    @Override
    public IMetaTag[] getMetaTagsByName(String name) {
        return this.getDefinition().getMetaTagsByName(name);
    }

    @Override
    public IClassDefinition.ClassClassification getClassClassification() {
        return IClassDefinition.ClassClassification.PACKAGE_MEMBER;
    }

    @Override
    public IASDocComment getASDocComment() {
        return this.asDocComment;
    }

    @Override
    public boolean hasExplicitComment() {
        return this.asDocComment != null;
    }

    String addComponent() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getShortName());
        sb.append("InnerClass");
        sb.append(this.componentCount);
        ++this.componentCount;
        return sb.toString();
    }

    @Override
    public boolean needsDescriptor() {
        return this.isContainer();
    }

    @Override
    public boolean needsDocumentDescriptor() {
        return this.isContainer();
    }

    public void setHasDataBindings() {
        this.hasDataBindings = true;
    }

    @Override
    public boolean getHasDataBindings() {
        return this.hasDataBindings;
    }

    public void setASDocComment(IASDocComment ref) {
        this.asDocComment = ref;
    }
}

