/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLBindingAttributeNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.problems.MXMLEmptyAttributeProblem;
import com.adobe.flash.compiler.problems.MXMLRequiredAttributeProblem;
import com.adobe.flash.compiler.problems.MXMLSameBindingSourceAndDestinationProblem;
import com.adobe.flash.compiler.problems.MXMLSemanticProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLBindingAttributeNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLBindingNode;

class MXMLBindingNode
extends MXMLNodeBase
implements IMXMLBindingNode {
    private IMXMLBindingAttributeNode[] children = null;
    private MXMLBindingAttributeNode sourceAttributeNode = null;
    private MXMLBindingAttributeNode destinationAttributeNode = null;
    private boolean twoWay = false;

    MXMLBindingNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLBindingID;
    }

    @Override
    public String getName() {
        return "Binding";
    }

    @Override
    public int getChildCount() {
        return this.children != null ? this.children.length : 0;
    }

    @Override
    public IASNode getChild(int i) {
        return this.children != null ? this.children[i] : null;
    }

    @Override
    protected MXMLNodeBase.MXMLNodeInfo createNodeInfo(MXMLTreeBuilder builder) {
        return new MXMLNodeBase.MXMLNodeInfo(builder);
    }

    @Override
    protected void processTagSpecificAttribute(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagAttributeData attribute, MXMLNodeBase.MXMLNodeInfo info) {
        if (attribute.isSpecialAttribute("source")) {
            this.sourceAttributeNode = new MXMLBindingAttributeNode(this);
            this.sourceAttributeNode.initializeFromAttribute(builder, attribute);
            info.addChildNode(this.sourceAttributeNode);
        } else if (attribute.isSpecialAttribute("destination")) {
            this.destinationAttributeNode = new MXMLBindingAttributeNode(this);
            this.destinationAttributeNode.initializeFromAttribute(builder, attribute);
            info.addChildNode(this.destinationAttributeNode);
        } else if (attribute.isSpecialAttribute("twoWay")) {
            String value = attribute.getMXMLDialect().trim(attribute.getRawValue());
            if (value.equals("true")) {
                this.twoWay = true;
            } else if (value.equals("false")) {
                this.twoWay = false;
            }
        } else {
            super.processTagSpecificAttribute(builder, tag, attribute, info);
        }
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        MXMLSemanticProblem problem;
        super.initializationComplete(builder, tag, info);
        this.children = info.getChildNodeList().toArray(new IMXMLBindingAttributeNode[0]);
        FlexProject project = builder.getProject();
        builder.addExpressionDependency(project.getBindingManagerClass());
        MXMLTagAttributeData sourceAttribute = tag.getTagAttributeData("source");
        MXMLTagAttributeData destinationAttribute = tag.getTagAttributeData("destination");
        String trimmedSourceValue = null;
        String trimmedDestinationValue = null;
        if (sourceAttribute == null) {
            problem = new MXMLRequiredAttributeProblem(tag, "source");
            builder.addProblem(problem);
            this.markInvalidForCodeGen();
        } else {
            trimmedSourceValue = builder.getMXMLDialect().trim(sourceAttribute.getRawValue());
            if (trimmedSourceValue.isEmpty()) {
                problem = new MXMLEmptyAttributeProblem(sourceAttribute);
                builder.addProblem(problem);
                this.markInvalidForCodeGen();
            }
        }
        if (destinationAttribute == null) {
            problem = new MXMLRequiredAttributeProblem(tag, "destination");
            builder.addProblem(problem);
            this.markInvalidForCodeGen();
        } else {
            trimmedDestinationValue = builder.getMXMLDialect().trim(destinationAttribute.getRawValue());
            if (trimmedDestinationValue.isEmpty()) {
                problem = new MXMLEmptyAttributeProblem(destinationAttribute);
                builder.addProblem(problem);
                this.markInvalidForCodeGen();
            }
        }
        if (trimmedSourceValue != null && !trimmedSourceValue.isEmpty() && trimmedDestinationValue != null && !trimmedDestinationValue.isEmpty() && trimmedSourceValue.equals(trimmedDestinationValue)) {
            problem = new MXMLSameBindingSourceAndDestinationProblem(tag);
            builder.addProblem(problem);
            this.markInvalidForCodeGen();
        }
    }

    @Override
    public IMXMLBindingAttributeNode getSourceAttributeNode() {
        return this.sourceAttributeNode;
    }

    @Override
    public IMXMLBindingAttributeNode getDestinationAttributeNode() {
        return this.destinationAttributeNode;
    }

    @Override
    public boolean getTwoWay() {
        return this.twoWay;
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append("twoWay");
        sb.append('=');
        sb.append('\"');
        sb.append(this.twoWay);
        sb.append('\"');
        return true;
    }

    void setDestinationAttributeNode(MXMLBindingAttributeNode dest) {
        this.destinationAttributeNode = dest;
    }

    void setSourceAttributeNode(MXMLBindingAttributeNode src) {
        this.sourceAttributeNode = src;
    }
}

