/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.internal.parsing.ISourceFragment;
import com.adobe.flash.compiler.internal.parsing.SourceFragment;
import com.adobe.flash.compiler.internal.parsing.SourceFragmentsReader;
import com.adobe.flash.compiler.internal.parsing.as.ASParser;
import com.adobe.flash.compiler.internal.parsing.as.OffsetLookup;
import com.adobe.flash.compiler.internal.scopes.MXMLFileScope;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.internal.workspaces.Workspace;
import com.adobe.flash.compiler.mxml.MXMLTagAttributeData;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLBindingAttributeNode;
import java.util.Collection;

class MXMLBindingAttributeNode
extends MXMLNodeBase
implements IMXMLBindingAttributeNode {
    private String attributeName;
    private IExpressionNode expressionNode;

    MXMLBindingAttributeNode(NodeBase parent) {
        super(parent);
    }

    MXMLBindingAttributeNode(NodeBase parent, IExpressionNode expr) {
        super(parent);
        this.expressionNode = expr;
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLBindingAttributeID;
    }

    @Override
    public String getName() {
        return this.attributeName;
    }

    @Override
    public int getChildCount() {
        return this.expressionNode != null ? 1 : 0;
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.expressionNode : null;
    }

    @Override
    public IExpressionNode getExpressionNode() {
        return this.expressionNode;
    }

    public void initializeFromAttribute(MXMLTreeBuilder builder, MXMLTagAttributeData attribute) {
        this.attributeName = attribute.getName();
        this.setLocation(attribute);
        this.expressionNode = this.createExpressionNode(builder, attribute);
        if (this.expressionNode != null) {
            ((ExpressionNodeBase)this.expressionNode).setParent(this);
        }
    }

    private IExpressionNode createExpressionNode(MXMLTreeBuilder builder, MXMLTagAttributeData attribute) {
        Workspace workspace = builder.getWorkspace();
        Collection<ICompilerProblem> problems = builder.getProblems();
        ISourceFragment[] fragments = attribute.getValueFragments(problems);
        MXMLFileScope fileScope = builder.getFileScope();
        OffsetLookup offsetLookup = fileScope.getOffsetLookup();
        assert (offsetLookup != null) : "Expected OffsetLookup on FileScope.";
        for (ISourceFragment fragment : fragments) {
            int physicalStart = fragment.getPhysicalStart();
            int[] absoluteOffsets = offsetLookup.getAbsoluteOffset(attribute.getSourcePath(), physicalStart);
            ((SourceFragment)fragment).setPhysicalStart(absoluteOffsets[0]);
        }
        SourceFragmentsReader reader = new SourceFragmentsReader(attribute.getSourcePath(), fragments);
        return ASParser.parseDataBinding(workspace, reader, problems);
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getName());
        sb.append('\"');
        return true;
    }
}

