/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.mxml;

import com.adobe.flash.compiler.common.SourceLocation;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.definitions.IVariableDefinition;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.mxml.MXMLDialect;
import com.adobe.flash.compiler.internal.parsing.ISourceFragment;
import com.adobe.flash.compiler.internal.parsing.SourceFragmentsReader;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLBooleanNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLClassDefinitionNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLInstanceNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLIntNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLLiteralNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNodeBase;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLNumberNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLScriptNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLStringNode;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLTreeBuilder;
import com.adobe.flash.compiler.internal.tree.mxml.MXMLUintNode;
import com.adobe.flash.compiler.mxml.MXMLTagData;
import com.adobe.flash.compiler.mxml.MXMLTextData;
import com.adobe.flash.compiler.mxml.MXMLUnitData;
import com.adobe.flash.compiler.problems.MXMLIncompatibleArrayElementProblem;
import com.adobe.flash.compiler.problems.MXMLUnexpectedTagProblem;
import com.adobe.flash.compiler.problems.MXMLUnresolvedTagProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.mxml.IMXMLArrayNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLPropertySpecifierNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

class MXMLArrayNode
extends MXMLInstanceNode
implements IMXMLArrayNode {
    protected static final EnumSet<MXMLDialect.TextParsingFlags> FLAGS = EnumSet.of(MXMLDialect.TextParsingFlags.ALLOW_BINDING, MXMLDialect.TextParsingFlags.ALLOW_COMPILER_DIRECTIVE);
    private String propertyName;
    private String arrayElementType;

    MXMLArrayNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLArrayID;
    }

    @Override
    public String getName() {
        return "Array";
    }

    @Override
    protected final void initializeFromTag(MXMLTreeBuilder builder, MXMLTagData tag) {
        IMXMLNode parent = (IMXMLNode)this.getParent();
        if (parent instanceof IMXMLPropertySpecifierNode) {
            this.propertyName = ((IMXMLPropertySpecifierNode)parent).getName();
            IVariableDefinition propertyDefinition = (IVariableDefinition)((IMXMLPropertySpecifierNode)parent).getDefinition();
            FlexProject project = builder.getProject();
            this.arrayElementType = propertyDefinition.getArrayElementType(project);
        }
        super.initializeFromTag(builder, tag);
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        this.processFragments(builder, info);
        if (builder.getFileScope().isScriptTag(childTag)) {
            builder.addProblem(new MXMLUnexpectedTagProblem(childTag));
            return;
        }
        FlexProject project = builder.getProject();
        String tagName = builder.getFileScope().resolveTagToQualifiedName(childTag);
        if (tagName == null) {
            builder.addProblem(new MXMLUnresolvedTagProblem(childTag));
            return;
        }
        IDefinition definition = project.getScope().findDefinitionByName(tagName);
        if (definition instanceof ClassDefinition) {
            MXMLInstanceNode instanceNode = MXMLInstanceNode.createInstanceNode(builder, tagName, this);
            instanceNode.setClassReference(project, (ClassDefinition)definition);
            instanceNode.initializeFromTag(builder, childTag);
            info.addChildNode(instanceNode);
            if (this.arrayElementType != null && !((ClassDefinition)definition).isInstanceOf(this.arrayElementType, (ICompilerProject)project)) {
                MXMLIncompatibleArrayElementProblem problem = new MXMLIncompatibleArrayElementProblem(childTag, this.propertyName, this.arrayElementType, definition.getQualifiedName());
                builder.addProblem(problem);
            }
        }
    }

    @Override
    protected void processChildWhitespaceUnit(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        this.accumulateTextFragments(builder, text, info);
    }

    @Override
    protected void processChildNonWhitespaceUnit(MXMLTreeBuilder builder, MXMLTagData tag, MXMLTextData text, MXMLNodeBase.MXMLNodeInfo info) {
        this.accumulateTextFragments(builder, text, info);
    }

    @Override
    protected void initializationComplete(MXMLTreeBuilder builder, MXMLTagData tag, MXMLNodeBase.MXMLNodeInfo info) {
        this.processFragments(builder, info);
        this.setChildren(info.getChildNodeList().toArray(new MXMLInstanceNode[0]));
    }

    private void processFragments(MXMLTreeBuilder builder, MXMLNodeBase.MXMLNodeInfo info) {
        ISourceFragment[] fragments = info.getSourceFragments();
        String text = SourceFragmentsReader.concatLogicalText(fragments);
        if (!builder.getMXMLDialect().isWhitespace(text)) {
            ITypeDefinition type = builder.getBuiltinType("*");
            SourceLocation location = info.getSourceLocation();
            MXMLClassDefinitionNode classNode = (MXMLClassDefinitionNode)this.getClassDefinitionNode();
            MXMLInstanceNode instanceNode = builder.createInstanceNode(this, type, fragments, location, FLAGS, classNode);
            info.addChildNode(instanceNode);
        }
        info.clearFragments();
    }

    void initializeDefaultProperty(MXMLTreeBuilder builder, IVariableDefinition defaultPropertyDefinition, List<MXMLUnitData> contentUnits) {
        FlexProject project = builder.getProject();
        this.setLocation(builder, contentUnits);
        this.setClassReference(project, "Array");
        ArrayList<MXMLNodeBase> children = new ArrayList<MXMLNodeBase>();
        for (MXMLUnitData unit : contentUnits) {
            if (!(unit instanceof MXMLTagData)) continue;
            MXMLTagData tag = (MXMLTagData)unit;
            if (builder.getFileScope().isScriptTag(tag)) {
                MXMLScriptNode scriptNode = new MXMLScriptNode(this);
                scriptNode.initializeFromTag(builder, tag);
                children.add(scriptNode);
                continue;
            }
            IDefinition definition = builder.getFileScope().resolveTagToDefinition(tag);
            if (!(definition instanceof IClassDefinition)) continue;
            MXMLInstanceNode childNode = MXMLInstanceNode.createInstanceNode(builder, definition.getQualifiedName(), this);
            childNode.setClassReference(project, (ClassDefinition)definition);
            childNode.initializeFromTag(builder, tag);
            children.add(childNode);
        }
        this.setChildren(children.toArray(new IMXMLNode[0]));
    }

    public void initialize(MXMLTreeBuilder builder, SourceLocation location, List<?> value) {
        this.setLocation(location);
        this.setClassReference(builder.getProject(), "Array");
        ArrayList<MXMLExpressionNodeBase> childList = new ArrayList<MXMLExpressionNodeBase>();
        for (Object element : value) {
            MXMLLiteralNode literalNode;
            if (element instanceof Boolean) {
                MXMLBooleanNode booleanNode = new MXMLBooleanNode(this);
                literalNode = new MXMLLiteralNode(booleanNode, element);
                literalNode.setLocation(location);
                booleanNode.initialize(builder, location, "Boolean", literalNode);
                childList.add(booleanNode);
                continue;
            }
            if (element instanceof Integer) {
                MXMLIntNode intNode = new MXMLIntNode(this);
                literalNode = new MXMLLiteralNode(intNode, element);
                literalNode.setLocation(location);
                intNode.initialize(builder, location, "int", literalNode);
                childList.add(intNode);
                continue;
            }
            if (element instanceof Long) {
                MXMLUintNode uintNode = new MXMLUintNode(this);
                literalNode = new MXMLLiteralNode(uintNode, element);
                literalNode.setLocation(location);
                uintNode.initialize(builder, location, "uint", literalNode);
                childList.add(uintNode);
                continue;
            }
            if (element instanceof Number) {
                MXMLNumberNode numberNode = new MXMLNumberNode(this);
                literalNode = new MXMLLiteralNode(numberNode, element);
                literalNode.setLocation(location);
                numberNode.initialize(builder, location, "Number", literalNode);
                childList.add(numberNode);
                continue;
            }
            if (!(element instanceof String)) continue;
            MXMLStringNode stringNode = new MXMLStringNode(this);
            literalNode = new MXMLLiteralNode(stringNode, element);
            literalNode.setLocation(location);
            stringNode.initialize(builder, location, "String", literalNode);
            childList.add(stringNode);
        }
        this.setChildren(childList.toArray(new IMXMLNode[0]));
    }
}

