/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as.parts;

import com.adobe.flash.compiler.asdoc.IASDocComment;
import com.adobe.flash.compiler.internal.tree.as.ModifiersContainerNode;
import com.adobe.flash.compiler.internal.tree.as.metadata.MetaTagsNode;
import com.adobe.flash.compiler.internal.tree.as.parts.IDecorationPart;
import com.adobe.flash.compiler.tree.as.INamespaceDecorationNode;
import com.adobe.flash.utils.CheapArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DecorationPart
implements IDecorationPart {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private byte modId;
    private byte metaId;
    private byte namespaceId;
    private byte commentId;
    private Object store = CheapArray.create(2);

    public DecorationPart() {
        this.metaId = (byte)-1;
        this.modId = (byte)-1;
        this.namespaceId = (byte)-1;
        this.commentId = (byte)-1;
    }

    @Override
    public void compact() {
        if (this.store instanceof List) {
            this.store = CheapArray.optimize(this.store, EMPTY_ARRAY);
        }
    }

    protected byte insert(Object object) {
        if (object == null) {
            return -1;
        }
        byte id = (byte)CheapArray.size(this.store);
        if (!(this.store instanceof List)) {
            ArrayList<Object> list = new ArrayList<Object>(((Object[])this.store).length);
            list.addAll(Arrays.asList((Object[])this.store));
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object entry = list.get(i);
                if (entry instanceof INamespaceDecorationNode) {
                    this.namespaceId = (byte)i;
                    continue;
                }
                if (entry instanceof MetaTagsNode) {
                    this.metaId = (byte)i;
                    continue;
                }
                if (entry instanceof IASDocComment) {
                    this.commentId = (byte)i;
                    continue;
                }
                if (entry instanceof ModifiersContainerNode) {
                    this.modId = (byte)i;
                    continue;
                }
                this.insertUnknownObject(entry, i);
            }
            this.store = list;
        }
        CheapArray.add(object, this.store);
        return id;
    }

    protected Object getFromStore(byte index) {
        if (index >= 0) {
            return CheapArray.get(index, this.store);
        }
        return null;
    }

    protected void insertUnknownObject(Object entry, int offset) {
    }

    @Override
    public void setASDocComment(IASDocComment ref) {
        this.commentId = this.insert(ref);
    }

    @Override
    public IASDocComment getASDocComment() {
        Object object;
        if (this.commentId >= 0 && (object = CheapArray.get(this.commentId, this.store)) instanceof IASDocComment) {
            return (IASDocComment)object;
        }
        return null;
    }

    @Override
    public void setMetadata(MetaTagsNode meta) {
        this.metaId = this.insert(meta);
    }

    @Override
    public MetaTagsNode getMetadata() {
        Object object;
        if (this.metaId >= 0 && (object = CheapArray.get(this.metaId, this.store)) instanceof MetaTagsNode) {
            return (MetaTagsNode)object;
        }
        return null;
    }

    @Override
    public void setModifiers(ModifiersContainerNode set) {
        this.modId = this.insert(set);
    }

    @Override
    public ModifiersContainerNode getModifiers() {
        Object object;
        if (this.modId >= 0 && (object = CheapArray.get(this.modId, this.store)) instanceof ModifiersContainerNode) {
            return (ModifiersContainerNode)object;
        }
        return null;
    }

    @Override
    public void setNamespace(INamespaceDecorationNode ns) {
        this.namespaceId = this.insert(ns);
    }

    @Override
    public INamespaceDecorationNode getNamespace() {
        Object object;
        if (this.namespaceId >= 0 && (object = CheapArray.get(this.namespaceId, this.store)) instanceof INamespaceDecorationNode) {
            return (INamespaceDecorationNode)object;
        }
        return null;
    }
}

