/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.internal.parsing.as.ASToken;
import com.adobe.flash.compiler.internal.tree.as.BaseLiteralContainerNode;
import com.adobe.flash.compiler.internal.tree.as.ContainerNode;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.LiteralNode;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IIdentifierNode;
import com.adobe.flash.compiler.tree.as.ILiteralNode;
import com.adobe.flash.compiler.tree.as.IMemberAccessExpressionNode;
import java.util.ArrayList;
import java.util.List;

public class XMLLiteralNode
extends BaseLiteralContainerNode {
    private List<XMLContentState> states = new ArrayList<XMLContentState>();

    public XMLLiteralNode() {
        super(new LiteralNode(ILiteralNode.LiteralType.XML, ""));
    }

    protected XMLLiteralNode(XMLLiteralNode other) {
        super(other);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.XMLContentID;
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.XML);
    }

    @Override
    protected XMLLiteralNode copy() {
        return new XMLLiteralNode(this);
    }

    @Override
    public boolean isDynamicExpression(ICompilerProject project) {
        return true;
    }

    @Override
    public ILiteralNode.LiteralType getLiteralType() {
        return ILiteralNode.LiteralType.XML;
    }

    public final String getText() {
        StringBuilder result = new StringBuilder();
        ContainerNode contents = this.getContentsNode();
        for (int i = 0; i < contents.getChildCount(); ++i) {
            IASNode element = contents.getChild(i);
            if (element instanceof LiteralNode) {
                result.append(((LiteralNode)element).getValue());
                continue;
            }
            if (element instanceof IIdentifierNode) {
                result.append("{").append(((IIdentifierNode)element).getName()).append("}");
                continue;
            }
            if (!(element instanceof IMemberAccessExpressionNode)) continue;
            result.append("{").append(((IMemberAccessExpressionNode)element).getDisplayString()).append("}");
        }
        return result.toString();
    }

    public XMLContentState[] getXMLContentStateMatrix() {
        assert (this.states.size() == this.getContentsNode().getChildCount()) : "Mismatched xml states and children";
        return this.states.toArray(new XMLContentState[0]);
    }

    @Override
    public void appendLiteralToken(ASToken token) {
        boolean isNewEntry;
        int count = this.getContentsNode().getChildCount();
        XMLContentState prevState = null;
        XMLContentState newState = null;
        if (this.states.size() > 0) {
            prevState = this.states.get(this.states.size() - 1);
        }
        super.appendLiteralToken(token);
        boolean bl = isNewEntry = this.getContentsNode().getChildCount() > count;
        if (token.isE4X()) {
            block0 : switch (token.getType()) {
                case 140: {
                    newState = XMLContentState.TagStart;
                    break;
                }
                case 138: {
                    newState = XMLContentState.TagName;
                    break;
                }
                case 139: {
                    if (token.getText().length() > 2) {
                        newState = XMLContentState.TagName;
                        break;
                    }
                    newState = XMLContentState.TagStart;
                    break;
                }
                case 142: 
                case 143: {
                    newState = XMLContentState.TagEnd;
                    break;
                }
                case 146: 
                case 147: {
                    newState = XMLContentState.Attr;
                    break;
                }
                case 144: {
                    newState = XMLContentState.AttrWithEquals;
                    break;
                }
                case 141: {
                    if (prevState == XMLContentState.TagStart) {
                        newState = XMLContentState.TagName;
                        break;
                    }
                    newState = XMLContentState.Attr;
                    break;
                }
                case 129: {
                    if (!isNewEntry) break;
                    newState = XMLContentState.ContentLiteral;
                    break;
                }
                default: {
                    if (prevState == null) {
                        if (token.getText().startsWith("<")) {
                            newState = XMLContentState.TagStart;
                            break;
                        }
                        newState = XMLContentState.ContentLiteral;
                        break;
                    }
                    switch (prevState) {
                        case Attr: 
                        case AttrWithEquals: {
                            newState = XMLContentState.Value;
                            break block0;
                        }
                    }
                    newState = XMLContentState.ContentLiteral;
                }
            }
        }
        this.setLastState(newState);
    }

    private void setLastState(XMLContentState lastState) {
        if (lastState == null) {
            return;
        }
        int childCount = this.getContentsNode().getChildCount();
        if (this.states.size() < childCount) {
            this.states.add(lastState);
        } else {
            this.states.set(childCount - 1, lastState);
        }
    }

    @Override
    public void appendXMLExpression(ExpressionNodeBase e) {
        super.appendXMLExpression(e);
        if (this.states.size() > 0) {
            XMLContentState state = null;
            switch (this.states.get(this.states.size() - 1)) {
                case TagStart: {
                    state = XMLContentState.TagName;
                    break;
                }
                case TagName: 
                case Value: {
                    state = XMLContentState.Attr;
                    break;
                }
                case Attr: {
                    state = XMLContentState.ValueNeedsEquals;
                    break;
                }
                case AttrWithEquals: {
                    state = XMLContentState.Value;
                    break;
                }
                case TagEnd: 
                case ContentLiteral: 
                case ContentExpression: {
                    state = XMLContentState.ContentExpression;
                    break;
                }
                default: {
                    assert (false) : "Unhandled case " + (Object)((Object)this.states.get(this.states.size() - 1));
                    break;
                }
            }
            this.setLastState(state);
        }
    }

    public static enum XMLContentState {
        TagStart,
        TagName,
        Attr,
        AttrWithEquals,
        ValueNeedsEquals,
        Value,
        TagEnd,
        ContentLiteral,
        ContentExpression;

    }
}

