/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.common.ASImportTarget;
import com.adobe.flash.compiler.common.IImportTarget;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.IVariableDefinition;
import com.adobe.flash.compiler.internal.definitions.DefinitionBase;
import com.adobe.flash.compiler.internal.tree.as.BaseVariableNode;
import com.adobe.flash.compiler.internal.tree.as.ChainedVariableNode;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.FileNode;
import com.adobe.flash.compiler.internal.tree.as.IdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.PackageNode;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.ICommonClassNode;
import com.adobe.flash.compiler.tree.as.IInterfaceNode;
import com.adobe.flash.compiler.tree.as.ILanguageIdentifierNode;
import com.adobe.flash.compiler.tree.as.IScopedNode;
import com.adobe.flash.compiler.tree.as.IVariableNode;
import com.adobe.flash.compiler.tree.as.decorators.IVariableTypeDecorator;
import com.adobe.flash.compiler.tree.as.decorators.SymbolDecoratorProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VariableNode
extends BaseVariableNode {
    private List<ChainedVariableNode> chainedVariableNodes = null;

    public VariableNode(IdentifierNode nameNode, ExpressionNodeBase typeNode) {
        super(nameNode, typeNode);
    }

    public VariableNode(IdentifierNode nameNode) {
        super(nameNode);
    }

    @Override
    public ASTNodeID getNodeID() {
        List<String> eventNames;
        ASTNodeID nodeID = ASTNodeID.VariableID;
        DefinitionBase varDef = this.getDefinition();
        if (varDef != null && varDef.isBindable() && (eventNames = varDef.getBindableEventNames()).size() == 0) {
            nodeID = ASTNodeID.BindableVariableID;
        }
        return nodeID;
    }

    @Override
    public int getSpanningStart() {
        return this.getNodeStartForTooling();
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        super.setChildren(fillInOffsets);
        if (this.chainedVariableNodes != null) {
            int l = this.chainedVariableNodes.size();
            for (int i = 0; i < l; ++i) {
                this.addChildInOrder(this.chainedVariableNodes.get(i), fillInOffsets);
            }
            this.chainedVariableNodes = null;
        }
    }

    @Override
    protected int getInitialChildCount() {
        return 3;
    }

    @Override
    public String getVariableType() {
        DefinitionBase definition = this.getDefinition();
        List<IVariableTypeDecorator> list = SymbolDecoratorProvider.getProvider().getVariableTypeDecorators(definition);
        if (list.size() > 0) {
            Iterator<IVariableTypeDecorator> it = list.iterator();
            while (it.hasNext()) {
                IDefinition type = it.next().decorateVariableType(definition);
                if (type == null) continue;
                return type.getQualifiedName();
            }
        }
        return super.getVariableType();
    }

    @Override
    public boolean isImplicit() {
        return this.nameNode instanceof ILanguageIdentifierNode && (((ILanguageIdentifierNode)((Object)this.nameNode)).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.THIS || ((ILanguageIdentifierNode)((Object)this.nameNode)).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.SUPER);
    }

    @Override
    public String getQualifiedName() {
        String qualifiedName = null;
        if (this.getVariableClassification() == IVariableDefinition.VariableClassification.PACKAGE_MEMBER) {
            IImportTarget importTarget = ASImportTarget.buildImportFromPackageName(this.getWorkspace(), this.getPackageName());
            qualifiedName = importTarget.getQualifiedName(this.getName());
        }
        if (qualifiedName == null) {
            qualifiedName = this.getName();
        }
        return qualifiedName;
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    @Override
    public IVariableDefinition.VariableClassification getVariableClassification() {
        IScopedNode scopedNode = this.getScopeNode();
        IScopedNode node = scopedNode;
        if (node != null) {
            if (node instanceof ICommonClassNode || node.getParent() instanceof ICommonClassNode) {
                return IVariableDefinition.VariableClassification.CLASS_MEMBER;
            }
            if (node.getParent() instanceof IInterfaceNode) {
                return IVariableDefinition.VariableClassification.INTERFACE_MEMBER;
            }
            if (node.getParent() instanceof PackageNode) {
                return IVariableDefinition.VariableClassification.PACKAGE_MEMBER;
            }
            if (node instanceof FileNode) {
                return IVariableDefinition.VariableClassification.FILE_MEMBER;
            }
        }
        return IVariableDefinition.VariableClassification.LOCAL;
    }

    @Override
    public int getDeclarationEnd() {
        int varEnd = this.getEnd();
        if (!(this.getParent() instanceof IVariableNode)) {
            int numChildren = this.getChildCount();
            for (int i = 0; i < numChildren; ++i) {
                IASNode child = this.getChild(i);
                if (!(child instanceof IVariableNode) || i <= 0) continue;
                varEnd = this.getChild(i - 1).getEnd();
                break;
            }
        }
        return varEnd;
    }

    public void addChainedVariableNode(ChainedVariableNode node) {
        if (this.chainedVariableNodes == null) {
            this.chainedVariableNodes = new ArrayList<ChainedVariableNode>();
        }
        this.chainedVariableNodes.add(node);
    }
}

