/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.internal.definitions.NamespaceDefinition;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.FixedChildrenNode;
import com.adobe.flash.compiler.internal.tree.as.FullNameNode;
import com.adobe.flash.compiler.internal.tree.as.MemberAccessExpressionNode;
import com.adobe.flash.compiler.internal.tree.as.NamespaceIdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.as.QualifiedNamespaceExpressionNode;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IIdentifierNode;
import com.adobe.flash.compiler.tree.as.INamespaceDecorationNode;
import com.adobe.flash.compiler.tree.as.IUseNamespaceNode;
import java.util.Collection;
import java.util.EnumSet;

public class UseNamespaceNode
extends FixedChildrenNode
implements IUseNamespaceNode {
    protected INamespaceDecorationNode namespaceNode;

    public UseNamespaceNode(ExpressionNodeBase namespace) {
        this.setTargetNamespace(namespace);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.UseID;
    }

    @Override
    public int getChildCount() {
        return this.namespaceNode != null ? 1 : 0;
    }

    @Override
    public IASNode getChild(int i) {
        if (i == 0) {
            return this.namespaceNode;
        }
        return null;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        if (this.namespaceNode != null) {
            ((NodeBase)((Object)this.namespaceNode)).normalize(fillInOffsets);
            ((NodeBase)((Object)this.namespaceNode)).setParent(this);
        }
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        if (set.contains((Object)PostProcessStep.POPULATE_SCOPE)) {
            NamespaceDefinition.addUseNamespaceDirectiveToScope(scope, this.getTargetNamespaceNode());
        }
    }

    @Override
    public INamespaceDecorationNode getTargetNamespaceNode() {
        return this.namespaceNode;
    }

    @Override
    public String getTargetNamespace() {
        return this.namespaceNode != null ? this.namespaceNode.getName() : "";
    }

    public void setTargetNamespace(ExpressionNodeBase namespace) {
        if (namespace != null) {
            if (namespace instanceof FullNameNode) {
                this.namespaceNode = new QualifiedNamespaceExpressionNode((MemberAccessExpressionNode)((FullNameNode)namespace));
            } else {
                this.namespaceNode = new NamespaceIdentifierNode(((IIdentifierNode)((Object)namespace)).getName());
                ((NodeBase)((Object)this.namespaceNode)).setSourcePath(namespace.getSourcePath());
                ((NodeBase)((Object)this.namespaceNode)).span(namespace.getAbsoluteStart(), namespace.getAbsoluteEnd(), namespace.getLine(), namespace.getColumn());
            }
        }
    }
}

