/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.OperatorNodeBase;
import com.adobe.flash.compiler.internal.tree.as.UnaryOperatorAtNode;
import com.adobe.flash.compiler.internal.tree.as.UnaryOperatorBitwiseNotNode;
import com.adobe.flash.compiler.internal.tree.as.UnaryOperatorDeleteNode;
import com.adobe.flash.compiler.internal.tree.as.UnaryOperatorLogicalNotNode;
import com.adobe.flash.compiler.internal.tree.as.UnaryOperatorMinusNode;
import com.adobe.flash.compiler.internal.tree.as.UnaryOperatorPlusNode;
import com.adobe.flash.compiler.internal.tree.as.UnaryOperatorPostDecrementNode;
import com.adobe.flash.compiler.internal.tree.as.UnaryOperatorPostIncrementNode;
import com.adobe.flash.compiler.internal.tree.as.UnaryOperatorPreDecrementNode;
import com.adobe.flash.compiler.internal.tree.as.UnaryOperatorPreIncrementNode;
import com.adobe.flash.compiler.internal.tree.as.UnaryOperatorTypeOfNode;
import com.adobe.flash.compiler.internal.tree.as.UnaryOperatorVoidNode;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.IOperatorNode;
import com.adobe.flash.compiler.tree.as.IUnaryOperatorNode;

public abstract class UnaryOperatorNodeBase
extends OperatorNodeBase
implements IUnaryOperatorNode {
    private static final int POSTFIX_OPERATOR_LENGTH = 2;
    private ExpressionNodeBase operandNode;

    public static UnaryOperatorNodeBase createPrefix(IASToken operatorToken, ExpressionNodeBase operand) {
        switch (operatorToken.getType()) {
            case 107: {
                return new UnaryOperatorPlusNode(operatorToken, operand);
            }
            case 106: {
                return new UnaryOperatorMinusNode(operatorToken, operand);
            }
            case 112: {
                return new UnaryOperatorPreIncrementNode(operatorToken, operand);
            }
            case 113: {
                return new UnaryOperatorPreDecrementNode(operatorToken, operand);
            }
            case 117: {
                return new UnaryOperatorLogicalNotNode(operatorToken, operand);
            }
            case 116: {
                return new UnaryOperatorBitwiseNotNode(operatorToken, operand);
            }
            case 153: {
                return new UnaryOperatorAtNode(operatorToken, operand);
            }
            case 111: {
                return new UnaryOperatorDeleteNode(operatorToken, operand);
            }
            case 115: {
                return new UnaryOperatorTypeOfNode(operatorToken, operand);
            }
            case 114: {
                return new UnaryOperatorVoidNode(operatorToken, operand);
            }
        }
        assert (false) : "Token '" + operatorToken.getText() + "' unexpected in UnaryOperatorNodeBase.createPrefix()";
        return null;
    }

    public static UnaryOperatorNodeBase createPostfix(IASToken operatorToken, ExpressionNodeBase operand) {
        switch (operatorToken.getType()) {
            case 112: {
                return new UnaryOperatorPostIncrementNode(operatorToken, operand);
            }
            case 113: {
                return new UnaryOperatorPostDecrementNode(operatorToken, operand);
            }
        }
        assert (false) : "Token '" + operatorToken.getText() + "' unexpected in UnaryOperatorNodeBase.createPostfix()";
        return null;
    }

    public UnaryOperatorNodeBase(IASToken operatorToken, ExpressionNodeBase operandNode) {
        super(operatorToken);
        this.operandNode = operandNode;
    }

    protected UnaryOperatorNodeBase(UnaryOperatorNodeBase other) {
        super(other);
        this.operandNode = other.operandNode != null ? other.operandNode.copy() : null;
    }

    @Override
    public int getChildCount() {
        return this.operandNode != null ? 1 : 0;
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.operandNode : null;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        if (this.operandNode != null) {
            this.operandNode.setParent(this);
        }
    }

    @Override
    protected void fillInOffsets() {
        if (this.operandNode == null && this.operatorStart != -1) {
            this.span(this.operatorStart, this.operatorStart + 1, -1, -1);
        } else {
            super.fillInOffsets();
            if (this.operatorStart != -1) {
                switch (this.getNodeID()) {
                    case Op_PostDecrID: 
                    case Op_PostIncrID: {
                        this.setEnd(this.operatorStart + 2);
                        break;
                    }
                    default: {
                        this.setStart(this.operatorStart);
                    }
                }
            }
        }
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
    }

    @Override
    public boolean isDynamicExpression(ICompilerProject project) {
        return false;
    }

    @Override
    boolean isAttributeExpr(ExpressionNodeBase e) {
        return this.getOperator() == IOperatorNode.OperatorType.AT && e == this.getOperandNode();
    }

    @Override
    ExpressionNodeBase getBaseForMemberRef(ExpressionNodeBase e) {
        ExpressionNodeBase p;
        if (this.isAttributeExpr(e) && (p = this.getParentExpression()) != null) {
            return p.getBaseForMemberRef(this);
        }
        return null;
    }

    @Override
    public IOperatorNode.ExpressionType getExpressionType() {
        return IOperatorNode.ExpressionType.PREFIX;
    }

    @Override
    public IExpressionNode getOperandNode() {
        return this.operandNode;
    }

    public void setExpression(ExpressionNodeBase operandNode) {
        this.operandNode = operandNode;
    }

    protected ITypeDefinition resolveIncrementOrDecrementType(ICompilerProject project) {
        ITypeDefinition exprType = this.operandNode.resolveType(project);
        if (exprType != null) {
            ITypeDefinition intType = project.getBuiltinType(IASLanguageConstants.BuiltinType.INT);
            ITypeDefinition uintType = project.getBuiltinType(IASLanguageConstants.BuiltinType.UINT);
            if (exprType.equals(intType)) {
                return intType;
            }
            if (exprType.equals(uintType)) {
                return uintType;
            }
        }
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER);
    }
}

