/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.internal.definitions.FunctionDefinition;
import com.adobe.flash.compiler.internal.definitions.ParameterDefinition;
import com.adobe.flash.compiler.internal.definitions.SetterDefinition;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.tree.as.AccessorNode;
import com.adobe.flash.compiler.internal.tree.as.IdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.parts.IAccessorFunctionContentsPart;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.IParameterNode;
import com.adobe.flash.compiler.tree.as.ISetterNode;
import java.util.Collection;
import java.util.EnumSet;

public class SetterNode
extends AccessorNode
implements ISetterNode {
    public SetterNode(IASToken functionKeyword, IASToken setKeyword, IdentifierNode nameNode) {
        super(functionKeyword, setKeyword, nameNode);
    }

    public SetterNode(IdentifierNode node, IAccessorFunctionContentsPart part) {
        super(node, part);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.SetterID;
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        ParameterDefinition[] parameters;
        super.analyze(set, scope, problems);
        FunctionDefinition definition = this.getDefinition();
        if (definition != null && (parameters = definition.getParameters()) != null && parameters.length > 0) {
            definition.setTypeReference(parameters[0].getTypeReference());
        }
    }

    @Override
    protected FunctionDefinition createFunctionDefinition(String name) {
        return new SetterDefinition(name);
    }

    @Override
    public IExpressionNode getAssignedValueNode() {
        return null;
    }

    @Override
    public IExpressionNode getVariableTypeNode() {
        IParameterNode[] arguments = this.getParameterNodes();
        if (arguments.length > 0) {
            return arguments[0].getVariableTypeNode();
        }
        return null;
    }

    @Override
    public String getVariableType() {
        IParameterNode[] arguments = this.getParameterNodes();
        if (arguments.length > 0) {
            return arguments[0].getVariableType();
        }
        return "";
    }

    @Override
    public boolean isConst() {
        return false;
    }
}

