/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.common.SourceLocation;
import com.adobe.flash.compiler.internal.parsing.as.ASToken;
import com.adobe.flash.compiler.internal.parsing.as.IProblemReporter;
import com.adobe.flash.compiler.internal.tree.as.LiteralNode;
import com.adobe.flash.compiler.problems.SyntaxProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.ILiteralNode;
import com.adobe.flash.compiler.tree.as.IRegExpLiteralNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class RegExpLiteralNode
extends LiteralNode
implements IRegExpLiteralNode {
    private static final Set<IRegExpLiteralNode.RegExpFlag> EMPTY_SET = Collections.emptySet();
    private EnumSet<IRegExpLiteralNode.RegExpFlag> flags;

    public RegExpLiteralNode(ASToken t, IProblemReporter reporter) {
        super(t, ILiteralNode.LiteralType.REGEXP);
        ArrayList<IRegExpLiteralNode.RegExpFlag> flags = new ArrayList<IRegExpLiteralNode.RegExpFlag>(5);
        boolean cont = true;
        block8: for (int i = this.value.length() - 1; i >= 0 && cont; --i) {
            char charAt = this.value.charAt(i);
            switch (charAt) {
                case 'm': {
                    flags.add(IRegExpLiteralNode.RegExpFlag.MULTILINE);
                    continue block8;
                }
                case 's': {
                    flags.add(IRegExpLiteralNode.RegExpFlag.DOTALL);
                    continue block8;
                }
                case 'g': {
                    flags.add(IRegExpLiteralNode.RegExpFlag.GLOBAL);
                    continue block8;
                }
                case 'i': {
                    flags.add(IRegExpLiteralNode.RegExpFlag.IGNORECASE);
                    continue block8;
                }
                case 'x': {
                    flags.add(IRegExpLiteralNode.RegExpFlag.EXTENDED);
                    continue block8;
                }
                case '/': {
                    cont = false;
                    continue block8;
                }
                default: {
                    SourceLocation location = new SourceLocation(this.getSourcePath(), this.getStart() + i, this.getStart() + i + 1, this.getLine(), this.getColumn());
                    SyntaxProblem problem = new SyntaxProblem(location, Character.toString(charAt));
                    reporter.addProblem(problem);
                    continue block8;
                }
            }
        }
        if (flags.size() > 0) {
            this.flags = EnumSet.copyOf(flags);
        }
    }

    protected RegExpLiteralNode(RegExpLiteralNode other) {
        super(other);
        this.flags = other.flags;
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.LiteralRegexID;
    }

    @Override
    protected RegExpLiteralNode copy() {
        return new RegExpLiteralNode(this);
    }

    @Override
    public String getValue() {
        return this.getValue(false);
    }

    @Override
    public String getValue(boolean rawValue) {
        String retVal = this.value;
        if (rawValue || retVal == null) {
            return retVal;
        }
        return retVal.substring(1, retVal.lastIndexOf("/"));
    }

    @Override
    public Set<IRegExpLiteralNode.RegExpFlag> getFlags() {
        return this.flags != null ? this.flags : EMPTY_SET;
    }

    @Override
    public String getFlagString() {
        if (this.flags == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (IRegExpLiteralNode.RegExpFlag f : this.flags) {
            sb.append(f.getCode());
        }
        return sb.toString();
    }

    @Override
    public boolean hasFlag(IRegExpLiteralNode.RegExpFlag flag) {
        return this.flags != null && this.flags.contains((Object)flag);
    }
}

