/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.common.ASModifier;
import com.adobe.flash.compiler.internal.definitions.PackageDefinition;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.scopes.PackageScope;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.MemberedNode;
import com.adobe.flash.compiler.internal.tree.as.NilNode;
import com.adobe.flash.compiler.internal.tree.as.ScopedBlockNode;
import com.adobe.flash.compiler.internal.tree.as.parts.IDecorationPart;
import com.adobe.flash.compiler.internal.tree.as.parts.SparseDecorationPart;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IIdentifierNode;
import com.adobe.flash.compiler.tree.as.IPackageNode;
import com.adobe.flash.compiler.tree.metadata.IMetaTagsNode;
import java.util.Collection;
import java.util.EnumSet;

public class PackageNode
extends MemberedNode
implements IPackageNode {
    protected int packageKeywordStart;
    protected ExpressionNodeBase packageNameNode;

    public PackageNode(ExpressionNodeBase packageNameNode, IASToken packageKeyword) {
        this.init(packageNameNode);
        this.packageNameNode = packageNameNode;
        this.contentsNode = new ScopedBlockNode();
        this.packageKeywordStart = packageKeyword != null ? packageKeyword.getStart() : -1;
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.PackageID;
    }

    @Override
    public String getPackageName() {
        return this.getName();
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        if (this.packageNameNode == null) {
            this.packageNameNode = new NilNode();
        }
        this.addChildInOrder(this.packageNameNode, fillInOffsets);
        this.addChildInOrder(this.contentsNode, fillInOffsets);
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        if (set.contains((Object)PostProcessStep.POPULATE_SCOPE)) {
            PackageDefinition definition = this.buildDefinition();
            this.setDefinition(definition);
            scope.addDefinition(definition);
            PackageScope packageScope = new PackageScope(scope, definition.getQualifiedName(), this.contentsNode);
            definition.setContainedScope(packageScope);
            scope = packageScope;
        }
        if (set.contains((Object)PostProcessStep.RECONNECT_DEFINITIONS)) {
            this.reconnectDef(scope);
            scope = this.getDefinition().getContainedScope();
            this.contentsNode.reconnectScope(scope);
        }
        this.contentsNode.analyze(set, scope, problems);
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getName());
        sb.append('\"');
        return true;
    }

    @Override
    protected int getInitialChildCount() {
        return 2;
    }

    @Override
    protected IDecorationPart createDecorationPart() {
        return SparseDecorationPart.EMPTY_DECORATION_PART;
    }

    @Override
    public IMetaTagsNode getMetaTags() {
        return null;
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public boolean hasNamespace(String namespace) {
        return false;
    }

    @Override
    public boolean hasModifier(ASModifier modifier) {
        return false;
    }

    @Override
    public ExpressionNodeBase getNameExpressionNode() {
        return this.packageNameNode;
    }

    @Override
    public String getName() {
        return this.packageNameNode instanceof IIdentifierNode ? ((IIdentifierNode)((Object)this.packageNameNode)).getName() : "";
    }

    @Override
    public int getNameStart() {
        return this.packageNameNode instanceof IIdentifierNode ? this.packageNameNode.getStart() : -1;
    }

    @Override
    public int getNameEnd() {
        return this.packageNameNode instanceof IIdentifierNode ? this.packageNameNode.getEnd() : -1;
    }

    @Override
    public int getNameAbsoluteStart() {
        return this.packageNameNode instanceof IIdentifierNode ? this.packageNameNode.getAbsoluteStart() : -1;
    }

    @Override
    public int getNameAbsoluteEnd() {
        return this.packageNameNode instanceof IIdentifierNode ? this.packageNameNode.getAbsoluteEnd() : -1;
    }

    @Override
    public PackageDefinition getDefinition() {
        return (PackageDefinition)super.getDefinition();
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    @Override
    public IPackageNode.PackageKind getPackageKind() {
        return IPackageNode.PackageKind.CONCRETE;
    }

    public void setPackageName(ExpressionNodeBase packageNameNode) {
        this.packageNameNode = packageNameNode;
    }

    public boolean hasPackageKeyword() {
        return this.packageKeywordStart != -1;
    }

    public int getPackageKeywordStart() {
        return this.packageKeywordStart;
    }

    public int getPackageKeywordEnd() {
        return this.packageKeywordStart + 7;
    }

    PackageDefinition buildDefinition() {
        String definitionName = this.getName();
        PackageDefinition definition = new PackageDefinition(definitionName);
        definition.setNode(this);
        this.setDefinition(definition);
        return definition;
    }
}

