/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.definitions.references.INamespaceReference;
import com.adobe.flash.compiler.definitions.references.IReference;
import com.adobe.flash.compiler.internal.tree.as.BinaryOperatorNodeBase;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IIdentifierNode;
import com.adobe.flash.compiler.tree.as.ILanguageIdentifierNode;
import com.adobe.flash.compiler.tree.as.IMemberAccessExpressionNode;
import com.adobe.flash.compiler.tree.as.IOperatorNode;

public class MemberAccessExpressionNode
extends BinaryOperatorNodeBase
implements IMemberAccessExpressionNode {
    private IOperatorNode.OperatorType operator = IOperatorNode.OperatorType.MEMBER_ACCESS;

    public MemberAccessExpressionNode(ExpressionNodeBase left, IASToken operatorToken, ExpressionNodeBase right) {
        super(operatorToken, left, right);
        if (operatorToken != null) {
            int tokenType = operatorToken.getType();
            if (tokenType == 35) {
                this.operator = IOperatorNode.OperatorType.MEMBER_ACCESS;
            } else if (tokenType == 154) {
                this.operator = IOperatorNode.OperatorType.DESCENDANT_ACCESS;
            } else assert (false) : "Unexpected token '" + operatorToken.getText() + "' for MemberAccessExpressionNode";
        }
    }

    public MemberAccessExpressionNode(MemberAccessExpressionNode other) {
        super(other);
        this.operator = other.operator;
    }

    @Override
    public ASTNodeID getNodeID() {
        ASTNodeID nodeID = this.getOperator() == IOperatorNode.OperatorType.DESCENDANT_ACCESS ? ASTNodeID.Op_DescendantsID : (this.rightOperandNode != null && this.rightOperandNode.hasParenthesis() ? ASTNodeID.E4XFilterID : ASTNodeID.MemberAccessExpressionID);
        return nodeID;
    }

    @Override
    public IDefinition resolve(ICompilerProject project) {
        if (this.isPackageReference()) {
            return null;
        }
        return this.rightOperandNode.resolve(project);
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        if (ASTNodeID.E4XFilterID == this.getNodeID()) {
            return project.getBuiltinType(IASLanguageConstants.BuiltinType.XMLLIST);
        }
        return this.rightOperandNode.resolveType(project);
    }

    @Override
    public boolean isDynamicExpression(ICompilerProject project) {
        if (this.isPackageReference()) {
            return false;
        }
        return super.isDynamicExpression(project);
    }

    @Override
    protected MemberAccessExpressionNode copy() {
        return new MemberAccessExpressionNode(this);
    }

    @Override
    public Name getMName(ICompilerProject project) {
        return this.rightOperandNode.getMName(project);
    }

    @Override
    String computeSimpleReference() {
        return this.getDisplayString();
    }

    @Override
    IReference computeTypeReference() {
        return this.rightOperandNode.computeTypeReference();
    }

    @Override
    public INamespaceReference computeNamespaceReference() {
        return this.rightOperandNode.computeNamespaceReference();
    }

    @Override
    boolean isPartOfMemberRef(ExpressionNodeBase e) {
        IASNode p;
        if (e == this.rightOperandNode) {
            return true;
        }
        if (e == this.leftOperandNode && (p = this.getParent()) instanceof ExpressionNodeBase) {
            return ((ExpressionNodeBase)p).isPartOfMemberRef(this);
        }
        return false;
    }

    @Override
    ExpressionNodeBase getBaseForMemberRef(ExpressionNodeBase e) {
        ExpressionNodeBase p;
        if (e == this.rightOperandNode) {
            return this.leftOperandNode;
        }
        if (e == this.leftOperandNode && (p = this.getParentExpression()) != null) {
            return p.getBaseForMemberRef(this);
        }
        return null;
    }

    @Override
    public IOperatorNode.OperatorType getOperator() {
        return this.operator;
    }

    @Override
    public String getOperatorText() {
        switch (this.getNodeID()) {
            case E4XFilterID: {
                return ".()";
            }
        }
        return super.getOperatorText();
    }

    @Override
    public String getDisplayString() {
        StringBuilder builder = new StringBuilder();
        if (this.leftOperandNode != null && this.leftOperandNode instanceof IIdentifierNode) {
            builder.append(((IIdentifierNode)((Object)this.leftOperandNode)).getName());
        } else if (this.leftOperandNode != null && this.leftOperandNode instanceof MemberAccessExpressionNode) {
            builder.append(((MemberAccessExpressionNode)this.leftOperandNode).getDisplayString());
        }
        if (builder.length() > 0) {
            builder.append(".");
        }
        if (this.rightOperandNode != null && this.rightOperandNode instanceof IIdentifierNode) {
            builder.append(((IIdentifierNode)((Object)this.rightOperandNode)).getName());
        }
        return builder.toString();
    }

    public boolean isSuper(ExpressionNodeBase node) {
        if (!(node instanceof ILanguageIdentifierNode)) {
            return false;
        }
        ILanguageIdentifierNode idBase = (ILanguageIdentifierNode)((Object)node);
        return idBase.getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.SUPER;
    }

    public boolean stemIsPackage() {
        return this.leftOperandNode.isPackageReference();
    }

    public void setStemAsPackage(boolean b) {
        this.leftOperandNode.setTreatAsPackage(b);
    }

    public boolean isMemberReference(IASNode node) {
        return node == this.rightOperandNode;
    }
}

