/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import antlr.Token;
import com.adobe.flash.compiler.common.SourceLocation;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.internal.parsing.as.ASToken;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.ILiteralNode;

public class LiteralNode
extends ExpressionNodeBase
implements ILiteralNode {
    protected ILiteralNode.LiteralType type;
    protected String value;
    private boolean synthetic;

    public LiteralNode(ILiteralNode.LiteralType type, String value) {
        this.type = type;
        this.value = value;
    }

    public LiteralNode(ILiteralNode.LiteralType type, Token t) {
        this(type, ((IASToken)((Object)t)).getText());
        this.span(t);
    }

    public LiteralNode(ILiteralNode.LiteralType type, String value, SourceLocation sourceLocation) {
        this(type, value);
        this.setSourceLocation(sourceLocation);
    }

    public LiteralNode(ASToken t, ILiteralNode.LiteralType type) {
        this(type, t.getText());
        this.value = t.getText();
        this.span(t);
    }

    protected LiteralNode(LiteralNode other) {
        super(other);
        this.type = other.type;
        this.value = other.value;
        this.synthetic = other.synthetic;
    }

    @Override
    public ASTNodeID getNodeID() {
        switch (this.type) {
            case ARRAY: {
                return ASTNodeID.LiteralArrayID;
            }
            case BOOLEAN: {
                return ASTNodeID.LiteralBooleanID;
            }
            case NULL: {
                return ASTNodeID.LiteralNullID;
            }
            case NUMBER: {
                return ASTNodeID.LiteralNumberID;
            }
            case OBJECT: {
                return ASTNodeID.LiteralObjectID;
            }
            case REGEXP: {
                return ASTNodeID.LiteralRegexID;
            }
            case STRING: {
                return ASTNodeID.LiteralStringID;
            }
            case VOID: {
                return ASTNodeID.LiteralVoidID;
            }
            case XML: {
                return ASTNodeID.LiteralXMLID;
            }
        }
        return ASTNodeID.LiteralID;
    }

    @Override
    public void normalize(boolean fillInOffsets) {
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        String type = this.getLiteralType().getType().getName();
        boolean isString = type.equals("String");
        sb.append(type);
        sb.append(' ');
        if (isString) {
            sb.append('\"');
        }
        sb.append(this.getValue());
        if (isString) {
            sb.append('\"');
        }
        return true;
    }

    @Override
    public boolean isTerminal() {
        return true;
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        ILiteralNode.LiteralType l = this.getLiteralType();
        return project.getBuiltinType(l.getType());
    }

    @Override
    protected LiteralNode copy() {
        return new LiteralNode(this);
    }

    @Override
    public boolean isDynamicExpression(ICompilerProject project) {
        return false;
    }

    @Override
    public ILiteralNode.LiteralType getLiteralType() {
        return this.type;
    }

    @Override
    public String getValue() {
        return this.getValue(false);
    }

    @Override
    public String getValue(boolean rawValue) {
        String retVal = this.value;
        if (this.type == ILiteralNode.LiteralType.STRING) {
            if (rawValue || retVal == null || retVal.length() == 0) {
                return retVal;
            }
            switch (retVal.charAt(0)) {
                case '\"': 
                case '\'': {
                    retVal = retVal.substring(1);
                }
            }
            if (retVal.length() >= 1) {
                switch (retVal.charAt(retVal.length() - 1)) {
                    case '\"': 
                    case '\'': {
                        retVal = retVal.substring(0, retVal.length() - 1);
                    }
                }
            } else {
                return "";
            }
        }
        return retVal;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    public void setSynthetic(boolean synthetic) {
        this.synthetic = synthetic;
    }
}

