/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.semantics.Namespace;
import com.adobe.flash.abc.semantics.Nsset;
import com.adobe.flash.compiler.common.ASModifier;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.definitions.IVariableDefinition;
import com.adobe.flash.compiler.internal.definitions.ClassDefinitionBase;
import com.adobe.flash.compiler.internal.definitions.FunctionDefinition;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.tree.as.ClassNode;
import com.adobe.flash.compiler.internal.tree.as.FunctionNode;
import com.adobe.flash.compiler.internal.tree.as.FunctionObjectNode;
import com.adobe.flash.compiler.internal.tree.as.IdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.PackageNode;
import com.adobe.flash.compiler.internal.tree.as.VariableNode;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.ILanguageIdentifierNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLDocumentNode;
import com.adobe.flash.compiler.tree.mxml.IMXMLScriptNode;

public class LanguageIdentifierNode
extends IdentifierNode
implements ILanguageIdentifierNode {
    private ILanguageIdentifierNode.LanguageIdentifierKind kind;

    public static LanguageIdentifierNode buildSuper(IASToken superToken) {
        return new LanguageIdentifierNode("super", superToken, ILanguageIdentifierNode.LanguageIdentifierKind.SUPER);
    }

    public static LanguageIdentifierNode buildSuper() {
        return new LanguageIdentifierNode("super", null, ILanguageIdentifierNode.LanguageIdentifierKind.SUPER);
    }

    public static LanguageIdentifierNode buildThis(IASToken thisToken) {
        return new LanguageIdentifierNode("this", thisToken, ILanguageIdentifierNode.LanguageIdentifierKind.THIS);
    }

    public static LanguageIdentifierNode buildThis() {
        return new LanguageIdentifierNode("this", null, ILanguageIdentifierNode.LanguageIdentifierKind.THIS);
    }

    public static LanguageIdentifierNode buildVoid(IASToken voidToken) {
        return new LanguageIdentifierNode("void", voidToken, ILanguageIdentifierNode.LanguageIdentifierKind.VOID);
    }

    public static LanguageIdentifierNode buildVoid() {
        return new LanguageIdentifierNode("void", null, ILanguageIdentifierNode.LanguageIdentifierKind.VOID);
    }

    public static LanguageIdentifierNode buildAnyType(IASToken anyTypeToken) {
        return new LanguageIdentifierNode("*", anyTypeToken, ILanguageIdentifierNode.LanguageIdentifierKind.ANY_TYPE);
    }

    public static LanguageIdentifierNode buildAnyType() {
        return new LanguageIdentifierNode("*", null, ILanguageIdentifierNode.LanguageIdentifierKind.ANY_TYPE);
    }

    public static LanguageIdentifierNode buildRest(IASToken restToken) {
        return new LanguageIdentifierNode("...", restToken, ILanguageIdentifierNode.LanguageIdentifierKind.REST);
    }

    public static LanguageIdentifierNode buildRest() {
        return new LanguageIdentifierNode("...", null, ILanguageIdentifierNode.LanguageIdentifierKind.REST);
    }

    private LanguageIdentifierNode(String text, IASToken token, ILanguageIdentifierNode.LanguageIdentifierKind kind) {
        super(text, token);
        this.kind = kind;
    }

    protected LanguageIdentifierNode(LanguageIdentifierNode other) {
        super(other);
        this.kind = other.kind;
    }

    @Override
    public ASTNodeID getNodeID() {
        switch (this.kind) {
            case SUPER: {
                return ASTNodeID.SuperID;
            }
            case VOID: {
                return ASTNodeID.VoidID;
            }
        }
        return super.getNodeID();
    }

    @Override
    public IDefinition resolve(ICompilerProject project) {
        IDefinition def = null;
        switch (this.kind) {
            case SUPER: 
            case THIS: {
                def = null;
                break;
            }
            case VOID: {
                def = project.getBuiltinType(IASLanguageConstants.BuiltinType.VOID);
                break;
            }
            case REST: {
                def = project.getBuiltinType(IASLanguageConstants.BuiltinType.ARRAY);
                break;
            }
            case ANY_TYPE: {
                if (this.isMemberRef() || this.isQualifiedExpr(this)) {
                    def = null;
                    break;
                }
                def = project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
                break;
            }
            default: {
                def = super.resolve(project);
            }
        }
        return def;
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        ITypeDefinition type = null;
        switch (this.kind) {
            case THIS: {
                type = this.resolveThisType(project);
                break;
            }
            case SUPER: {
                type = this.resolveSuperType(project);
                break;
            }
            case ANY_TYPE: {
                IDefinition def = this.resolve(project);
                if (def == null) {
                    type = project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
                    break;
                }
                type = def.resolveType(project);
                break;
            }
            case REST: {
                type = project.getBuiltinType(IASLanguageConstants.BuiltinType.ARRAY);
                break;
            }
            case VOID: {
                type = project.getBuiltinType(IASLanguageConstants.BuiltinType.Undefined);
            }
        }
        return type;
    }

    @Override
    protected LanguageIdentifierNode copy() {
        return new LanguageIdentifierNode(this);
    }

    @Override
    public Name getMName(ICompilerProject project) {
        switch (this.kind) {
            case ANY_TYPE: {
                if (this.isQualifiedExpr(this) || this.isMemberRef()) {
                    Name superName = super.getMName(project);
                    return new Name(superName.getKind(), superName.getQualifiers(), null);
                }
                if (this.isAttributeIdentifier()) {
                    return new Name(13, new Nsset(new Namespace(22)), "*");
                }
                if (this.isTypeRef()) {
                    return null;
                }
                return new Name("*");
            }
            case REST: {
                return new Name("Array");
            }
        }
        return super.getMName(project);
    }

    @Override
    public String getName() {
        switch (this.kind) {
            case THIS: {
                return "this";
            }
            case SUPER: {
                return "super";
            }
            case ANY_TYPE: {
                return "*";
            }
            case REST: {
                return "...";
            }
            case VOID: {
                return "void";
            }
        }
        return super.getName();
    }

    @Override
    public ILanguageIdentifierNode.LanguageIdentifierKind getKind() {
        return this.kind;
    }

    private ITypeDefinition resolveThisType(ICompilerProject project) {
        ITypeDefinition thisType = null;
        Context ctx = this.getContext();
        switch (ctx) {
            case INSTANCE_CONTEXT: {
                thisType = this.getContainingClassDef();
                break;
            }
            case STATIC_CONTEXT: 
            case PACKAGE_CONTEXT: {
                thisType = null;
                break;
            }
            case GLOBAL_CONTEXT: {
                thisType = project.getBuiltinType(IASLanguageConstants.BuiltinType.OBJECT);
            }
        }
        return thisType;
    }

    private ITypeDefinition resolveSuperType(ICompilerProject project) {
        ClassDefinitionBase clazz;
        IClassDefinition superType = null;
        Context ctx = this.getContext();
        if (ctx == Context.INSTANCE_CONTEXT && (clazz = this.getContainingClassDef()) != null) {
            superType = clazz.resolveBaseClass(project);
        }
        return superType;
    }

    private ClassDefinitionBase getContainingClassDef() {
        ASScope scope = this.getASScope();
        if (scope != null) {
            return scope.getContainingClass();
        }
        return null;
    }

    public Context getContext() {
        Context c = null;
        for (IASNode p = this.getParent(); p != null && c == null; p = p.getParent()) {
            if (p instanceof VariableNode) {
                VariableNode vn = (VariableNode)p;
                IVariableDefinition varDef = (IVariableDefinition)((Object)vn.getDefinition());
                switch (varDef.getVariableClassification()) {
                    case CLASS_MEMBER: {
                        if (varDef.hasModifier(ASModifier.STATIC)) {
                            c = Context.STATIC_CONTEXT;
                            break;
                        }
                        c = Context.INSTANCE_CONTEXT;
                        break;
                    }
                    case PACKAGE_MEMBER: {
                        c = Context.PACKAGE_CONTEXT;
                        break;
                    }
                    case FILE_MEMBER: {
                        c = Context.GLOBAL_CONTEXT;
                    }
                }
            } else if (p instanceof FunctionNode) {
                FunctionNode fn = (FunctionNode)p;
                FunctionDefinition funcDef = fn.getDefinition();
                switch (funcDef.getFunctionClassification()) {
                    case CLASS_MEMBER: 
                    case INTERFACE_MEMBER: {
                        if (funcDef.hasModifier(ASModifier.STATIC)) {
                            c = Context.STATIC_CONTEXT;
                            break;
                        }
                        c = Context.INSTANCE_CONTEXT;
                        break;
                    }
                    case PACKAGE_MEMBER: 
                    case FILE_MEMBER: {
                        c = Context.GLOBAL_CONTEXT;
                    }
                }
            }
            if (p instanceof FunctionObjectNode) {
                c = Context.GLOBAL_CONTEXT;
                continue;
            }
            if (p instanceof ClassNode) {
                c = Context.STATIC_CONTEXT;
                continue;
            }
            if (p instanceof PackageNode) {
                c = Context.PACKAGE_CONTEXT;
                continue;
            }
            if (p instanceof IMXMLScriptNode) {
                c = Context.STATIC_CONTEXT;
                continue;
            }
            if (!(p instanceof IMXMLDocumentNode)) continue;
            c = Context.INSTANCE_CONTEXT;
        }
        if (c == null) {
            c = Context.GLOBAL_CONTEXT;
        }
        return c;
    }

    public static enum Context {
        INSTANCE_CONTEXT,
        STATIC_CONTEXT,
        PACKAGE_CONTEXT,
        GLOBAL_CONTEXT;

    }
}

