/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.internal.tree.as.FixedChildrenNode;
import com.adobe.flash.compiler.internal.tree.as.IdentifierNode;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IIdentifierNode;
import com.adobe.flash.compiler.tree.as.IIterationFlowNode;

public class IterationFlowNode
extends FixedChildrenNode
implements IIterationFlowNode {
    private IdentifierNode labelNode;
    private IIterationFlowNode.IterationFlowKind kind;

    public IterationFlowNode(IASToken token) {
        if (token != null) {
            this.startBefore(token);
            switch (token.getType()) {
                case 62: {
                    this.kind = IIterationFlowNode.IterationFlowKind.BREAK;
                    break;
                }
                case 61: {
                    this.kind = IIterationFlowNode.IterationFlowKind.CONTINUE;
                    break;
                }
                case 14: {
                    this.kind = IIterationFlowNode.IterationFlowKind.GOTO;
                }
            }
            this.endAfter(token);
        }
    }

    @Override
    public ASTNodeID getNodeID() {
        switch (this.kind) {
            case BREAK: {
                return ASTNodeID.BreakID;
            }
            case CONTINUE: {
                return ASTNodeID.ContinueID;
            }
            case GOTO: {
                return ASTNodeID.GotoID;
            }
        }
        assert (false) : "Unknown control flow type!";
        return ASTNodeID.UnknownID;
    }

    @Override
    public int getChildCount() {
        return this.labelNode != null ? 1 : 0;
    }

    @Override
    public IASNode getChild(int i) {
        if (i == 0) {
            return this.labelNode;
        }
        return null;
    }

    @Override
    public IIterationFlowNode.IterationFlowKind getKind() {
        return this.kind;
    }

    @Override
    public IIdentifierNode getLabelNode() {
        return this.labelNode;
    }

    public void setLabel(IdentifierNode labelNode) {
        this.labelNode = labelNode;
        labelNode.setParent(this);
        this.setEnd(labelNode.getAbsoluteEnd());
    }
}

