/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.common.ASImportTarget;
import com.adobe.flash.compiler.common.ASModifier;
import com.adobe.flash.compiler.common.IImportTarget;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.references.IReference;
import com.adobe.flash.compiler.definitions.references.ReferenceFactory;
import com.adobe.flash.compiler.internal.definitions.FunctionDefinition;
import com.adobe.flash.compiler.internal.definitions.InterfaceDefinition;
import com.adobe.flash.compiler.internal.definitions.NamespaceDefinition;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.scopes.TypeScope;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.tree.as.ContainerNode;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.FileNode;
import com.adobe.flash.compiler.internal.tree.as.FunctionNode;
import com.adobe.flash.compiler.internal.tree.as.KeywordNode;
import com.adobe.flash.compiler.internal.tree.as.MemberedNode;
import com.adobe.flash.compiler.internal.tree.as.TransparentContainerNode;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.IIdentifierNode;
import com.adobe.flash.compiler.tree.as.IInterfaceNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;

public class InterfaceNode
extends MemberedNode
implements IInterfaceNode {
    protected KeywordNode interfaceKeywordNode;
    protected KeywordNode extendsKeywordNode;
    protected TransparentContainerNode baseInterfacesNode;
    protected FunctionNode castFunctionNode;

    public InterfaceNode(ExpressionNodeBase name) {
        this.init(name);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.InterfaceID;
    }

    @Override
    public int getSpanningStart() {
        return this.getNodeStartForTooling();
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        this.addDecorationChildren(fillInOffsets);
        this.addChildInOrder(this.interfaceKeywordNode, fillInOffsets);
        this.addChildInOrder(this.nameNode, fillInOffsets);
        this.addChildInOrder(this.extendsKeywordNode, fillInOffsets);
        this.addChildInOrder(this.contentsNode, fillInOffsets);
        if (this.extendsKeywordNode != null || this.baseInterfacesNode.getChildCount() > 0) {
            this.addChildInOrder(this.baseInterfacesNode, fillInOffsets);
        }
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        if (set.contains((Object)PostProcessStep.POPULATE_SCOPE)) {
            InterfaceDefinition definition = this.buildDefinition();
            this.setDefinition(definition);
            scope.addDefinition(definition);
            TypeScope typeScope = new TypeScope(scope, this.contentsNode, definition);
            definition.setContainedScope(typeScope);
            scope = typeScope;
            this.setupCastFunction(set, definition, scope);
        }
        if (set.contains((Object)PostProcessStep.RECONNECT_DEFINITIONS)) {
            this.reconnectDef(scope);
            scope = this.getDefinition().getContainedScope();
            this.contentsNode.reconnectScope(scope);
        }
        this.contentsNode.analyze(set, scope, problems);
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getName());
        sb.append('\"');
        return true;
    }

    @Override
    protected int getInitialChildCount() {
        return 2;
    }

    @Override
    protected void init(ExpressionNodeBase nameNode) {
        super.init(nameNode);
        this.extendsKeywordNode = null;
        this.baseInterfacesNode = new TransparentContainerNode();
        this.castFunctionNode = null;
    }

    @Override
    public boolean hasModifier(ASModifier modifier) {
        return false;
    }

    @Override
    public InterfaceDefinition getDefinition() {
        return (InterfaceDefinition)super.getDefinition();
    }

    @Override
    protected void setDefinition(IDefinition definition) {
        assert (definition instanceof InterfaceDefinition);
        super.setDefinition(definition);
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public String getQualifiedName() {
        IImportTarget importTarget = ASImportTarget.buildImportFromPackageName(this.getWorkspace(), this.getPackageName());
        String qualifiedName = importTarget.getQualifiedName(this.getName());
        if (qualifiedName == null) {
            return this.getShortName();
        }
        return qualifiedName;
    }

    @Override
    public String getShortName() {
        String name = this.getName();
        int lastDot = name.lastIndexOf(".");
        if (lastDot != -1) {
            name = name.substring(lastDot + 1);
        }
        return name;
    }

    @Override
    public IInterfaceNode.InterfaceClassification getInterfaceClassification() {
        if (this.getParent() instanceof FileNode) {
            return IInterfaceNode.InterfaceClassification.INNER_INTERFACE;
        }
        return IInterfaceNode.InterfaceClassification.PACKAGE_MEMBER;
    }

    @Override
    public IExpressionNode[] getExtendedInterfaceNodes() {
        ArrayList<IIdentifierNode> interfaceNodeList = new ArrayList<IIdentifierNode>();
        int childCount = this.baseInterfacesNode.getChildCount();
        if (this.baseInterfacesNode != null && childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                IASNode child = this.baseInterfacesNode.getChild(i);
                if (!(child instanceof IIdentifierNode)) continue;
                interfaceNodeList.add((IIdentifierNode)child);
            }
        }
        return interfaceNodeList.toArray(new IExpressionNode[0]);
    }

    @Override
    public String[] getExtendedInterfaces() {
        ArrayList<String> interfaceNodeList = new ArrayList<String>();
        int childCount = this.baseInterfacesNode.getChildCount();
        if (this.baseInterfacesNode != null && childCount > 0) {
            for (int i = 0; i < childCount; ++i) {
                IASNode child = this.baseInterfacesNode.getChild(i);
                if (!(child instanceof IIdentifierNode)) continue;
                interfaceNodeList.add(((IIdentifierNode)child).getName());
            }
        }
        return interfaceNodeList.toArray(new String[0]);
    }

    public void setInterfaceKeyword(IASToken interfaceKeyword) {
        this.interfaceKeywordNode = new KeywordNode(interfaceKeyword);
    }

    public KeywordNode getClassKeywordNode() {
        return this.interfaceKeywordNode;
    }

    public KeywordNode getExtendsKeywordNode() {
        return this.extendsKeywordNode;
    }

    public void setExtendsKeyword(IASToken extendsKeyword) {
        this.extendsKeywordNode = new KeywordNode(extendsKeyword);
    }

    public void addBaseInterface(ExpressionNodeBase interfaceName) {
        this.baseInterfacesNode.addChild(interfaceName);
    }

    public ContainerNode getBaseInterfacesNode() {
        return this.baseInterfacesNode;
    }

    private void setupCastFunction(EnumSet<PostProcessStep> set, InterfaceDefinition def, ASScope scope) {
        FunctionDefinition castFunc = new FunctionDefinition(this.getName());
        castFunc.setNamespaceReference(NamespaceDefinition.getCodeModelImplicitDefinitionNamespace());
        castFunc.setReturnTypeReference(ReferenceFactory.resolvedReference(def));
        castFunc.setCastFunction();
        castFunc.setImplicit();
        scope.addDefinition(castFunc);
    }

    public FunctionNode getCastFunctionNode() {
        return this.castFunctionNode;
    }

    InterfaceDefinition buildDefinition() {
        String definitionName = this.nameNode.computeSimpleReference();
        InterfaceDefinition definition = new InterfaceDefinition(definitionName);
        definition.setNode(this);
        this.fillInNamespaceAndModifiers(definition);
        this.fillInMetadata(definition);
        if (this.baseInterfacesNode != null) {
            int n = this.baseInterfacesNode.getChildCount();
            IReference[] baseInterfaces = new IReference[n];
            for (int i = 0; i < n; ++i) {
                IASNode child = this.baseInterfacesNode.getChild(i);
                if (!(child instanceof ExpressionNodeBase)) continue;
                baseInterfaces[i] = ((ExpressionNodeBase)child).computeTypeReference();
            }
            definition.setExtendedInterfaceReferences(baseInterfaces);
        }
        return definition;
    }
}

