/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.common.ASImportTarget;
import com.adobe.flash.compiler.common.IImportTarget;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.references.IResolvedQualifiersReference;
import com.adobe.flash.compiler.definitions.references.ReferenceFactory;
import com.adobe.flash.compiler.internal.parsing.as.ASToken;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.FixedChildrenNode;
import com.adobe.flash.compiler.internal.tree.as.FullNameNode;
import com.adobe.flash.compiler.internal.tree.as.IdentifierNode;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.IIdentifierNode;
import com.adobe.flash.compiler.tree.as.IImportNode;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;

public class ImportNode
extends FixedChildrenNode
implements IImportNode {
    protected ExpressionNodeBase targetImportNode;
    protected IImportNode.ImportKind importKind;

    public static ImportNode buildImportNode(String qname) {
        LinkedList<ExpressionNodeBase> nodeList = new LinkedList<ExpressionNodeBase>();
        for (String s : qname.split("\\.")) {
            nodeList.add(new IdentifierNode(s));
        }
        ASToken dotToken = new ASToken(35, -1, -1, -1, -1, ".");
        while (nodeList.size() > 1) {
            ExpressionNodeBase first = (ExpressionNodeBase)nodeList.removeFirst();
            ExpressionNodeBase second = (ExpressionNodeBase)nodeList.removeFirst();
            nodeList.addFirst(new FullNameNode(first, dotToken, second));
        }
        ImportNode importNode = new ImportNode((ExpressionNodeBase)nodeList.getFirst());
        return importNode;
    }

    public static String makeWildcardName(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1) {
            name = name.substring(0, lastDot) + ".*";
        }
        return name;
    }

    public ImportNode(ExpressionNodeBase targetImportNode) {
        this.targetImportNode = targetImportNode;
        this.importKind = IImportNode.ImportKind.AS_SCOPED_IMPORT;
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.ImportID;
    }

    @Override
    public int getChildCount() {
        return this.targetImportNode != null ? 1 : 0;
    }

    @Override
    public IASNode getChild(int i) {
        if (i == 0) {
            return this.targetImportNode;
        }
        return null;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        if (this.targetImportNode != null) {
            this.targetImportNode.normalize(fillInOffsets);
            this.targetImportNode.setParent(this);
        }
    }

    @Override
    public void normalize(boolean fillInOffsets) {
        this.setChildren(fillInOffsets);
        super.normalize(fillInOffsets);
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        if (set.contains((Object)PostProcessStep.POPULATE_SCOPE)) {
            scope.addImport(this.getImportName());
        }
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getImportName());
        sb.append('\"');
        return true;
    }

    @Override
    public IImportNode.ImportKind getImportKind() {
        if (this.getAbsoluteStart() == this.getAbsoluteEnd()) {
            return IImportNode.ImportKind.IMPLICIT_IMPORT;
        }
        return this.importKind;
    }

    @Override
    public IExpressionNode getImportNameNode() {
        return this.targetImportNode;
    }

    @Override
    public String getImportName() {
        return this.targetImportNode instanceof IIdentifierNode ? ((IIdentifierNode)((Object)this.targetImportNode)).getName() : "";
    }

    @Override
    public IImportTarget getImportTarget() {
        return ASImportTarget.get(this.getWorkspace(), this.getImportName());
    }

    @Override
    public boolean isWildcardImport() {
        String targetPackage = this.getImportName();
        return targetPackage.endsWith(".") || targetPackage.endsWith("*");
    }

    @Override
    public IDefinition resolveImport(ICompilerProject project) {
        if (this.isWildcardImport()) {
            return null;
        }
        String importName = this.getImportName();
        IResolvedQualifiersReference importReference = ReferenceFactory.packageQualifiedReference(project.getWorkspace(), importName);
        ASScope scope = (ASScope)this.getScopeNode().getScope();
        return importReference.resolve(project, scope, null, true);
    }

    public void setImportKind(IImportNode.ImportKind importKind) {
        this.importKind = importKind;
    }

    public void setImportTarget(ExpressionNodeBase targetImportNode) {
        this.targetImportNode = targetImportNode;
    }
}

