/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.FunctionNode;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import java.util.Collection;
import java.util.EnumSet;

public class FunctionObjectNode
extends ExpressionNodeBase {
    private final FunctionNode functionNode;

    public FunctionObjectNode(FunctionNode functionNode) {
        if (functionNode == null) {
            throw new NullPointerException("function node can't be null");
        }
        this.functionNode = functionNode;
        this.functionNode.parent = this;
    }

    @Override
    public ASTNodeID getNodeID() {
        if (this.functionNode.getName().isEmpty()) {
            return ASTNodeID.AnonymousFunctionID;
        }
        return ASTNodeID.FunctionObjectID;
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public IASNode getChild(int i) {
        return i == 0 ? this.functionNode : null;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        if (this.functionNode != null) {
            this.functionNode.setParent(this);
        }
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        EnumSet<PostProcessStep> stepsToRunOnChildren;
        if (set.contains((Object)PostProcessStep.RECONNECT_DEFINITIONS)) {
            stepsToRunOnChildren = EnumSet.copyOf(set);
            stepsToRunOnChildren.remove((Object)PostProcessStep.RECONNECT_DEFINITIONS);
            stepsToRunOnChildren.add(PostProcessStep.POPULATE_SCOPE);
        } else {
            stepsToRunOnChildren = set;
        }
        super.analyze(stepsToRunOnChildren, scope, problems);
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.FUNCTION);
    }

    @Override
    protected FunctionObjectNode copy() {
        return null;
    }

    @Override
    public boolean isDynamicExpression(ICompilerProject project) {
        return true;
    }

    public FunctionNode getFunctionNode() {
        return this.functionNode;
    }
}

