/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.common.ASImportTarget;
import com.adobe.flash.compiler.common.IImportTarget;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.IFunctionDefinition;
import com.adobe.flash.compiler.definitions.IParameterDefinition;
import com.adobe.flash.compiler.definitions.references.IReference;
import com.adobe.flash.compiler.definitions.references.ReferenceFactory;
import com.adobe.flash.compiler.internal.definitions.FunctionDefinition;
import com.adobe.flash.compiler.internal.definitions.NamespaceDefinition;
import com.adobe.flash.compiler.internal.definitions.ParameterDefinition;
import com.adobe.flash.compiler.internal.definitions.VariableDefinition;
import com.adobe.flash.compiler.internal.parsing.as.ASParser;
import com.adobe.flash.compiler.internal.parsing.as.ASToken;
import com.adobe.flash.compiler.internal.parsing.as.ConfigProcessor;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.scopes.ASFileScope;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.scopes.ClosureScope;
import com.adobe.flash.compiler.internal.scopes.FunctionScope;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.tree.as.BaseTypedDefinitionNode;
import com.adobe.flash.compiler.internal.tree.as.BlockNode;
import com.adobe.flash.compiler.internal.tree.as.ClassNode;
import com.adobe.flash.compiler.internal.tree.as.ConfigConditionBlockNode;
import com.adobe.flash.compiler.internal.tree.as.ContainerNode;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.FileNode;
import com.adobe.flash.compiler.internal.tree.as.FunctionObjectNode;
import com.adobe.flash.compiler.internal.tree.as.GetterNode;
import com.adobe.flash.compiler.internal.tree.as.IdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.InterfaceNode;
import com.adobe.flash.compiler.internal.tree.as.KeywordNode;
import com.adobe.flash.compiler.internal.tree.as.NamespaceIdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.as.PackageNode;
import com.adobe.flash.compiler.internal.tree.as.ParameterNode;
import com.adobe.flash.compiler.internal.tree.as.ScopedBlockNode;
import com.adobe.flash.compiler.internal.tree.as.SetterNode;
import com.adobe.flash.compiler.internal.tree.as.parts.FunctionContentsPart;
import com.adobe.flash.compiler.internal.tree.as.parts.IFunctionContentsPart;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.problems.CanNotInsertSemicolonProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.InternalCompilerProblem2;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.scopes.IASScope;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.ICommonClassNode;
import com.adobe.flash.compiler.tree.as.IContainerNode;
import com.adobe.flash.compiler.tree.as.IDefinitionNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.IFunctionNode;
import com.adobe.flash.compiler.tree.as.INamespaceDecorationNode;
import com.adobe.flash.compiler.tree.as.IParameterNode;
import com.adobe.flash.compiler.tree.as.IScopedNode;
import com.adobe.flash.compiler.tree.as.ITypeNode;
import com.adobe.flash.compiler.workspaces.IWorkspace;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.concurrent.locks.ReentrantLock;

public class FunctionNode
extends BaseTypedDefinitionNode
implements IFunctionNode {
    protected IFunctionContentsPart contentsPart;
    boolean needsArguments = false;
    private ConfigProcessor configProcessor = null;
    private ASToken openT = null;
    private boolean isBodyDeferred = false;
    private ReentrantLock deferredBodyParsingLock = new ReentrantLock();
    private int deferredBodyParsingReferenceCount = 0;
    private String functionBodyText;
    private Collection<ICompilerProblem> parseProblems;

    public FunctionNode(IASToken functionKeyword, IdentifierNode nameNode) {
        this.init(nameNode);
        if (functionKeyword != null) {
            this.contentsPart.setKeywordNode(new KeywordNode(functionKeyword));
        }
    }

    public FunctionNode(IdentifierNode node, IFunctionContentsPart part) {
        super.init(node);
        this.contentsPart = part;
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.FunctionID;
    }

    @Override
    public int getSpanningStart() {
        return this.getNodeStartForTooling();
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        this.addDecorationChildren(fillInOffsets);
        this.addChildInOrder(this.contentsPart.getFunctionKeywordNode(), fillInOffsets);
        this.addChildInOrder(this.nameNode, fillInOffsets);
        this.addChildInOrder(this.contentsPart.getParametersNode(), fillInOffsets);
        this.addChildInOrder(this.typeNode, fillInOffsets);
        this.addChildInOrder(this.contentsPart.getContents(), fillInOffsets);
    }

    @Override
    public void normalize(boolean fillInOffsets) {
        super.normalize(fillInOffsets);
        this.contentsPart.optimize();
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        ContainerNode parameters;
        ScopedBlockNode contents;
        if (set.contains((Object)PostProcessStep.POPULATE_SCOPE)) {
            FunctionDefinition definition = this.buildDefinition();
            this.setDefinition(definition);
            if (this.getParentIgnoringConditionals() instanceof FunctionObjectNode) {
                String funcName = definition.getBaseName();
                if (funcName.length() == 0) {
                    scope.setAsContainingScopeOfAnonymousFunction(definition);
                } else {
                    ClosureScope closureScope = new ClosureScope(scope);
                    scope = closureScope;
                    scope.addDefinition(definition);
                }
            } else {
                scope.addDefinition(definition);
            }
            contents = this.contentsPart.getContents();
            if (contents != null) {
                FunctionScope localScope = new FunctionScope(scope, contents);
                definition.setContainedScope(localScope);
                scope = localScope;
            }
        }
        if (set.contains((Object)PostProcessStep.RECONNECT_DEFINITIONS)) {
            this.reconnectDef(scope);
            FunctionDefinition functionDef = this.getDefinition();
            if (functionDef != null) {
                scope = functionDef.getContainedScope();
                contents = this.contentsPart.getContents();
                if (contents != null) {
                    contents.reconnectScope(scope);
                }
            }
        }
        if ((parameters = this.contentsPart.getParametersNode()) != null) {
            parameters.analyze(set, scope, problems);
            if (set.contains((Object)PostProcessStep.POPULATE_SCOPE)) {
                IParameterNode[] argumentNodes = this.getParameterNodes();
                int n = argumentNodes.length;
                ParameterDefinition[] arguments = new ParameterDefinition[n];
                for (int i = 0; i < n; ++i) {
                    if (!(argumentNodes[i] instanceof ParameterNode)) continue;
                    arguments[i] = (ParameterDefinition)((ParameterNode)argumentNodes[i]).getDefinition();
                }
                ((FunctionDefinition)this.definition).setParameters(arguments);
            }
        }
        if ((contents = this.contentsPart.getContents()) != null) {
            ((NodeBase)contents).analyze(set, scope, problems);
        }
        if (set.contains((Object)PostProcessStep.POPULATE_SCOPE)) {
            this.tryAddDefaultArgument();
        }
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append(this.getName());
        sb.append('(');
        IParameterNode[] args = this.getParameterNodes();
        for (int i = 0; i < args.length; ++i) {
            IParameterNode arg = args[i];
            sb.append(arg.getVariableType());
            if (i >= args.length - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
        if (this.getReturnType().length() > 0) {
            sb.append(":" + this.getReturnType());
        }
        return true;
    }

    @Override
    protected int getInitialChildCount() {
        return 4;
    }

    @Override
    protected void init(ExpressionNodeBase idNode) {
        super.init(idNode);
        this.contentsPart = this.createContentsPart();
    }

    @Override
    public INamespaceDecorationNode getNamespaceNode() {
        INamespaceDecorationNode namespaceNode = super.getNamespaceNode();
        if (this.isConstructor()) {
            if (namespaceNode != null && namespaceNode.getName().equals("public")) {
                return namespaceNode;
            }
            NamespaceIdentifierNode pub = new NamespaceIdentifierNode("public");
            pub.span(-1, -1, -1, -1);
            pub.setDecorationTarget(this);
            return pub;
        }
        return namespaceNode;
    }

    @Override
    public String getNamespace() {
        INamespaceDecorationNode ns = this.getNamespaceNode();
        if (ns != null) {
            String nameString = ns.getName();
            if (nameString.equals("public")) {
                return nameString;
            }
            if (this.isConstructor()) {
                return "public";
            }
            return nameString;
        }
        if (this.isConstructor()) {
            return "public";
        }
        return null;
    }

    @Override
    public boolean hasNamespace(String namespace) {
        if (this.isConstructor()) {
            return namespace.compareTo("public") == 0;
        }
        return super.hasNamespace(namespace);
    }

    @Override
    public FunctionDefinition getDefinition() {
        return (FunctionDefinition)super.getDefinition();
    }

    @Override
    protected void setDefinition(IDefinition def) {
        assert (def instanceof FunctionDefinition);
        super.setDefinition(def);
    }

    @Override
    public boolean isImplicit() {
        InterfaceNode containingInterface;
        ClassNode containingClass;
        IASNode gp;
        return this.getParent() != null && ((gp = this.getGrandparent()) instanceof ClassNode ? (containingClass = (ClassNode)gp).getDefaultConstructorNode() == this : gp instanceof InterfaceNode && (containingInterface = (InterfaceNode)gp).getCastFunctionNode() == this);
    }

    @Override
    public String getQualifiedName() {
        String qualifiedName = null;
        if (this.isPackageLevelFunction()) {
            IImportTarget importTarget = ASImportTarget.buildImportFromPackageName(this.getWorkspace(), this.getPackageName());
            qualifiedName = importTarget.getQualifiedName(this.getName());
        }
        if (qualifiedName == null) {
            qualifiedName = this.getName();
        }
        return qualifiedName;
    }

    @Override
    public String getShortName() {
        return this.getName();
    }

    @Override
    public final ScopedBlockNode getScopedNode() {
        return this.contentsPart.getContents();
    }

    @Override
    public IFunctionDefinition.FunctionClassification getFunctionClassification() {
        IScopedNode scopedNode;
        IScopedNode node = scopedNode = this.getScopeNode();
        IASNode parent = this.getParentIgnoringConditionals();
        if (node instanceof ICommonClassNode || parent instanceof ICommonClassNode) {
            return IFunctionDefinition.FunctionClassification.CLASS_MEMBER;
        }
        if (parent instanceof InterfaceNode) {
            return IFunctionDefinition.FunctionClassification.INTERFACE_MEMBER;
        }
        if (parent instanceof PackageNode) {
            return IFunctionDefinition.FunctionClassification.PACKAGE_MEMBER;
        }
        if (node instanceof FileNode) {
            return IFunctionDefinition.FunctionClassification.FILE_MEMBER;
        }
        return IFunctionDefinition.FunctionClassification.LOCAL;
    }

    @Override
    public boolean isGetter() {
        return this instanceof GetterNode;
    }

    @Override
    public boolean isSetter() {
        return this instanceof SetterNode;
    }

    private static IASNode getParentIgnoringConditionals(IASNode p) {
        if (p == null) {
            return null;
        }
        for (p = p.getParent(); p != null && p instanceof ConfigConditionBlockNode; p = p.getParent()) {
        }
        return p;
    }

    private IASNode getParentIgnoringConditionals() {
        return FunctionNode.getParentIgnoringConditionals(this);
    }

    private IASNode getGrandparent() {
        return FunctionNode.getParentIgnoringConditionals(this.getParentIgnoringConditionals());
    }

    @Override
    public boolean isConstructor() {
        String name = this.getName();
        String returnType = this.getReturnType();
        if (!(returnType.equals("") || returnType.equals(name) || this.isAnyType() || this.isVoidType())) {
            return false;
        }
        IASNode p = this.getGrandparent();
        return p != null && (p instanceof ClassNode || p instanceof InterfaceNode) && name.equals(((IDefinitionNode)p).getShortName());
    }

    @Override
    public boolean isCastFunction() {
        String name = this.getName();
        String returnType = this.getReturnType();
        if (!returnType.equals("") && !returnType.equals(name)) {
            return false;
        }
        IASNode gp = this.getGrandparent();
        return gp != null && gp instanceof ITypeNode && name.equals(((ITypeNode)gp).getShortName());
    }

    @Override
    public ContainerNode getParametersContainerNode() {
        return this.contentsPart.getParametersNode();
    }

    @Override
    public IParameterNode[] getParameterNodes() {
        IParameterNode[] variables = new IParameterNode[]{};
        ContainerNode arguments = this.contentsPart.getParametersNode();
        if (arguments != null) {
            int argumentscount = arguments.getChildCount();
            variables = new IParameterNode[argumentscount];
            for (int i = 0; i < argumentscount; ++i) {
                IASNode argument = arguments.getChild(i);
                if (!(argument instanceof IParameterNode)) continue;
                variables[i] = (IParameterNode)argument;
            }
        }
        return variables;
    }

    @Override
    public IExpressionNode getReturnTypeNode() {
        return this.getTypeNode();
    }

    @Override
    public String getReturnType() {
        return this.getTypeName();
    }

    @Override
    public boolean hasBody() {
        ScopedBlockNode sbn = this.getScopedNode();
        return sbn.getChildCount() > 0 || sbn.getContainerType() != IContainerNode.ContainerType.SYNTHESIZED;
    }

    protected IFunctionContentsPart createContentsPart() {
        return new FunctionContentsPart();
    }

    private void tryAddDefaultArgument() {
        FunctionDefinition def = this.getDefinition();
        ASScope funcScope = def.getContainedScope();
        if (this.needsArguments && funcScope.getLocalDefinitionSetByName("arguments") == null) {
            VariableDefinition argumentsDef = new VariableDefinition("arguments");
            argumentsDef.setNamespaceReference(NamespaceDefinition.getDefaultNamespaceDefinition(funcScope));
            argumentsDef.setTypeReference(ReferenceFactory.builtinReference(IASLanguageConstants.BuiltinType.ARRAY));
            argumentsDef.setImplicit();
            funcScope.addDefinition(argumentsDef);
        }
    }

    private void setConstructorIfNeeded(FunctionDefinition funcDef) {
        if (this.isConstructor()) {
            ClassNode classNode;
            IASNode parentParent = this.getGrandparent();
            if (parentParent instanceof ClassNode && (classNode = (ClassNode)parentParent).getConstructorNode() == null && this.nameNode instanceof IdentifierNode) {
                ((IdentifierNode)this.nameNode).setReferenceValue(classNode.getDefinition());
                classNode.constructorNode = this;
            }
            funcDef.setNamespaceReference(NamespaceDefinition.getCodeModelImplicitDefinitionNamespace());
        }
    }

    FunctionDefinition buildDefinition() {
        String definitionName = this.getName();
        FunctionDefinition definition = this.createFunctionDefinition(definitionName);
        definition.setNode(this);
        this.fillInNamespaceAndModifiers(definition);
        this.fillInMetadata(definition);
        IReference returnType = this.typeNode != null ? this.typeNode.computeTypeReference() : null;
        definition.setReturnTypeReference(returnType);
        definition.setTypeReference(ReferenceFactory.builtinReference(IASLanguageConstants.BuiltinType.FUNCTION));
        this.setConstructorIfNeeded(definition);
        return definition;
    }

    protected FunctionDefinition createFunctionDefinition(String name) {
        return new FunctionDefinition(name);
    }

    public KeywordNode getFunctionKeywordNode() {
        return this.contentsPart.getFunctionKeywordNode();
    }

    public boolean isPackageLevelFunction() {
        IASNode parent = this.getParentIgnoringConditionals();
        IASNode parent2 = FunctionNode.getParentIgnoringConditionals(parent);
        if (parent instanceof BlockNode && parent2 instanceof PackageNode) {
            return true;
        }
        if (parent2 != null) {
            IASNode parent3 = FunctionNode.getParentIgnoringConditionals(parent2);
            if (this.isConstructor() && parent2 instanceof ClassNode && parent3 instanceof BlockNode && FunctionNode.getParentIgnoringConditionals(parent3) instanceof PackageNode) {
                return true;
            }
        }
        return false;
    }

    public INamespaceDecorationNode getActualNamespaceNode() {
        return super.getNamespaceNode();
    }

    public boolean isConstructorOf(ClassNode classNode) {
        return this.equals(classNode.getConstructorNode());
    }

    public Collection<ICompilerProblem> getParsingProblems() {
        if (this.parseProblems != null) {
            Collection<ICompilerProblem> problems = this.parseProblems;
            this.parseProblems = null;
            return problems;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parseFunctionBody(Collection<ICompilerProblem> problems) {
        if (!this.isBodyDeferred) {
            return;
        }
        this.deferredBodyParsingLock.lock();
        try {
            ++this.deferredBodyParsingReferenceCount;
            assert (problems != null) : "Problems collection can't be null";
            ScopedBlockNode contents = this.contentsPart.getContents();
            assert (contents != null) : "Function body node can't be null: function " + this.getName();
            if (contents.getChildCount() > 0) {
                return;
            }
            assert (this.deferredBodyParsingReferenceCount == 1);
            assert (this.openT != null) : "Expected '{' token.";
            String sourcePath = this.getSourcePath();
            assert (sourcePath != null && !sourcePath.isEmpty()) : "Souce path not set.";
            FileNode fileNode = (FileNode)this.getAncestorOfType(FileNode.class);
            assert (fileNode != null) : "FileNode not found: function " + this.getName();
            IWorkspace workspace = fileNode.getWorkspace();
            ASFileScope fileScope = fileNode.getFileScope();
            fileScope.addParsedFunctionBodies(this);
            try {
                Reader sourceReader;
                if (this.functionBodyText != null) {
                    sourceReader = new StringReader(this.functionBodyText);
                } else {
                    sourceReader = workspace.getFileSpecification(sourcePath).createReader();
                    sourceReader.skip(this.openT.getLocalEnd());
                }
                assert (!FunctionNode.anyNonParametersInScope(contents));
                ArrayList<ICompilerProblem> functionLocalProblems = new ArrayList<ICompilerProblem>();
                ASParser.parseFunctionBody(contents, sourceReader, sourcePath, this.openT, functionLocalProblems, workspace, fileNode, this.configProcessor);
                this.filterObsoleteProblems(fileNode, functionLocalProblems);
                problems.addAll(functionLocalProblems);
                this.functionBodyText = null;
                EnumSet<PostProcessStep> postProcess = EnumSet.of(PostProcessStep.CALCULATE_OFFSETS, PostProcessStep.POPULATE_SCOPE, PostProcessStep.RECONNECT_DEFINITIONS);
                problems.addAll(contents.runPostProcess(postProcess, contents.getASScope()));
                this.tryAddDefaultArgument();
            }
            catch (IOException e) {
                problems.add(new InternalCompilerProblem2(this.getSourcePath(), e, "function body parser"));
            }
        }
        finally {
            this.deferredBodyParsingLock.unlock();
        }
    }

    private void filterObsoleteProblems(FileNode fileNode, Collection<ICompilerProblem> localProblems) {
        Collection functionSignatureProblems;
        int functionStartLine = this.getLine();
        Collection<ICompilerProblem> problems = fileNode.getProblems();
        Collection filteredLocalProblems = Collections2.filter(localProblems, (Predicate)Predicates.and(FunctionNode.problemAtLine(functionStartLine), FunctionNode.problemOfType(CanNotInsertSemicolonProblem.class)));
        if (!filteredLocalProblems.isEmpty() && !(functionSignatureProblems = Collections2.filter(problems, FunctionNode.problemAtLine(functionStartLine))).isEmpty()) {
            localProblems.removeAll(filteredLocalProblems);
        }
    }

    private static Predicate<ICompilerProblem> problemAtLine(final int line) {
        return new Predicate<ICompilerProblem>(){

            public boolean apply(ICompilerProblem problem) {
                return problem.getLine() == line;
            }
        };
    }

    private static Predicate<ICompilerProblem> problemOfType(final Class<? extends ICompilerProblem> problemClass) {
        return new Predicate<ICompilerProblem>(){

            public boolean apply(ICompilerProblem problem) {
                return problemClass.isInstance(problem);
            }
        };
    }

    private static boolean anyNonParametersInScope(ScopedBlockNode contents) {
        IASScope sc = contents.getScope();
        Collection<IDefinition> ldfs = sc.getAllLocalDefinitions();
        for (IDefinition def : ldfs) {
            if (def instanceof IParameterDefinition) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void discardFunctionBody(ICompilerProject project) {
        if (!this.isBodyDeferred) {
            return;
        }
        this.deferredBodyParsingLock.lock();
        try {
            --this.deferredBodyParsingReferenceCount;
            if (this.deferredBodyParsingReferenceCount > 0) {
                return;
            }
            ScopedBlockNode contents = this.getScopedNode();
            if (contents.getChildCount() > 0) {
                FileNode fileNode = (FileNode)this.getAncestorOfType(FileNode.class);
                ASFileScope fileScope = fileNode.getFileScope();
                fileScope.removeParsedFunctionBodies(this);
                contents.removeAllChildren();
                IASScope functionScope = contents.getScope();
                Collection<IDefinition> localDefs = functionScope.getAllLocalDefinitions();
                for (IDefinition def : localDefs) {
                    if (def instanceof IParameterDefinition) continue;
                    ASScope asScope = (ASScope)functionScope;
                    asScope.removeDefinition(def);
                }
                if (project != null) {
                    ((CompilerProject)project).resetScopeCaches(Collections.singleton(functionScope));
                }
            }
            assert (contents.getScope() == null || !FunctionNode.anyNonParametersInScope(contents));
        }
        finally {
            this.deferredBodyParsingLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasBeenParsed() {
        if (!this.isBodyDeferred) {
            return true;
        }
        this.deferredBodyParsingLock.lock();
        try {
            boolean bl = this.deferredBodyParsingReferenceCount > 0;
            return bl;
        }
        finally {
            this.deferredBodyParsingLock.unlock();
        }
    }

    public final void setFunctionBodyInfo(ASToken openT, ASToken lastTokenInBody, ConfigProcessor configProcessor, StringBuilder bodyCache) {
        assert (openT != null) : "Open curly token can't be null";
        assert (openT.getType() == 19) : "Expected '{' token.";
        assert (lastTokenInBody != null) : "Last token in function body can't be null.";
        assert (configProcessor != null) : "Project config variables can't be null.";
        this.openT = openT.clone();
        this.configProcessor = configProcessor;
        this.isBodyDeferred = true;
        this.functionBodyText = bodyCache == null ? null : bodyCache.toString();
    }
}

