/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.IAccessorDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.IFunctionDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.internal.tree.as.ClassNode;
import com.adobe.flash.compiler.internal.tree.as.ContainerNode;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.FunctionNode;
import com.adobe.flash.compiler.internal.tree.as.KeywordNode;
import com.adobe.flash.compiler.internal.tree.as.MemberAccessExpressionNode;
import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.IFunctionCallNode;
import com.adobe.flash.compiler.tree.as.IIdentifierNode;
import com.adobe.flash.compiler.tree.as.ILanguageIdentifierNode;
import java.util.ArrayList;

public class FunctionCallNode
extends ExpressionNodeBase
implements IFunctionCallNode {
    private KeywordNode newKeywordNode;
    private ExpressionNodeBase nameNode;
    private ContainerNode argumentsNode;

    public FunctionCallNode(IASToken keywordNew, ExpressionNodeBase nameNode) {
        assert (keywordNew != null) : "Expected 'new' token.";
        assert (nameNode != null) : "Expected name expression.";
        this.newKeywordNode = new KeywordNode(keywordNew);
        this.nameNode = nameNode;
        this.argumentsNode = new ContainerNode(2);
    }

    public FunctionCallNode(ExpressionNodeBase nameNode) {
        this.newKeywordNode = null;
        this.nameNode = nameNode;
        this.argumentsNode = new ContainerNode(2);
    }

    protected FunctionCallNode(FunctionCallNode other) {
        super(other);
        this.newKeywordNode = other.newKeywordNode != null ? new KeywordNode(other.newKeywordNode) : null;
        this.nameNode = other.nameNode != null ? other.nameNode.copy() : null;
        this.argumentsNode = new ContainerNode(other.argumentsNode.getChildCount());
        for (IExpressionNode arg : other.getArgumentNodes()) {
            this.argumentsNode.addItem(((ExpressionNodeBase)arg).copy());
        }
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.FunctionCallID;
    }

    @Override
    public int getChildCount() {
        int count = 0;
        if (this.newKeywordNode != null) {
            ++count;
        }
        if (this.nameNode != null) {
            ++count;
        }
        if (this.argumentsNode != null) {
            ++count;
        }
        return count;
    }

    @Override
    public IASNode getChild(int i) {
        if (i > this.getChildCount()) {
            return null;
        }
        if (i == 0) {
            if (this.newKeywordNode != null) {
                return this.newKeywordNode;
            }
            return this.nameNode != null ? this.nameNode : this.argumentsNode;
        }
        if (i == 1) {
            return this.newKeywordNode != null ? this.nameNode : this.argumentsNode;
        }
        if (i == 2) {
            return this.argumentsNode;
        }
        return null;
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        if (this.newKeywordNode != null) {
            this.newKeywordNode.setParent(this);
        }
        if (this.nameNode != null) {
            this.nameNode.setParent(this);
        }
        if (this.argumentsNode != null) {
            this.argumentsNode.setParent(this);
        }
    }

    @Override
    protected void replaceChild(NodeBase child, NodeBase target) {
        if (child == this.nameNode && target instanceof ExpressionNodeBase) {
            this.nameNode = (ExpressionNodeBase)target;
            this.nameNode.setParent(this);
        }
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        String name = "";
        ExpressionNodeBase nameNode = this.getNameNode();
        if (nameNode instanceof IIdentifierNode) {
            name = ((IIdentifierNode)((Object)nameNode)).getName();
        }
        sb.append('\"');
        sb.append(name);
        sb.append('\"');
        return true;
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        IDefinition calledFunction = this.nameNode.resolve(project);
        if (calledFunction instanceof IFunctionDefinition && !(calledFunction instanceof IAccessorDefinition)) {
            if (this.getNewKeywordNode() != null) {
                return project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
            }
            return ((IFunctionDefinition)calledFunction).resolveReturnType(project);
        }
        if (calledFunction instanceof ITypeDefinition) {
            if (!this.isNewExpression() && calledFunction.getQualifiedName().equals("Date")) {
                return project.getBuiltinType(IASLanguageConstants.BuiltinType.STRING);
            }
            return (ITypeDefinition)calledFunction;
        }
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
    }

    @Override
    protected FunctionCallNode copy() {
        return new FunctionCallNode(this);
    }

    @Override
    public boolean isNewExpression() {
        return this.newKeywordNode != null;
    }

    @Override
    public ExpressionNodeBase getNameNode() {
        return this.nameNode;
    }

    @Override
    public String getFunctionName() {
        return this.nameNode instanceof IIdentifierNode ? ((IIdentifierNode)((Object)this.nameNode)).getName() : "";
    }

    @Override
    public IDefinition resolveCalledExpression(ICompilerProject project) {
        ExpressionNodeBase nameNode = this.getNameNode();
        return nameNode.resolve(project);
    }

    @Override
    public IExpressionNode[] getArgumentNodes() {
        ArrayList<IExpressionNode> retVal = new ArrayList<IExpressionNode>();
        if (this.argumentsNode != null) {
            int childCount = this.argumentsNode.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                IASNode child = this.argumentsNode.getChild(i);
                if (!(child instanceof IExpressionNode)) continue;
                retVal.add((IExpressionNode)child);
            }
        }
        return retVal.toArray(new IExpressionNode[0]);
    }

    public boolean isSuperExpression() {
        return this.nameNode instanceof ILanguageIdentifierNode && ((ILanguageIdentifierNode)((Object)this.nameNode)).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.SUPER;
    }

    public ContainerNode getArgumentsNode() {
        return this.argumentsNode;
    }

    public KeywordNode getNewKeywordNode() {
        return this.newKeywordNode;
    }

    public boolean isCallToSuper() {
        return this.nameNode instanceof ILanguageIdentifierNode && this.nameNode.getAncestorOfType(ClassNode.class) != null && ((ILanguageIdentifierNode)((Object)this.nameNode)).getKind() == ILanguageIdentifierNode.LanguageIdentifierKind.SUPER && this.nameNode.getAncestorOfType(MemberAccessExpressionNode.class) == null && this.getAncestorOfType(FunctionNode.class) != null;
    }
}

