/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.IdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.MemberAccessExpressionNode;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IIdentifierNode;

public class FullNameNode
extends MemberAccessExpressionNode
implements IIdentifierNode {
    public static ExpressionNodeBase toMemberAccessExpressionNode(ExpressionNodeBase node) {
        if (node instanceof FullNameNode) {
            FullNameNode fullnameNode = (FullNameNode)node;
            ExpressionNodeBase left = FullNameNode.toMemberAccessExpressionNode(fullnameNode.leftOperandNode);
            ExpressionNodeBase right = FullNameNode.toMemberAccessExpressionNode(fullnameNode.rightOperandNode);
            MemberAccessExpressionNode result = new MemberAccessExpressionNode(left, null, right);
            result.operatorStart = fullnameNode.operatorStart;
            result.setHasParenthesis(fullnameNode.hasParenthesis());
            return result;
        }
        return node;
    }

    public FullNameNode(ExpressionNodeBase left, IASToken operator, ExpressionNodeBase right) {
        super(left, operator, right);
        if (right != null) {
            this.setEnd(right.getAbsoluteEnd());
        }
    }

    protected FullNameNode(MemberAccessExpressionNode node) {
        super(node.leftOperandNode, null, node.rightOperandNode);
        this.operatorStart = node.operatorStart;
        this.setHasParenthesis(node.hasParenthesis());
    }

    protected FullNameNode(FullNameNode other) {
        super(other);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.FullNameID;
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getName());
        sb.append('\"');
        return true;
    }

    @Override
    protected FullNameNode copy() {
        return new FullNameNode(this);
    }

    @Override
    public String computeSimpleReference() {
        return this.getName();
    }

    @Override
    public void setRightOperandNode(ExpressionNodeBase right) {
        super.setRightOperandNode(right);
        if (right != null) {
            this.setEnd(right.getAbsoluteEnd());
        }
    }

    @Override
    public String getName() {
        if (this.leftOperandNode != null && this.leftOperandNode != this && (this.leftOperandNode instanceof IdentifierNode || this.leftOperandNode instanceof FullNameNode) && this.rightOperandNode != null && this.rightOperandNode != this && (this.rightOperandNode instanceof IdentifierNode || this.rightOperandNode instanceof FullNameNode)) {
            StringBuilder builder = new StringBuilder();
            builder.append(((IIdentifierNode)((Object)this.leftOperandNode)).getName());
            builder.append(".");
            builder.append(((IIdentifierNode)((Object)this.rightOperandNode)).getName());
            return builder.toString();
        }
        return "";
    }

    @Override
    public IIdentifierNode.IdentifierType getIdentifierType() {
        return IIdentifierNode.IdentifierType.FULLY_QUALIFIED_NAME;
    }
}

