/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.tree.as.BlockNode;
import com.adobe.flash.compiler.internal.tree.as.ContainerNode;
import com.adobe.flash.compiler.internal.tree.as.FixedChildrenNode;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.IForLoopNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;

public class ForLoopNode
extends FixedChildrenNode
implements IForLoopNode {
    protected ContainerNode conditionsStatementsNode;
    protected BlockNode contentsNode;
    private IForLoopNode.ForLoopKind kind;

    public ForLoopNode(IASToken forKeyword) {
        if (forKeyword != null) {
            this.startBefore(forKeyword);
            this.kind = forKeyword.getText().length() == 3 ? IForLoopNode.ForLoopKind.FOR : IForLoopNode.ForLoopKind.FOR_EACH;
        } else {
            this.kind = IForLoopNode.ForLoopKind.FOR;
        }
        this.conditionsStatementsNode = new ContainerNode();
        this.contentsNode = new BlockNode();
    }

    @Override
    public ASTNodeID getNodeID() {
        switch (this.kind) {
            case FOR: {
                return ASTNodeID.ForLoopID;
            }
            case FOR_EACH: {
                return ASTNodeID.ForEachLoopID;
            }
        }
        return ASTNodeID.ForLoopID;
    }

    @Override
    public int getChildCount() {
        int count = 0;
        if (this.conditionsStatementsNode != null) {
            ++count;
        }
        if (this.contentsNode != null) {
            ++count;
        }
        return count;
    }

    @Override
    public IASNode getChild(int i) {
        if (i == 0) {
            return this.conditionsStatementsNode;
        }
        if (i == 1) {
            return this.contentsNode;
        }
        return null;
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        this.conditionsStatementsNode.analyze(set, scope, problems);
        this.contentsNode.analyze(set, scope, problems);
    }

    @Override
    public IASNode getStatementContentsNode() {
        return this.contentsNode;
    }

    @Override
    public IForLoopNode.ForLoopKind getKind() {
        return this.kind;
    }

    @Override
    public IExpressionNode[] getConditionalExpressionNodes() {
        int childCount = this.conditionsStatementsNode.getChildCount();
        ArrayList<IExpressionNode> retVal = new ArrayList<IExpressionNode>(3);
        for (int i = 0; i < childCount; ++i) {
            IASNode child = this.getChild(i);
            if (!(child instanceof IExpressionNode)) continue;
            retVal.add((IExpressionNode)child);
        }
        return retVal.toArray(new IExpressionNode[0]);
    }

    @Override
    public ContainerNode getConditionalsContainerNode() {
        return this.conditionsStatementsNode;
    }

    public BlockNode getContentsNode() {
        return this.contentsNode;
    }
}

