/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.common.IEmbedResolver;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.definitions.metadata.IMetaTagAttribute;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.units.EmbedCompilationUnit;
import com.adobe.flash.compiler.internal.units.EmbedCompilationUnitFactory;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IEmbedNode;
import com.adobe.flash.compiler.tree.as.IFileNodeAccumulator;
import com.adobe.flash.compiler.tree.metadata.IMetaTagNode;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.utils.FilenameNormalization;
import java.util.ArrayList;
import java.util.Collection;

public class EmbedNode
extends ExpressionNodeBase
implements IEmbedNode,
IEmbedResolver {
    private final String containingSourceFilename;
    private final IMetaTagNode metaData;

    public EmbedNode(String containingFilePath, IMetaTagNode metaData, IFileNodeAccumulator fileNodeAccumulator) {
        this.containingSourceFilename = FilenameNormalization.normalize(containingFilePath);
        this.metaData = metaData;
        assert (metaData != null && metaData.getAllAttributes() != null);
        if (fileNodeAccumulator != null) {
            fileNodeAccumulator.addEmbedNode(this);
        }
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.EmbedID;
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        return null;
    }

    @Override
    protected EmbedNode copy() {
        return null;
    }

    @Override
    public IMetaTagAttribute[] getAttributes() {
        return this.metaData.getAllAttributes();
    }

    @Override
    public EmbedCompilationUnit resolveCompilationUnit(ICompilerProject project, Collection<ICompilerProblem> problems) throws InterruptedException {
        assert (project instanceof CompilerProject);
        return EmbedCompilationUnitFactory.getCompilationUnit((CompilerProject)project, this.containingSourceFilename, this.metaData, this.metaData.getAllAttributes(), problems);
    }

    @Override
    public EmbedCompilationUnit resolveCompilationUnit(ICompilerProject project) throws InterruptedException {
        ArrayList ignoredProblems = new ArrayList();
        return this.resolveCompilationUnit(project, (Collection)ignoredProblems);
    }

    public String getName(ICompilerProject project, Collection<ICompilerProblem> problems) throws InterruptedException {
        ICompilationUnit cu = this.resolveCompilationUnit(project, (Collection)problems);
        if (cu == null) {
            return new String();
        }
        return ((EmbedCompilationUnit)cu).getName();
    }
}

