/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.abc.semantics.ECMASupport;
import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.internal.as.codegen.CodeGeneratorManager;
import com.adobe.flash.compiler.internal.as.codegen.ICodeGenerator;
import com.adobe.flash.compiler.internal.definitions.AppliedVectorDefinition;
import com.adobe.flash.compiler.internal.tree.as.BinaryOperatorNodeBase;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IDynamicAccessNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.IOperatorNode;

public class DynamicAccessNode
extends BinaryOperatorNodeBase
implements IDynamicAccessNode {
    public DynamicAccessNode(ExpressionNodeBase leftOperandNode) {
        super(null, leftOperandNode, null);
    }

    protected DynamicAccessNode(DynamicAccessNode other) {
        super(other);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.ArrayIndexExpressionID;
    }

    @Override
    protected DynamicAccessNode copy() {
        return new DynamicAccessNode(this);
    }

    @Override
    public boolean isDynamicExpression(ICompilerProject project) {
        return true;
    }

    @Override
    public IOperatorNode.OperatorType getOperator() {
        return IOperatorNode.OperatorType.DYNAMIC_ACCESS;
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        IExpressionNode left = this.getLeftOperandNode();
        IExpressionNode right = this.getRightOperandNode();
        ITypeDefinition leftType = left.resolveType(project);
        ITypeDefinition rightType = right.resolveType(project);
        if (leftType != null && rightType != null && AppliedVectorDefinition.isVectorDefinition(leftType)) {
            ICodeGenerator codegenerator;
            ICodeGenerator.IConstantValue value;
            boolean indexIsInt = false;
            indexIsInt = rightType.equals(project.getBuiltinType(IASLanguageConstants.BuiltinType.INT));
            if (!indexIsInt && (value = (codegenerator = CodeGeneratorManager.getCodeGenerator()).generateConstantValue(right, project)) != null && value.getValue() instanceof Number && ECMASupport.equals(value.getValue(), (Object)ECMASupport.toInt32(value.getValue()))) {
                indexIsInt = true;
            }
            if (indexIsInt) {
                return ((AppliedVectorDefinition)leftType).resolveElementType(project);
            }
        }
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
    }
}

