/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.internal.tree.as.NodeBase;
import com.adobe.flash.compiler.internal.tree.as.TreeNode;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IContainerNode;

public class ContainerNode
extends TreeNode
implements IContainerNode {
    public static final ContainerNode EMPTY_CONTAINER = new ContainerNode(0);
    private IContainerNode.ContainerType containerType = IContainerNode.ContainerType.SYNTHESIZED;

    public ContainerNode() {
    }

    public ContainerNode(int size) {
        super(size);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.ContainerID;
    }

    @Override
    public boolean contains(int offset) {
        return this.getAbsoluteStart() <= offset && this.getAbsoluteEnd() >= offset;
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append(this.containerType.name()).append(' ');
        return super.buildInnerString(sb);
    }

    @Override
    public IContainerNode.ContainerType getContainerType() {
        return this.containerType;
    }

    public void setContainerType(IContainerNode.ContainerType containerType) {
        this.containerType = containerType;
    }

    public void addItem(NodeBase child) {
        this.addChild(child);
    }

    public void addItemAfterNormalization(NodeBase child) {
        this.addChildPostNormalize(child);
    }

    public void addTemporaryItem(NodeBase child) {
        if (child != null) {
            this.addTemporaryChild(child);
        }
    }

    public void removeItem(NodeBase child) {
        this.removeChild(child);
    }

    public void removeTemporaryItem(NodeBase child) {
        if (child != null) {
            this.removeTemporaryChild(child);
        }
    }
}

