/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.common.ASImportTarget;
import com.adobe.flash.compiler.common.IImportTarget;
import com.adobe.flash.compiler.common.Multiname;
import com.adobe.flash.compiler.common.RecursionGuard;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.metadata.IMetaTag;
import com.adobe.flash.compiler.definitions.metadata.IMetaTagAttribute;
import com.adobe.flash.compiler.definitions.references.INamespaceReference;
import com.adobe.flash.compiler.definitions.references.IReference;
import com.adobe.flash.compiler.internal.definitions.ClassDefinition;
import com.adobe.flash.compiler.internal.definitions.FunctionDefinition;
import com.adobe.flash.compiler.internal.definitions.NamespaceDefinition;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.scopes.TypeScope;
import com.adobe.flash.compiler.internal.semantics.PostProcessStep;
import com.adobe.flash.compiler.internal.tree.as.ContainerNode;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.FileNode;
import com.adobe.flash.compiler.internal.tree.as.FunctionNode;
import com.adobe.flash.compiler.internal.tree.as.IdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.KeywordNode;
import com.adobe.flash.compiler.internal.tree.as.MemberedNode;
import com.adobe.flash.compiler.internal.tree.as.NamespaceIdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.TransparentContainerNode;
import com.adobe.flash.compiler.internal.tree.as.metadata.MetaTagsNode;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IClassNode;
import com.adobe.flash.compiler.tree.as.IDefinitionNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.IIdentifierNode;
import com.adobe.flash.compiler.tree.metadata.IMetaTagNode;
import com.adobe.flash.compiler.tree.metadata.IMetaTagsNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;

public class ClassNode
extends MemberedNode
implements IClassNode {
    protected KeywordNode classKeywordNode;
    protected KeywordNode extendsKeywordNode;
    protected ExpressionNodeBase baseClassNode;
    private String qualifiedName;
    protected KeywordNode implementsKeywordNode;
    protected TransparentContainerNode interfacesNode;
    protected FunctionNode constructorNode;
    protected FunctionNode defaultConstructorNode;

    public ClassNode(ExpressionNodeBase name) {
        this.init(name);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.ClassID;
    }

    @Override
    public int getSpanningStart() {
        return this.getNodeStartForTooling();
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        this.addDecorationChildren(fillInOffsets);
        this.addChildInOrder(this.classKeywordNode, fillInOffsets);
        this.addChildInOrder(this.nameNode, fillInOffsets);
        this.addChildInOrder(this.extendsKeywordNode, fillInOffsets);
        this.addChildInOrder(this.baseClassNode, fillInOffsets);
        this.addChildInOrder(this.implementsKeywordNode, fillInOffsets);
        if (this.implementsKeywordNode != null || this.interfacesNode.getChildCount() > 0) {
            this.addChildInOrder(this.interfacesNode, fillInOffsets);
        }
        this.addChildInOrder(this.contentsNode, fillInOffsets);
    }

    @Override
    protected void analyze(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        if (set.contains((Object)PostProcessStep.POPULATE_SCOPE)) {
            ClassDefinition definition = this.buildDefinition();
            this.setDefinition(definition);
            scope.addDefinition(definition);
            TypeScope typeScope = new TypeScope(scope, this.contentsNode, definition);
            definition.setContainedScope(typeScope);
            definition.setupThisAndSuper();
            definition.buildContingentDefinitions();
            scope = typeScope;
        }
        if (set.contains((Object)PostProcessStep.RECONNECT_DEFINITIONS)) {
            this.reconnectDef(scope);
            scope = this.getDefinition().getContainedScope();
            this.contentsNode.reconnectScope(scope);
        }
        this.contentsNode.analyze(set, scope, problems);
        MetaTagsNode metadata = this.getMetaTagsNode();
        if (metadata != null) {
            metadata.analyze(set, scope, problems);
        }
        if (set.contains((Object)PostProcessStep.POPULATE_SCOPE)) {
            this.setupConstructor(set, scope, problems);
        }
        if (this.baseClassNode != null) {
            this.baseClassNode.analyze(set, scope, problems);
        }
        if (this.interfacesNode != null) {
            this.interfacesNode.analyze(set, scope, problems);
        }
    }

    @Override
    protected boolean buildInnerString(StringBuilder sb) {
        sb.append('\"');
        sb.append(this.getName());
        sb.append('\"');
        return true;
    }

    @Override
    protected int getInitialChildCount() {
        return 6;
    }

    @Override
    protected void init(ExpressionNodeBase nameNode) {
        super.init(nameNode);
        this.extendsKeywordNode = null;
        this.baseClassNode = null;
        this.implementsKeywordNode = null;
        this.interfacesNode = new TransparentContainerNode();
        this.constructorNode = null;
        this.defaultConstructorNode = null;
    }

    @Override
    public ClassDefinition getDefinition() {
        return (ClassDefinition)super.getDefinition();
    }

    @Override
    public void setDefinition(IDefinition def) {
        assert (def instanceof ClassDefinition);
        super.setDefinition(def);
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            IImportTarget importTarget = ASImportTarget.buildImportFromPackageName(this.getWorkspace(), this.getPackageName());
            String qname = importTarget.getQualifiedName(this.getName());
            if (qname == null) {
                this.qualifiedName = this.getShortName();
            }
            this.qualifiedName = qname;
        }
        return this.qualifiedName;
    }

    @Override
    public String getShortName() {
        String name = this.getName();
        int lastDot = name.lastIndexOf(".");
        if (lastDot != -1) {
            name = name.substring(lastDot + 1);
        }
        return name;
    }

    @Override
    public IClassDefinition.ClassClassification getClassClassification() {
        if (this.getParent() instanceof FileNode) {
            return IClassDefinition.ClassClassification.FILE_MEMBER;
        }
        return IClassDefinition.ClassClassification.PACKAGE_MEMBER;
    }

    @Override
    public IMetaTag[] getMetaTagsByName(String name) {
        return this.getDefinition().getMetaTagsByName(name);
    }

    @Override
    public IMetaTagNode[] getMetaTagNodesByName(String name) {
        ArrayList<IMetaTagNode> allMatchingAttributes = new ArrayList<IMetaTagNode>();
        this.getMetaTagsByName(name, new RecursionGuard(), allMatchingAttributes);
        return allMatchingAttributes.toArray(new IMetaTagNode[0]);
    }

    @Override
    public IExpressionNode getBaseClassExpressionNode() {
        return this.baseClassNode;
    }

    @Override
    public String getBaseClassName() {
        return this.baseClassNode instanceof IIdentifierNode ? ((IIdentifierNode)((Object)this.baseClassNode)).getName() : "";
    }

    @Override
    public IExpressionNode[] getImplementedInterfaceNodes() {
        ArrayList<IExpressionNode> names = new ArrayList<IExpressionNode>();
        int childCount = this.interfacesNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (!(this.interfacesNode.getChild(i) instanceof IIdentifierNode)) continue;
            names.add((IExpressionNode)this.interfacesNode.getChild(i));
        }
        return names.toArray(new IExpressionNode[0]);
    }

    @Override
    public String[] getImplementedInterfaces() {
        int childCount;
        ArrayList<String> interfaceNodeList = new ArrayList<String>();
        if (this.interfacesNode != null && (childCount = this.interfacesNode.getChildCount()) > 0) {
            for (int i = 0; i < childCount; ++i) {
                IASNode child = this.interfacesNode.getChild(i);
                if (!(child instanceof IIdentifierNode)) continue;
                interfaceNodeList.add(((IIdentifierNode)child).getName());
            }
        }
        return interfaceNodeList.toArray(new String[0]);
    }

    @Override
    public IDefinitionNode[] getAllMemberNodes() {
        ArrayList<IDefinitionNode> names = new ArrayList<IDefinitionNode>();
        int childCount = this.contentsNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (!(this.contentsNode.getChild(i) instanceof IDefinitionNode)) continue;
            names.add((IDefinitionNode)this.contentsNode.getChild(i));
        }
        return names.toArray(new IDefinitionNode[0]);
    }

    public void setClassKeyword(IASToken classKeyword) {
        this.classKeywordNode = new KeywordNode(classKeyword);
    }

    public void setExtendsKeyword(IASToken extendsKeyword) {
        this.extendsKeywordNode = new KeywordNode(extendsKeyword);
    }

    public void setBaseClass(ExpressionNodeBase baseClassNode) {
        this.baseClassNode = baseClassNode;
    }

    public void setImplementsKeyword(IASToken implementsKeyword) {
        this.implementsKeywordNode = new KeywordNode(implementsKeyword);
    }

    public void addInterface(ExpressionNodeBase interfaceName) {
        this.interfacesNode.addChild(interfaceName);
    }

    public void buildExplicitMemberDefs(TypeScope classScope) {
        this.contentsNode.analyze(EnumSet.of(PostProcessStep.POPULATE_SCOPE), classScope, new ArrayList<ICompilerProblem>());
    }

    ClassDefinition buildDefinition() {
        String definitionName = Multiname.getBaseNameForQName(this.nameNode.computeSimpleReference());
        INamespaceReference namespaceReference = NamespaceDefinition.createNamespaceReference(this.getASScope(), this.getNamespaceNode());
        ClassDefinition definition = new ClassDefinition(definitionName, namespaceReference);
        definition.setNode(this);
        this.fillInModifiers(definition);
        this.fillInMetadata(definition);
        this.fillInStateNames(definition);
        IReference baseRef = null;
        if (this.baseClassNode != null) {
            baseRef = this.baseClassNode.computeTypeReference();
        }
        definition.setBaseClassReference(baseRef);
        if (this.interfacesNode != null) {
            int n = this.interfacesNode.getChildCount();
            ArrayList<IReference> interfaces = new ArrayList<IReference>(n);
            for (int i = 0; i < n; ++i) {
                IReference typeReference;
                IASNode child = this.interfacesNode.getChild(i);
                if (!(child instanceof ExpressionNodeBase) || (typeReference = ((ExpressionNodeBase)child).computeTypeReference()) == null) continue;
                interfaces.add(typeReference);
            }
            definition.setImplementedInterfaceReferences(interfaces.toArray(new IReference[interfaces.size()]));
        }
        return definition;
    }

    private void fillInStateNames(ClassDefinition definition) {
        IMetaTag[] statesMetaData;
        for (IMetaTag stateMetaData : statesMetaData = this.getMetaTagsByName("States")) {
            for (IMetaTagAttribute attribute : stateMetaData.getAllAttributes()) {
                definition.addStateName(attribute.getValue());
            }
        }
    }

    private void setupConstructor(EnumSet<PostProcessStep> set, ASScope scope, Collection<ICompilerProblem> problems) {
        FunctionDefinition ctorDef = null;
        if (this.constructorNode == null) {
            IdentifierNode constructorNameNode = new IdentifierNode(this.getName());
            constructorNameNode.setReferenceValue(this.getDefinition());
            constructorNameNode.span(this.getNameAbsoluteStart(), this.getNameAbsoluteEnd(), -1, -1);
            this.defaultConstructorNode = new FunctionNode(null, constructorNameNode);
            NamespaceIdentifierNode pub = new NamespaceIdentifierNode("public");
            pub.span(-1, -1, -1, -1);
            this.defaultConstructorNode.setNamespace(pub);
            this.defaultConstructorNode.normalize(true);
            this.defaultConstructorNode.setParent(this.contentsNode);
            ctorDef = this.defaultConstructorNode.buildDefinition();
            ctorDef.setImplicit();
            scope.addDefinition(ctorDef);
            assert (this.constructorNode == this.defaultConstructorNode) : "FunctionNode.buildDefinition should set the constructor node field";
        } else {
            ctorDef = this.constructorNode.getDefinition();
        }
        assert (ctorDef != null);
        ctorDef.setAsConstructor((ClassDefinition)scope.getDefinition());
    }

    public FunctionNode getConstructorNode() {
        return this.constructorNode;
    }

    public FunctionNode getDefaultConstructorNode() {
        return this.defaultConstructorNode;
    }

    public String[] getInterfaceNames() {
        ArrayList<String> names = new ArrayList<String>();
        int childCount = this.interfacesNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (!(this.interfacesNode.getChild(i) instanceof IIdentifierNode)) continue;
            names.add(((IIdentifierNode)this.interfacesNode.getChild(i)).getName());
        }
        return names.toArray(new String[0]);
    }

    public KeywordNode getClassKeywordNode() {
        return this.classKeywordNode;
    }

    public KeywordNode getExtendsKeywordNode() {
        return this.extendsKeywordNode;
    }

    public ExpressionNodeBase getBaseClassNode() {
        return this.baseClassNode;
    }

    public KeywordNode getImplementsKeywordNode() {
        return this.implementsKeywordNode;
    }

    public ContainerNode getInterfacesNode() {
        return this.interfacesNode;
    }

    protected void getMetaTagsByName(String name, RecursionGuard recursionGuard, ArrayList<IMetaTagNode> allMatchingAttributes) {
        IMetaTagsNode metaTags = this.getMetaTags();
        if (metaTags != null) {
            IMetaTagNode[] matchingAttributes = metaTags.getTagsByName(name);
            allMatchingAttributes.addAll(Arrays.asList(matchingAttributes));
        }
    }

    public boolean canCacheMetaTags() {
        FileNode fileNode = (FileNode)this.getAncestorOfType(FileNode.class);
        return !fileNode.hasIncludes();
    }
}

