/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.internal.tree.as.BinaryOperatorNodeBase;
import com.adobe.flash.compiler.internal.tree.as.ExpressionNodeBase;
import com.adobe.flash.compiler.internal.tree.as.IdentifierNode;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IOperatorNode;

public class BinaryOperatorPlusNode
extends BinaryOperatorNodeBase {
    public BinaryOperatorPlusNode(IASToken operatorToken, ExpressionNodeBase leftOperand, ExpressionNodeBase rightOperand) {
        super(operatorToken, leftOperand, rightOperand);
    }

    protected BinaryOperatorPlusNode(BinaryOperatorPlusNode other) {
        super(other);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.Op_AddID;
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        ITypeDefinition leftType = this.getLeftOperandNode().resolveType(project);
        ITypeDefinition rightType = this.getRightOperandNode().resolveType(project);
        if (this.isNumericType(leftType, project) && this.isNumericType(rightType, project)) {
            return project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER);
        }
        ITypeDefinition stringType = project.getBuiltinType(IASLanguageConstants.BuiltinType.STRING);
        if (stringType.equals(leftType) || stringType.equals(rightType)) {
            return stringType;
        }
        if (IdentifierNode.isXMLish(leftType, project) && IdentifierNode.isXMLish(rightType, project)) {
            return project.getBuiltinType(IASLanguageConstants.BuiltinType.XMLLIST);
        }
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.ANY_TYPE);
    }

    @Override
    protected BinaryOperatorPlusNode copy() {
        return new BinaryOperatorPlusNode(this);
    }

    @Override
    public IOperatorNode.OperatorType getOperator() {
        return IOperatorNode.OperatorType.PLUS;
    }

    private boolean isNumericType(ITypeDefinition type, ICompilerProject project) {
        if (project.getBuiltinType(IASLanguageConstants.BuiltinType.NUMBER).equals(type)) {
            return true;
        }
        if (project.getBuiltinType(IASLanguageConstants.BuiltinType.INT).equals(type)) {
            return true;
        }
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.UINT).equals(type);
    }
}

