/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.constants.IASLanguageConstants;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.internal.tree.as.BaseLiteralContainerNode;
import com.adobe.flash.compiler.internal.tree.as.ContainerNode;
import com.adobe.flash.compiler.internal.tree.as.LiteralNode;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.tree.ASTNodeID;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.tree.as.IIdentifierNode;
import com.adobe.flash.compiler.tree.as.ILiteralNode;

public class ArrayLiteralNode
extends BaseLiteralContainerNode {
    public ArrayLiteralNode() {
        super(new LiteralNode(ILiteralNode.LiteralType.ARRAY, ""));
    }

    protected ArrayLiteralNode(ArrayLiteralNode other) {
        super(other);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.ArrayLiteralID;
    }

    @Override
    public ITypeDefinition resolveType(ICompilerProject project) {
        return project.getBuiltinType(IASLanguageConstants.BuiltinType.ARRAY);
    }

    @Override
    protected ArrayLiteralNode copy() {
        return new ArrayLiteralNode(this);
    }

    @Override
    public boolean isDynamicExpression(ICompilerProject project) {
        return true;
    }

    @Override
    public ILiteralNode.LiteralType getLiteralType() {
        return ILiteralNode.LiteralType.ARRAY;
    }

    @Override
    public String getValue() {
        return this.getValue(false);
    }

    @Override
    public String getValue(boolean rawValue) {
        StringBuilder builder = new StringBuilder();
        ContainerNode contents = this.getContentsNode();
        int childcount = contents.getChildCount();
        for (int i = 0; i < childcount; ++i) {
            IASNode child = contents.getChild(i);
            if (child instanceof ILiteralNode) {
                builder.append(((ILiteralNode)child).getValue(rawValue));
            } else if (child instanceof IIdentifierNode) {
                builder.append(((ILiteralNode)child).getValue(rawValue));
            }
            if (i + 1 >= childcount) continue;
            builder.append(",");
        }
        return "[" + builder.toString() + "]";
    }
}

