/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.tree.as;

import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.definitions.IVariableDefinition;
import com.adobe.flash.compiler.internal.definitions.FunctionDefinition;
import com.adobe.flash.compiler.internal.tree.as.FunctionNode;
import com.adobe.flash.compiler.internal.tree.as.IdentifierNode;
import com.adobe.flash.compiler.internal.tree.as.KeywordNode;
import com.adobe.flash.compiler.internal.tree.as.PackageNode;
import com.adobe.flash.compiler.internal.tree.as.parts.AccessorFunctionContentsPart;
import com.adobe.flash.compiler.internal.tree.as.parts.IAccessorFunctionContentsPart;
import com.adobe.flash.compiler.internal.tree.as.parts.IFunctionContentsPart;
import com.adobe.flash.compiler.parsing.IASToken;
import com.adobe.flash.compiler.tree.as.IAccessorNode;
import com.adobe.flash.compiler.tree.as.ICommonClassNode;
import com.adobe.flash.compiler.tree.as.IExpressionNode;
import com.adobe.flash.compiler.tree.as.IInterfaceNode;
import com.adobe.flash.compiler.tree.as.IKeywordNode;
import com.adobe.flash.compiler.tree.as.IScopedNode;
import com.adobe.flash.compiler.tree.as.decorators.IVariableTypeDecorator;
import com.adobe.flash.compiler.tree.as.decorators.SymbolDecoratorProvider;
import java.util.Iterator;
import java.util.List;

public abstract class AccessorNode
extends FunctionNode
implements IAccessorNode {
    public AccessorNode(IASToken functionKeyword, IASToken accessorKeyword, IdentifierNode nameNode) {
        super(functionKeyword, nameNode);
        if (accessorKeyword != null) {
            ((IAccessorFunctionContentsPart)this.contentsPart).setAccessorKeyword(new KeywordNode(accessorKeyword));
        }
    }

    public AccessorNode(IdentifierNode node, IAccessorFunctionContentsPart part) {
        super(node, part);
    }

    @Override
    protected void setChildren(boolean fillInOffsets) {
        this.addDecorationChildren(fillInOffsets);
        this.addChildInOrder(this.contentsPart.getFunctionKeywordNode(), fillInOffsets);
        this.addChildInOrder(((IAccessorFunctionContentsPart)this.contentsPart).getAccessorKeyword(), fillInOffsets);
        this.addChildInOrder(this.nameNode, fillInOffsets);
        this.addChildInOrder(this.contentsPart.getParametersNode(), fillInOffsets);
        this.addChildInOrder(this.typeNode, fillInOffsets);
        this.addChildInOrder(this.contentsPart.getContents(), fillInOffsets);
    }

    @Override
    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isCastFunction() {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return super.isImplicit();
    }

    @Override
    public String getReturnType() {
        FunctionDefinition definition = this.getDefinition();
        List<IVariableTypeDecorator> list = SymbolDecoratorProvider.getProvider().getVariableTypeDecorators(definition);
        if (list.size() > 0) {
            Iterator<IVariableTypeDecorator> it = list.iterator();
            while (it.hasNext()) {
                IDefinition type = it.next().decorateVariableType(definition);
                if (!(type instanceof ITypeDefinition)) continue;
                return type.getQualifiedName();
            }
        }
        return super.getReturnType();
    }

    @Override
    protected IFunctionContentsPart createContentsPart() {
        return new AccessorFunctionContentsPart();
    }

    @Override
    public IVariableDefinition.VariableClassification getVariableClassification() {
        IScopedNode scopedNode = this.getScopeNode();
        IScopedNode node = scopedNode;
        if (node instanceof ICommonClassNode || node.getParent() instanceof ICommonClassNode) {
            return IVariableDefinition.VariableClassification.CLASS_MEMBER;
        }
        if (node.getParent() instanceof IInterfaceNode) {
            return IVariableDefinition.VariableClassification.INTERFACE_MEMBER;
        }
        if (node.getParent() instanceof PackageNode) {
            return IVariableDefinition.VariableClassification.PACKAGE_MEMBER;
        }
        return IVariableDefinition.VariableClassification.LOCAL;
    }

    @Override
    public IExpressionNode getAssignedValueNode() {
        return null;
    }

    @Override
    public int getDeclarationEnd() {
        return this.getEnd();
    }

    @Override
    public IKeywordNode getAccessorKeywordNode() {
        return ((IAccessorFunctionContentsPart)this.contentsPart).getAccessorKeyword();
    }
}

