/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.targets;

import com.adobe.flash.compiler.internal.targets.ITargetAttributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class TargetAttributeBase
implements ITargetAttributes {
    private static final Pattern percentagePattern = Pattern.compile("\\s*((\\d+)(.(\\d)+)?)\\s*%\\s*");

    TargetAttributeBase() {
    }

    @Override
    public Float getWidth() {
        if (this.isPercentage("width")) {
            return null;
        }
        return this.parseFloat("width");
    }

    @Override
    public Float getHeight() {
        if (this.isPercentage("height")) {
            return null;
        }
        return this.parseFloat("height");
    }

    @Override
    public Double getWidthPercentage() {
        if (!this.isPercentage("width")) {
            return null;
        }
        return this.parsePercentage("width");
    }

    @Override
    public Double getHeightPercentage() {
        if (!this.isPercentage("height")) {
            return null;
        }
        return this.parsePercentage("height");
    }

    @Override
    public String getBackgroundColor() {
        return this.parseString("backgroundColor");
    }

    @Override
    public Float getFrameRate() {
        return this.parseFloat("frameRate");
    }

    @Override
    public String getPreloaderClassName() {
        return this.parseString("preloader");
    }

    @Override
    public String getRuntimeDPIProviderClassName() {
        return this.parseString("runtimeDPIProvider");
    }

    @Override
    public Integer getScriptRecursionLimit() {
        return this.parseInteger("scriptRecursionLimit");
    }

    @Override
    public Integer getScriptTimeLimit() {
        return this.parseInteger("scriptTimeLimit");
    }

    @Override
    public String getSplashScreenImage() {
        return this.parseString("splashScreenImage");
    }

    @Override
    public String getPageTitle() {
        return this.parseString("pageTitle");
    }

    @Override
    public Boolean getUseDirectBlit() {
        return this.parseBoolean("useDirectBlit");
    }

    @Override
    public Boolean getUseGPU() {
        return this.parseBoolean("useGPU");
    }

    @Override
    public Boolean getUsePreloader() {
        return this.parseBoolean("usePreloader");
    }

    final boolean isPercentageValue(String value) {
        assert (value != null) : "isPercentageValue called on a null value";
        return value.indexOf(37) >= 0;
    }

    final Double parsePercentageValue(String value) {
        assert (value != null) : "parsePercentageValue called on a null value";
        Matcher m = percentagePattern.matcher(value);
        if (m.matches()) {
            return Double.valueOf(m.group(1));
        }
        return null;
    }

    abstract Boolean parseBoolean(String var1);

    abstract Float parseFloat(String var1);

    abstract Integer parseInteger(String var1);

    abstract String parseString(String var1);

    abstract Double parsePercentage(String var1);

    abstract boolean isPercentage(String var1);
}

