/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.targets;

import com.adobe.flash.compiler.exceptions.CircularDependencyException;
import com.adobe.flash.compiler.internal.graph.Graph;
import com.adobe.flash.compiler.internal.graph.GraphEdge;
import com.adobe.flash.compiler.internal.graph.TopologicalSort;
import com.adobe.flash.swf.io.SWFReader;
import com.adobe.flash.swf.tags.ICharacterReferrer;
import com.adobe.flash.swf.tags.ICharacterTag;
import com.adobe.flash.swf.tags.ITag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TagSorter {
    private static void walkTags(Graph<ITag, GraphEdge<ITag>> tagGraph, ITag tag, Map<ITag, Integer> ordering) {
        if (tagGraph.addVertex(tag) && tag instanceof ICharacterReferrer) {
            for (ICharacterTag childTag : ((ICharacterReferrer)((Object)tag)).getReferences()) {
                if (childTag == SWFReader.INVALID_TAG) continue;
                TagSorter.walkTags(tagGraph, childTag, ordering);
                tagGraph.setEdge(new GraphEdge<ICharacterTag>((ICharacterTag)tag, childTag));
            }
        }
        if (!ordering.containsKey(tag)) {
            ordering.put(tag, ordering.keySet().size());
        }
    }

    public static List<ITag> sortFullGraph(List<ITag> rootedTags) {
        TagGraphVisitor visitor;
        block3: {
            Graph<ITag, GraphEdge<ITag>> tagGraph = new Graph<ITag, GraphEdge<ITag>>();
            HashMap<ITag, Integer> tagOrder = new HashMap<ITag, Integer>();
            for (ITag rootedTag : rootedTags) {
                TagSorter.walkTags(tagGraph, rootedTag, tagOrder);
            }
            ArrayList<ITag> orderedList = new ArrayList<ITag>();
            visitor = new TagGraphVisitor(orderedList, tagOrder);
            try {
                TopologicalSort.sort(tagGraph, rootedTags, visitor);
            }
            catch (CircularDependencyException e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"CircularDependencyException");
            }
        }
        return visitor.getOrderedList();
    }

    private static class TagGraphVisitor
    implements TopologicalSort.IVisitor<ITag, GraphEdge<ITag>> {
        private List<ITag> orderedList;
        private Map<ITag, Integer> tagOrdering;

        public TagGraphVisitor(List<ITag> orderedList, Map<ITag, Integer> tagOrdering) {
            this.orderedList = orderedList;
            this.tagOrdering = tagOrdering;
        }

        @Override
        public int compare(ITag tag1, ITag tag2) {
            return this.tagOrdering.get(tag1) - this.tagOrdering.get(tag2);
        }

        @Override
        public void visit(ITag v) {
            this.orderedList.add(v);
        }

        @Override
        public boolean isTopologicalEdge(GraphEdge<ITag> e) {
            return true;
        }

        public List<ITag> getOrderedList() {
            return this.orderedList;
        }
    }
}

