/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.targets;

import com.adobe.flash.compiler.common.DependencyType;
import com.adobe.flash.compiler.common.DependencyTypeSet;
import com.adobe.flash.compiler.common.ISourceLocation;
import com.adobe.flash.compiler.common.VersionInfo;
import com.adobe.flash.compiler.common.XMLName;
import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.metadata.IMetaTag;
import com.adobe.flash.compiler.definitions.references.IResolvedQualifiersReference;
import com.adobe.flash.compiler.definitions.references.ReferenceFactory;
import com.adobe.flash.compiler.exceptions.BuildCanceledException;
import com.adobe.flash.compiler.filespecs.IBinaryFileSpecification;
import com.adobe.flash.compiler.internal.config.QNameNormalization;
import com.adobe.flash.compiler.internal.filespecs.SWCFileSpecification;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.projects.DependencyGraph;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.projects.LibraryPathManager;
import com.adobe.flash.compiler.internal.projects.SourcePathManager;
import com.adobe.flash.compiler.internal.targets.FlexLibrarySWFTarget;
import com.adobe.flash.compiler.internal.targets.ILibrarySWFTarget;
import com.adobe.flash.compiler.internal.targets.LibrarySWFTarget;
import com.adobe.flash.compiler.internal.targets.LinkageChecker;
import com.adobe.flash.compiler.internal.targets.Target;
import com.adobe.flash.compiler.internal.units.ResourceBundleCompilationUnit;
import com.adobe.flash.compiler.problems.DuplicateScriptProblem;
import com.adobe.flash.compiler.problems.FileNotFoundProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.NoCompilationUnitForDefinitionProblem;
import com.adobe.flash.compiler.problems.NoSourceForClassInNamespaceProblem;
import com.adobe.flash.compiler.problems.NoSourceForClassProblem;
import com.adobe.flash.compiler.targets.ISWCTarget;
import com.adobe.flash.compiler.targets.ISWFTarget;
import com.adobe.flash.compiler.targets.ITarget;
import com.adobe.flash.compiler.targets.ITargetProgressMonitor;
import com.adobe.flash.compiler.targets.ITargetReport;
import com.adobe.flash.compiler.targets.ITargetSettings;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.units.requests.IFileScopeRequestResult;
import com.adobe.flash.swc.ISWC;
import com.adobe.flash.swc.ISWCFileEntry;
import com.adobe.flash.swc.ISWCManager;
import com.adobe.flash.swc.ISWCVersion;
import com.adobe.flash.swc.SWC;
import com.adobe.flash.swc.SWCComponent;
import com.adobe.flash.swc.SWCLibrary;
import com.adobe.flash.swc.SWCScript;
import com.adobe.flash.swf.ISWF;
import com.adobe.flash.utils.DAByteArrayOutputStream;
import com.adobe.flash.utils.FileID;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class SWCTarget
extends Target
implements ISWCTarget {
    private static final String LIBRARY_SWF = "library.swf";
    private final SWC swc;
    private final FlexProject flexProject;
    private ILibrarySWFTarget librarySWFTarget;
    private Target.RootedCompilationUnits rootedCompilationUnits;

    public SWCTarget(FlexProject project, ITargetSettings targetSettings, ITargetProgressMonitor progressMonitor) {
        super(project, targetSettings, progressMonitor);
        this.swc = new SWC(targetSettings.getOutput());
        this.flexProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISWC build(Collection<ICompilerProblem> problems) {
        this.buildStarted();
        try {
            Iterable<ICompilerProblem> fatalProblems = this.getFatalProblems();
            if (!Iterables.isEmpty(fatalProblems)) {
                Iterables.addAll(problems, fatalProblems);
                ISWC iSWC = null;
                return iSWC;
            }
            this.setVersionInfo();
            HashSet<IDefinition> definitions = new HashSet<IDefinition>();
            this.buildLibrarySWF(definitions, problems);
            this.addComponents(definitions);
            this.addFileEntriesToSWC(problems);
            SWC sWC = this.swc;
            return sWC;
        }
        catch (BuildCanceledException bce) {
            ISWC iSWC = null;
            return iSWC;
        }
        catch (InterruptedException ie) {
            ISWC iSWC = null;
            return iSWC;
        }
        finally {
            this.buildFinished();
        }
    }

    private void setVersionInfo() {
        ISWCVersion swcVersion = this.swc.getVersion();
        swcVersion.setSWCVersion(VersionInfo.getLibVersion());
        if (this.flexProject.isFlex()) {
            swcVersion.setFlexVersion(VersionInfo.getFlexVersion());
            swcVersion.setFlexBuild(VersionInfo.getBuild());
            swcVersion.setFlexMinSupportedVersion(this.targetSettings.getFlexMinimumSupportedVersion());
        }
        swcVersion.setCompilerName(VersionInfo.getCompilerName());
        swcVersion.setCompilerVersion(VersionInfo.getCompilerVersion());
        swcVersion.setCompilerBuild(VersionInfo.getCompilerBuild());
    }

    @Override
    public ISWFTarget getLibrarySWFTarget() throws InterruptedException {
        if (this.librarySWFTarget == null) {
            Target.RootedCompilationUnits rootedCompilationUnits = this.getRootedCompilationUnits();
            this.librarySWFTarget = this.flexProject.isFlex() ? new FlexLibrarySWFTarget(this.flexProject, this.targetSettings, rootedCompilationUnits.getUnits()) : new LibrarySWFTarget((CompilerProject)this.flexProject, this.targetSettings, rootedCompilationUnits.getUnits());
        }
        assert (this.librarySWFTarget != null);
        return this.librarySWFTarget;
    }

    @Override
    public ITarget.TargetType getTargetType() {
        return ITarget.TargetType.SWC;
    }

    private void addComponents(HashSet<IDefinition> definitions) {
        ImmutableSet includedNamespaces = ImmutableSet.copyOf(this.targetSettings.getIncludeNamespaces());
        for (IDefinition def : definitions) {
            String qName = def.getQualifiedName();
            Collection<XMLName> tagNames = this.flexProject.getTagNamesForClass(qName);
            for (XMLName tagName : tagNames) {
                if (!this.includeComponent(tagName, (Set<String>)includedNamespaces)) continue;
                SWCComponent component = new SWCComponent();
                component.setName(tagName.getName());
                component.setURI(tagName.getXMLNamespace());
                component.setQName(qName);
                this.swc.addComponent(component);
            }
        }
    }

    private boolean includeComponent(XMLName tagName, Set<String> includedNamespaces) {
        if (includedNamespaces.contains(tagName.getXMLNamespace())) {
            return !this.flexProject.isManifestComponentLookupOnly(tagName) || this.targetSettings.isIncludeLookupOnlyEnabled();
        }
        return false;
    }

    private void addFileEntriesToSWC(Collection<ICompilerProblem> problems) {
        Map<String, FileEntryValue> fileEntries = this.computeIncludedFiles();
        for (Map.Entry<String, FileEntryValue> entry : fileEntries.entrySet()) {
            this.processFileEntry(entry, problems);
        }
        Map<String, ISWCFileEntry> includeLibraryFiles = this.getIncludedLibrariesFiles();
        for (ISWCFileEntry fileEntry : includeLibraryFiles.values()) {
            this.swc.addFile(fileEntry);
        }
        Map<String, FileEntryValue> iconFilesMap = this.computeIconFiles();
        for (Map.Entry<String, FileEntryValue> entry : iconFilesMap.entrySet()) {
            this.processFileEntry(entry, problems);
        }
    }

    private void processFileEntry(Map.Entry<String, FileEntryValue> entry, Collection<ICompilerProblem> problems) {
        String path = entry.getKey();
        IBinaryFileSpecification fileSpec = entry.getValue().getFileSpec();
        ISourceLocation sourceLocation = entry.getValue().getSourceLocation();
        byte[] contents = this.getContents(fileSpec);
        if (contents != null) {
            this.swc.addFile(path, fileSpec.getLastModified(), contents);
        } else {
            FileNotFoundProblem problem = sourceLocation != null ? new FileNotFoundProblem(sourceLocation, fileSpec.getPath()) : new FileNotFoundProblem(fileSpec.getPath());
            problems.add(problem);
        }
    }

    private byte[] getContents(IBinaryFileSpecification fileSpec) {
        byte[] contents = null;
        try {
            DAByteArrayOutputStream buffer = new DAByteArrayOutputStream();
            InputStream fileInputStream = fileSpec.createInputStream();
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)buffer);
            IOUtils.closeQuietly((OutputStream)buffer);
            IOUtils.closeQuietly((InputStream)fileInputStream);
            contents = buffer.getDirectByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return contents;
    }

    private ISWF buildLibrarySWF(Collection<IDefinition> definitionsToBuild, Collection<ICompilerProblem> problems) throws InterruptedException {
        this.getLibrarySWFTarget();
        Iterables.addAll(problems, this.getRootedCompilationUnits().getProblems());
        LinkageChecker externalLinkageChecker = new LinkageChecker(this.flexProject, this.targetSettings);
        ((Target)((Object)this.librarySWFTarget)).setLinkageChecker(externalLinkageChecker);
        this.setLinkageChecker(externalLinkageChecker);
        ISWF defaultLibrarySWF = this.librarySWFTarget.build(problems);
        SWCLibrary defaultLibrary = new SWCLibrary(LIBRARY_SWF, defaultLibrarySWF);
        this.swc.addLibrary(defaultLibrary);
        HashSet<ICompilationUnit> cuToWrite = new HashSet<ICompilationUnit>();
        for (ICompilationUnit cu : this.librarySWFTarget.getCompilationUnits()) {
            if (this.isLinkageExternal(cu, this.targetSettings)) continue;
            if (cu instanceof ResourceBundleCompilationUnit) {
                assert (this.project instanceof FlexProject);
                this.processResourceBundle((FlexProject)this.project, (ResourceBundleCompilationUnit)cu, this.swc, problems);
                continue;
            }
            cuToWrite.add(cu);
        }
        this.filterCompilationUnits(cuToWrite, problems);
        for (ICompilationUnit cu : cuToWrite) {
            defaultLibrary.addScript(this.createScript(cu, definitionsToBuild));
        }
        if (this.librarySWFTarget.getRootClassName() != null) {
            SWCScript script = new SWCScript();
            script.setName(this.librarySWFTarget.getRootClassName());
            script.addDefinition(this.librarySWFTarget.getRootClassName());
            script.setLastModified(1L);
            script.addDependency(this.librarySWFTarget.getBaseClassQName(), DependencyType.INHERITANCE);
            defaultLibrary.addScript(script);
        }
        if (this.librarySWFTarget.getASMetadataNames() != null) {
            for (String name : this.librarySWFTarget.getASMetadataNames()) {
                defaultLibrary.addNameToKeepAS3MetadataSet(name);
            }
        }
        return defaultLibrarySWF;
    }

    private void filterCompilationUnits(Set<ICompilationUnit> cuToWrite, Collection<ICompilerProblem> problems) throws InterruptedException {
        HashMap<String, TreeSet<ICompilationUnit>> cuMap = new HashMap<String, TreeSet<ICompilationUnit>>();
        Comparator<ICompilationUnit> comparator = new Comparator<ICompilationUnit>(){

            @Override
            public int compare(ICompilationUnit arg0, ICompilationUnit arg1) {
                return -arg0.getName().compareTo(arg1.getName());
            }
        };
        for (ICompilationUnit cu : cuToWrite) {
            String name = cu.getSWFTagsRequest().get().getDoABCTagName();
            TreeSet<ICompilationUnit> l = (TreeSet<ICompilationUnit>)cuMap.get(name);
            if (l == null) {
                l = new TreeSet<ICompilationUnit>(comparator);
                cuMap.put(name, l);
            }
            l.add(cu);
        }
        for (Set cus : cuMap.values()) {
            assert (!cus.isEmpty());
            Iterator it = cus.iterator();
            ICompilationUnit cuKept = (ICompilationUnit)it.next();
            ICompilationUnit cuDumped = null;
            boolean somoneHasVisibleDefinitions = this.hasExternallyVisibleDefinitions(cuKept);
            while (it.hasNext()) {
                cuDumped = (ICompilationUnit)it.next();
                cuToWrite.remove(cuDumped);
                somoneHasVisibleDefinitions |= this.hasExternallyVisibleDefinitions(cuDumped);
            }
            if (cuDumped == null || !somoneHasVisibleDefinitions) continue;
            problems.add(new DuplicateScriptProblem(cuKept.getAbsoluteFilename(), cuDumped.getAbsoluteFilename()));
        }
    }

    private boolean hasExternallyVisibleDefinitions(ICompilationUnit cu) throws InterruptedException {
        IFileScopeRequestResult r = cu.getFileScopeRequest().get();
        Collection<IDefinition> vis = r.getExternallyVisibleDefinitions();
        return !vis.isEmpty();
    }

    private SWCScript createScript(ICompilationUnit cu, Collection<IDefinition> definitionsToBuild) throws InterruptedException {
        SWCScript script = new SWCScript();
        script.setName(cu.getSWFTagsRequest().get().getDoABCTagName());
        IFileScopeRequestResult fsResult = cu.getFileScopeRequest().get();
        for (IDefinition def : fsResult.getExternallyVisibleDefinitions()) {
            script.addDefinition(def.getQualifiedName());
            script.setLastModified(cu.getSyntaxTreeRequest().get().getLastModified());
            if (definitionsToBuild == null) continue;
            definitionsToBuild.add(def);
        }
        DependencyGraph dependencyGraph = this.flexProject.getDependencyGraph();
        Set<ICompilationUnit> directDependencies = dependencyGraph.getDirectDependencies(cu);
        for (ICompilationUnit directDependency : directDependencies) {
            Map<String, DependencyTypeSet> dependenciesMap = dependencyGraph.getDependencySet(cu, directDependency);
            for (Map.Entry<String, DependencyTypeSet> dependencyEntry : dependenciesMap.entrySet()) {
                for (DependencyType type : dependencyEntry.getValue()) {
                    script.addDependency(dependencyEntry.getKey(), type);
                }
            }
        }
        return script;
    }

    private void processResourceBundle(FlexProject project, ResourceBundleCompilationUnit cu, SWC swc, Collection<ICompilerProblem> problems) {
        Collection<String> locales = null;
        locales = cu.getLocale() == null ? project.getLocales() : Collections.singletonList(cu.getLocale());
        byte[] fileContent = cu.getFileContent(problems);
        if (fileContent == null) {
            return;
        }
        for (String locale : locales) {
            StringBuilder sb = new StringBuilder();
            sb.append("locale");
            sb.append(File.separator);
            sb.append(locale);
            sb.append(File.separator);
            sb.append(QNameNormalization.normalize(cu.getBundleNameInColonSyntax()).replace('.', File.separatorChar));
            sb.append(FilenameUtils.EXTENSION_SEPARATOR_STR);
            sb.append("properties");
            swc.addFile(sb.toString(), cu.getFileLastModified(), fileContent);
        }
    }

    @Override
    public boolean addToZipOutputStream(ZipOutputStream output, Collection<ICompilerProblem> problemCollection) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Target.RootedCompilationUnits computeRootedCompilationUnits() throws InterruptedException {
        HashSet<ICompilationUnit> rootCompilationUnits = new HashSet<ICompilationUnit>();
        Collection<File> includedSourceFiles = this.targetSettings.getIncludeSources();
        ImmutableSet includeClassNameSet = ImmutableSet.copyOf(this.targetSettings.getIncludeClasses());
        ImmutableSet includedNamespaces = ImmutableSet.copyOf(this.targetSettings.getIncludeNamespaces());
        ArrayList<ICompilerProblem> problems = new ArrayList<ICompilerProblem>();
        Collection<ICompilationUnit> includeNamespaceUnits = this.getCompilationUnitsForIncludedNamespaces((Collection<String>)includedNamespaces, problems);
        rootCompilationUnits.addAll(includeNamespaceUnits);
        rootCompilationUnits.addAll(this.getCompilationUnitsFromClassNames(null, (Collection<String>)includeClassNameSet, problems));
        for (File includedSourceFileName : includedSourceFiles) {
            Collection<ICompilationUnit> compilationUnitsForFile = this.project.getWorkspace().getCompilationUnits(includedSourceFileName.getAbsolutePath(), this.project);
            if (compilationUnitsForFile.size() > 1) {
                compilationUnitsForFile = this.filterUnitsBasedOnSourcePath(compilationUnitsForFile);
            }
            for (ICompilationUnit cu : compilationUnitsForFile) {
                if (!cu.getAbsoluteFilename().equals(includedSourceFileName.getAbsolutePath())) continue;
                rootCompilationUnits.add(cu);
            }
        }
        for (ICompilationUnit rbCompUnit : this.getIncludedResourceBundlesCompilationUnits(problems)) {
            rootCompilationUnits.add(rbCompUnit);
        }
        rootCompilationUnits.addAll(this.getIncludesCompilationUnits());
        rootCompilationUnits.addAll(this.getIncludeLibrariesCompilationUnits());
        return new Target.RootedCompilationUnits(rootCompilationUnits, problems);
    }

    @Override
    public Target.RootedCompilationUnits getRootedCompilationUnits() throws InterruptedException {
        if (this.rootedCompilationUnits == null) {
            this.rootedCompilationUnits = this.computeRootedCompilationUnits();
        }
        assert (this.rootedCompilationUnits != null);
        return this.rootedCompilationUnits;
    }

    private Collection<ICompilationUnit> filterUnitsBasedOnSourcePath(Collection<ICompilationUnit> compilationUnitsForFile) throws InterruptedException {
        ArrayList<ICompilationUnit> sourcePathUnits = new ArrayList<ICompilationUnit>(compilationUnitsForFile);
        boolean foundHighestPriorityUnit = false;
        block0: for (File sourcePath : this.flexProject.getSourcePath()) {
            for (ICompilationUnit unit : sourcePathUnits) {
                String computedQname;
                String unitQname;
                List<String> qnames;
                ICompilationUnit.UnitType unitType = unit.getCompilationUnitType();
                if (unitType != ICompilationUnit.UnitType.AS_UNIT && unitType != ICompilationUnit.UnitType.FXG_UNIT && unitType != ICompilationUnit.UnitType.MXML_UNIT && unitType != ICompilationUnit.UnitType.CSS_UNIT || (qnames = unit.getQualifiedNames()).size() > 1 || !(unitQname = qnames.isEmpty() ? "" : (String)qnames.iterator().next()).equals(computedQname = SourcePathManager.computeQName(sourcePath, new File(unit.getAbsoluteFilename())))) continue;
                if (foundHighestPriorityUnit) {
                    compilationUnitsForFile.remove(unit);
                }
                foundHighestPriorityUnit = true;
                continue block0;
            }
        }
        return compilationUnitsForFile;
    }

    private Collection<ICompilationUnit> getCompilationUnitsForIncludedNamespaces(Collection<String> namespaces, Collection<ICompilerProblem> problems) throws InterruptedException {
        HashSet<ICompilationUnit> allUnits = new HashSet<ICompilationUnit>();
        for (String namespace : namespaces) {
            Collection<String> includeNamespaceQualifiedNames = this.flexProject.getQualifiedClassNamesForManifestNamespaces(Collections.singleton(namespace));
            Collection<ICompilationUnit> units = this.getCompilationUnitsFromClassNames(namespace, includeNamespaceQualifiedNames, problems);
            this.validateIncludeNamespaceEntries(namespace, units, problems);
            allUnits.addAll(units);
        }
        return allUnits;
    }

    private void validateIncludeNamespaceEntries(String namespace, Collection<ICompilationUnit> units, Collection<ICompilerProblem> problems) throws InterruptedException {
        block0: for (ICompilationUnit unit : units) {
            List<String> classNames = unit.getQualifiedNames();
            String className = classNames.get(classNames.size() - 1);
            Collection<XMLName> xmlNames = this.flexProject.getTagNamesForClass(className);
            for (XMLName xmlName : xmlNames) {
                if (!namespace.equals(xmlName.getXMLNamespace())) continue;
                if (this.flexProject.isManifestComponentLookupOnly(xmlName) || unit.getCompilationUnitType() != ICompilationUnit.UnitType.SWC_UNIT) continue block0;
                problems.add(new NoSourceForClassInNamespaceProblem(namespace, className));
                continue block0;
            }
        }
    }

    private Collection<ICompilationUnit> getCompilationUnitsFromClassNames(String namespace, Collection<String> classNames, Collection<ICompilerProblem> problems) {
        Iterable references = Iterables.transform(classNames, (Function)new Function<String, IResolvedQualifiersReference>(){

            public IResolvedQualifiersReference apply(String qualifiedName) {
                return ReferenceFactory.packageQualifiedReference(SWCTarget.this.project.getWorkspace(), qualifiedName, true);
            }
        });
        LinkedList<ICompilationUnit> units = new LinkedList<ICompilationUnit>();
        for (IResolvedQualifiersReference reference : references) {
            IDefinition def = reference.resolve(this.flexProject);
            if (def == null) {
                if (namespace == null) {
                    problems.add(new NoSourceForClassProblem(reference.getDisplayString()));
                    continue;
                }
                problems.add(new NoSourceForClassInNamespaceProblem(namespace, reference.getDisplayString()));
                continue;
            }
            ICompilationUnit defCU = this.project.getScope().getCompilationUnitForDefinition(def);
            if (defCU == null) {
                problems.add(new NoCompilationUnitForDefinitionProblem(def.getBaseName()));
                continue;
            }
            units.add(defCU);
        }
        return units;
    }

    private Map<String, FileEntryValue> computeIncludedFiles() {
        HashMap<String, FileEntryValue> includedFiles = new HashMap<String, FileEntryValue>();
        for (Map.Entry<String, File> entry : this.targetSettings.getIncludeFiles().entrySet()) {
            String filename = entry.getKey();
            String path = entry.getValue().getAbsolutePath();
            IBinaryFileSpecification fileSpec = this.project.getWorkspace().getLatestBinaryFileSpecification(path);
            if (filename == null || fileSpec == null) continue;
            FileEntryValue value = new FileEntryValue(fileSpec, null);
            includedFiles.put(filename, value);
        }
        return includedFiles;
    }

    private Map<String, ISWCFileEntry> getIncludedLibrariesFiles() {
        HashMap<String, ISWCFileEntry> files = new HashMap<String, ISWCFileEntry>();
        Set<FileID> swcs = LibraryPathManager.discoverSWCFilePaths(this.targetSettings.getIncludeLibraries().toArray(new File[0]));
        ISWCManager swcManager = this.project.getWorkspace().getSWCManager();
        for (FileID swcPath : swcs) {
            ISWC swc = swcManager.get(swcPath.getFile());
            Map<String, ISWCFileEntry> swcFiles = swc.getFiles();
            for (Map.Entry<String, ISWCFileEntry> file : swcFiles.entrySet()) {
                ISWCFileEntry currentFileEntry = (ISWCFileEntry)files.get(file.getKey());
                if (currentFileEntry != null && file.getValue().getLastModified() <= currentFileEntry.getLastModified()) continue;
                files.put(file.getKey(), file.getValue());
            }
        }
        return files;
    }

    private Map<String, FileEntryValue> computeIconFiles() {
        HashMap<String, FileEntryValue> iconFiles = new HashMap<String, FileEntryValue>();
        try {
            ImmutableSet<ICompilationUnit> compilationUnits = this.librarySWFTarget.getCompilationUnits();
            for (IDefinition definition : SWCTarget.getAllExternallyVisibleDefinitions(compilationUnits)) {
                if (!(definition instanceof IClassDefinition)) continue;
                IClassDefinition classDefinition = (IClassDefinition)definition;
                IMetaTag iconFileMetaTag = classDefinition.getMetaTagByName("IconFile");
                String iconFilePath = classDefinition.getIconFile();
                if (iconFilePath == null) continue;
                String packageName = classDefinition.getPackageName();
                String key = packageName.replaceAll("\\.", "/") + "/" + iconFilePath;
                ICompilationUnit cu = this.project.getScope().getCompilationUnitForDefinition(classDefinition);
                IBinaryFileSpecification fileSpec = null;
                if (cu.getCompilationUnitType() == ICompilationUnit.UnitType.SWC_UNIT) {
                    ISWC swc = this.project.getWorkspace().getSWCManager().get(new File(cu.getAbsoluteFilename()));
                    ISWCFileEntry swcFileEntry = swc.getFile(key);
                    fileSpec = new SWCFileSpecification(key, swcFileEntry);
                } else {
                    String sourcePath = classDefinition.getSourcePath();
                    iconFilePath = FilenameUtils.getFullPath((String)sourcePath) + iconFilePath;
                    fileSpec = this.project.getWorkspace().getLatestBinaryFileSpecification(iconFilePath);
                }
                FileEntryValue value = new FileEntryValue(fileSpec, iconFileMetaTag);
                iconFiles.put(key, value);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return iconFiles;
    }

    @Override
    protected ITargetReport computeTargetReport() throws InterruptedException {
        assert (this.librarySWFTarget != null) : "Must call build before getting the target report!!";
        return this.librarySWFTarget.getTargetReport();
    }

    private static class FileEntryValue {
        private IBinaryFileSpecification fileSpec;
        private ISourceLocation sourceLocation;

        FileEntryValue(IBinaryFileSpecification fileSpec, ISourceLocation sourceLocation) {
            this.fileSpec = fileSpec;
            this.sourceLocation = sourceLocation;
        }

        IBinaryFileSpecification getFileSpec() {
            return this.fileSpec;
        }

        ISourceLocation getSourceLocation() {
            return this.sourceLocation;
        }
    }
}

