/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.targets;

import com.adobe.flash.compiler.config.RSLSettings;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.targets.ITargetSettings;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.workspaces.IWorkspace;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LinkageChecker {
    private ICompilerProject project;
    private ITargetSettings targetSettings;
    private Set<String> externs;

    public LinkageChecker(ICompilerProject project, ITargetSettings targetSettings) {
        this.project = project;
        this.targetSettings = targetSettings;
    }

    public boolean isExternal(ICompilationUnit cu) throws InterruptedException {
        List<String> qnames;
        if (this.externs == null) {
            this.initExterns();
        }
        return !(qnames = cu.getQualifiedNames()).isEmpty() && this.externs.contains(qnames.get(0));
    }

    private void initExterns() throws InterruptedException {
        this.externs = new HashSet<String>(4096);
        this.externs.addAll(this.targetSettings.getExterns());
        IWorkspace w = this.project.getWorkspace();
        ArrayList<File> libraries = new ArrayList<File>(this.targetSettings.getExternalLibraryPath().size() + this.targetSettings.getRuntimeSharedLibraryPath().size());
        libraries.addAll(this.targetSettings.getExternalLibraryPath());
        for (RSLSettings settings : this.targetSettings.getRuntimeSharedLibraryPath()) {
            libraries.add(settings.getLibraryFile());
        }
        for (File library : libraries) {
            Collection<ICompilationUnit> units = null;
            units = w.getCompilationUnits(library.getAbsolutePath(), this.project);
            for (ICompilationUnit unit : units) {
                ICompilationUnit.UnitType type = unit.getCompilationUnitType();
                if (type == ICompilationUnit.UnitType.EMBED_UNIT) continue;
                this.externs.addAll(unit.getQualifiedNames());
            }
        }
        this.externs.removeAll(this.targetSettings.getIncludeClasses());
    }
}

