/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.targets;

import com.adobe.flash.abc.ABCLinker;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.targets.ILibrarySWFTarget;
import com.adobe.flash.compiler.internal.targets.ITargetAttributes;
import com.adobe.flash.compiler.internal.targets.NilTargetAttributes;
import com.adobe.flash.compiler.internal.targets.SWFTarget;
import com.adobe.flash.compiler.internal.units.ResourceBundleCompilationUnit;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.targets.ITargetSettings;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.swf.SWFFrame;
import com.adobe.flash.swf.tags.DoABCTag;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

public class LibrarySWFTarget
extends SWFTarget
implements ILibrarySWFTarget {
    protected final Set<ICompilationUnit> rootedCompilationUnits;
    private ImmutableSet<ICompilationUnit> compilationUnits;

    public LibrarySWFTarget(CompilerProject project, ITargetSettings targetSettings, Set<ICompilationUnit> rootedCompilationUnits) {
        super(project, targetSettings, null);
        this.rootedCompilationUnits = rootedCompilationUnits;
    }

    @Override
    protected ITargetAttributes computeTargetAttributes() throws InterruptedException {
        return NilTargetAttributes.INSTANCE;
    }

    @Override
    protected SWFTarget.FramesInformation computeFramesInformation() throws InterruptedException {
        SWFTarget.SWFFrameInfo frame = new SWFTarget.SWFFrameInfo(this.rootedCompilationUnits, Collections.<ICompilerProblem>emptyList());
        return new SWFTarget.FramesInformation(Collections.singletonList(frame));
    }

    @Override
    public ImmutableSet<ICompilationUnit> getCompilationUnits() {
        return this.compilationUnits != null ? this.compilationUnits : ImmutableSet.of();
    }

    @Override
    public String getRootClassName() {
        return null;
    }

    @Override
    public String getBaseClassQName() {
        return null;
    }

    @Override
    protected boolean testCompilationUnitLinkage(ICompilationUnit cu, boolean allowExternals) throws InterruptedException {
        return super.testCompilationUnitLinkage(cu, allowExternals) && !(cu instanceof ResourceBundleCompilationUnit);
    }

    @Override
    protected void doPostBuildWork(ImmutableSet<ICompilationUnit> compilationUnits, Collection<ICompilerProblem> problems) throws InterruptedException {
        this.compilationUnits = compilationUnits;
    }

    @Override
    protected boolean shouldAddMetadataNamesToTarget(ICompilationUnit cu, boolean linkage) {
        return linkage && super.shouldAddMetadataNamesToTarget(cu, linkage);
    }

    @Override
    protected final void addLinkedABCToFrame(SWFFrame targetFrame, Iterable<DoABCTag> inputABCs, ABCLinker.ABCLinkerSettings linkSettings) throws Exception {
        for (DoABCTag inputABC : inputABCs) {
            byte[] linkedBytes = ABCLinker.linkABC(Collections.singleton(inputABC.getABCData()), 46, 16, linkSettings);
            DoABCTag linkedTag = new DoABCTag(1L, inputABC.getName(), linkedBytes);
            targetFrame.addTag(linkedTag);
        }
    }

    @Override
    protected void setKeepAS3MetadataLinkerSetting(ABCLinker.ABCLinkerSettings linkSettings) {
        linkSettings.setKeepMetadata(null);
    }
}

