/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.targets;

import com.adobe.flash.abc.instructionlist.InstructionList;
import com.adobe.flash.abc.semantics.Label;
import com.adobe.flash.abc.semantics.Name;
import com.adobe.flash.abc.visitors.ITraitVisitor;
import com.adobe.flash.abc.visitors.ITraitsVisitor;
import com.adobe.flash.compiler.common.VersionInfo;
import com.adobe.flash.compiler.config.RSLSettings;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.INamespaceDefinition;
import com.adobe.flash.compiler.definitions.metadata.IMetaTag;
import com.adobe.flash.compiler.definitions.references.IResolvedQualifiersReference;
import com.adobe.flash.compiler.definitions.references.ReferenceFactory;
import com.adobe.flash.compiler.internal.abc.ClassGeneratorHelper;
import com.adobe.flash.compiler.internal.as.codegen.LexicalScope;
import com.adobe.flash.compiler.internal.config.FrameInfo;
import com.adobe.flash.compiler.internal.definitions.NamespaceDefinition;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.targets.FlexFontInfo;
import com.adobe.flash.compiler.internal.targets.FlexFrame1Info;
import com.adobe.flash.compiler.internal.targets.FlexRSLInfo;
import com.adobe.flash.compiler.internal.targets.FlexSplashScreenImage;
import com.adobe.flash.compiler.internal.targets.ITargetAttributes;
import com.adobe.flash.compiler.internal.targets.Target;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.problems.InvalidBackgroundColorProblem;
import com.adobe.flash.compiler.problems.MissingSignedDigestProblem;
import com.adobe.flash.compiler.problems.MissingUnsignedDigestProblem;
import com.adobe.flash.compiler.targets.ITargetSettings;
import com.adobe.flash.compiler.tree.as.IASNode;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.units.requests.IFileScopeRequestResult;
import com.adobe.flash.swc.ISWC;
import com.adobe.flash.swc.ISWCDigest;
import com.adobe.flash.swc.ISWCLibrary;
import com.adobe.flash.swc.ISWCManager;
import com.adobe.flash.swf.ISWF;
import com.adobe.flash.swf.tags.ProductInfoTag;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class FlexTarget {
    protected final FlexProject flexProject;
    private final ITargetSettings targetSettings;
    protected final HashSet<String> accessibleClassNames;
    static final Target.DirectDependencies NO_DEPENDENCIES = new Target.DirectDependencies(Collections.<ICompilationUnit>emptyList(), Collections.<ICompilerProblem>emptyList());

    FlexTarget(ITargetSettings targetSettings, FlexProject project) {
        this.flexProject = project;
        this.targetSettings = targetSettings;
        this.accessibleClassNames = new HashSet();
    }

    protected final void codegenCallInContextMethod(ClassGeneratorHelper classGen, boolean isOverride) {
        IResolvedQualifiersReference applyReference = ReferenceFactory.resolvedQualifierQualifiedReference(this.flexProject.getWorkspace(), NamespaceDefinition.getAS3NamespaceDefinition(), "apply");
        InstructionList callInContext = new InstructionList();
        callInContext.addInstruction(209);
        callInContext.addInstruction(210);
        callInContext.addInstruction(211);
        callInContext.addInstruction(70, new Object[]{applyReference.getMName(), 2});
        callInContext.addInstruction(98, 4);
        Label callInContextReturnVoid = new Label();
        callInContext.addInstruction(18, callInContextReturnVoid);
        callInContext.addInstruction(72);
        callInContext.labelNext(callInContextReturnVoid);
        callInContext.addInstruction(72);
        ImmutableList callInContextParams = new ImmutableList.Builder().add((Object)new Name("Function")).add((Object)new Name("Object")).add((Object)new Name("Array")).add((Object)new Name("Boolean")).build();
        classGen.addITraitsMethod(new Name("callInContext"), (Collection<Name>)callInContextParams, null, Collections.singletonList(Boolean.TRUE), false, true, isOverride, callInContext);
    }

    protected final void codegenCreateMethod(ClassGeneratorHelper classGen, Name mainApplicationName) {
        IResolvedQualifiersReference applyReference = ReferenceFactory.resolvedQualifierQualifiedReference(this.flexProject.getWorkspace(), NamespaceDefinition.getAS3NamespaceDefinition(), "apply");
        IResolvedQualifiersReference getDefinitionByNameReference = ReferenceFactory.packageQualifiedReference(this.flexProject.getWorkspace(), "flash.utils.getDefinitionByName");
        IResolvedQualifiersReference iFlexModule = ReferenceFactory.packageQualifiedReference(this.flexProject.getWorkspace(), "mx.core.IFlexModule");
        Name getDefinitionByName = getDefinitionByNameReference.getMName();
        InstructionList create = new InstructionList();
        create.addInstruction(209);
        create.addInstruction(102, new Name("length"));
        create.addInstruction(36, 0);
        Label createL1 = new Label();
        create.addInstruction(23, createL1);
        create.addInstruction(94, mainApplicationName);
        create.addInstruction(102, mainApplicationName);
        Label createL3 = new Label();
        create.addInstruction(16, createL3);
        create.labelNext(createL1);
        create.addInstruction(209);
        create.addInstruction(102, new Name("0"));
        create.addInstruction(178, new Name("String"));
        Label createL2 = new Label();
        create.addInstruction(18, createL2);
        create.addInstruction(95, getDefinitionByName);
        create.addInstruction(209);
        create.addInstruction(102, new Name("0"));
        create.addInstruction(70, new Object[]{getDefinitionByName, 1});
        create.addInstruction(16, createL3);
        create.labelNext(createL2);
        create.addInstruction(208);
        create.addInstruction(4, new Name("create"));
        create.addInstruction(208);
        create.addInstruction(209);
        create.addInstruction(70, new Object[]{applyReference.getMName(), 2});
        create.addInstruction(72);
        create.labelNext(createL3);
        create.addInstruction(134, new Name("Class"));
        create.addInstruction(42);
        Label createL5 = new Label();
        create.addInstruction(18, createL5);
        create.addInstruction(66, 0);
        create.addInstruction(42);
        create.addInstruction(178, iFlexModule.getMName());
        Label createL4 = new Label();
        create.addInstruction(18, createL4);
        create.addInstruction(42);
        create.addInstruction(208);
        create.addInstruction(97, new Name("moduleFactory"));
        create.labelNext(createL4);
        create.addInstruction(72);
        create.labelNext(createL5);
        create.addInstruction(72);
        classGen.addITraitsMethod(new Name("create"), Collections.<Name>emptyList(), new Name("Object"), Collections.<Object>emptyList(), true, true, true, create);
    }

    protected final void codegenInfoMethod(ClassGeneratorHelper classGen, Integer compatibilityVersion, String mainClassQName, IResolvedQualifiersReference preloaderReference, IResolvedQualifiersReference runtimeDPIProviderReference, FlexSplashScreenImage splashScreen, IASNode rootNode, ITargetAttributes targetAttributes, Collection<String> compiledLocales, FlexFrame1Info frame1Info, Set<String> accessibilityClassNames, String flexInitClassName, String stylesClassName, List<String> rsls, FlexRSLInfo rslInfo, Collection<ICompilerProblem> problemCollection) throws InterruptedException {
        IResolvedQualifiersReference applicationDomainRef = ReferenceFactory.packageQualifiedReference(this.flexProject.getWorkspace(), "flash.system.ApplicationDomain");
        INamespaceDefinition.IPrivateNamespaceDefinition privateNSDef = NamespaceDefinition.createPrivateNamespaceDefinition("");
        IResolvedQualifiersReference infoSlotReference = ReferenceFactory.resolvedQualifierQualifiedReference(this.flexProject.getWorkspace(), privateNSDef, "info");
        Name infoSlotName = infoSlotReference.getMName();
        InstructionList info = new InstructionList();
        info.addInstruction(208);
        info.addInstruction(102, infoSlotName);
        info.addInstruction(42);
        Label infoL1 = new Label();
        info.addInstruction(17, infoL1);
        int infoEntries = 0;
        info.addInstruction(41);
        info.addInstruction(44, "currentDomain");
        info.addInstruction(96, applicationDomainRef.getMName());
        info.addInstruction(102, new Name("currentDomain"));
        ++infoEntries;
        if (this.targetSettings.getFrameLabels() != null && !this.targetSettings.getFrameLabels().isEmpty()) {
            List<FrameInfo> frames = this.targetSettings.getFrameLabels();
            info.addInstruction(44, "frames");
            for (FrameInfo frame : frames) {
                info.addInstruction(44, frame.getLabel());
                info.addInstruction(112);
                info.addInstruction(44, frame.getFrameClasses().get(0));
            }
            info.addInstruction(85, frames.size());
            ++infoEntries;
        }
        if (compatibilityVersion != null) {
            info.addInstruction(44, "flexVersion");
            info.addInstruction(44, compatibilityVersion);
            ++infoEntries;
        }
        if (mainClassQName != null) {
            info.addInstruction(44, "mainClassName");
            info.addInstruction(44, mainClassQName);
            ++infoEntries;
        }
        if (preloaderReference != null) {
            info.addInstruction(44, "preloader");
            info.addInstruction(96, preloaderReference.getMName());
            ++infoEntries;
        }
        if (runtimeDPIProviderReference != null) {
            info.addInstruction(44, "runtimeDPIProvider");
            info.addInstruction(96, runtimeDPIProviderReference.getMName());
            ++infoEntries;
        }
        if (splashScreen.generatedEmbedClassReference != null) {
            info.addInstruction(44, "splashScreenImage");
            info.addInstruction(96, splashScreen.generatedEmbedClassReference.getMName());
            ++infoEntries;
        }
        infoEntries += this.codegenRootNodeAttributes(targetAttributes, info, rootNode, problemCollection);
        if (compiledLocales != null) {
            info.addInstruction(44, "compiledLocales");
            for (String locale : compiledLocales) {
                info.addInstruction(44, locale);
            }
            info.addInstruction(86, compiledLocales.size());
            ++infoEntries;
        }
        if (!frame1Info.compiledResourceBundleNames.isEmpty()) {
            info.addInstruction(44, "compiledResourceBundleNames");
            for (String bundleName : frame1Info.compiledResourceBundleNames) {
                info.addInstruction(44, bundleName);
            }
            info.addInstruction(86, frame1Info.compiledResourceBundleNames.size());
            ++infoEntries;
        }
        if (flexInitClassName != null && stylesClassName != null) {
            info.addInstruction(44, "mixins");
            info.addInstruction(44, flexInitClassName);
            info.addInstruction(44, stylesClassName);
            int mixinEntries = 2;
            Set<String> mixinClassNames = frame1Info.getMixins();
            for (String className : frame1Info.getMixins()) {
                info.addInstruction(44, className);
            }
            info.addInstruction(86, mixinEntries += mixinClassNames.size());
            ++infoEntries;
        }
        if (!frame1Info.embeddedFonts.isEmpty()) {
            info.addInstruction(44, "fonts");
            for (Map.Entry<String, FlexFontInfo> entry : frame1Info.embeddedFonts.entrySet()) {
                info.addInstruction(44, entry.getKey());
                info.addInstruction(112);
                FlexFontInfo fontInfo = entry.getValue();
                info.addInstruction(44, "regular");
                info.addInstruction(fontInfo.regularOp);
                info.addInstruction(44, "bold");
                info.addInstruction(fontInfo.boldOp);
                info.addInstruction(44, "italic");
                info.addInstruction(fontInfo.italicOp);
                info.addInstruction(44, "boldItalic");
                info.addInstruction(fontInfo.boldItalicOp);
                info.addInstruction(85, 4);
            }
            info.addInstruction(85, frame1Info.embeddedFonts.size());
            ++infoEntries;
        }
        if (accessibilityClassNames != null && accessibilityClassNames.size() > 0) {
            info.addInstruction(44, "accessibilityClassNames");
            for (String className : accessibilityClassNames) {
                info.addInstruction(44, className);
            }
            info.addInstruction(86, accessibilityClassNames.size());
            ++infoEntries;
        }
        if (!rslInfo.requiredRSLs.isEmpty()) {
            if (this.codegenRSLsEntry(info, problemCollection, "cdRsls", rslInfo.requiredRSLs)) {
                ++infoEntries;
            }
            if (this.codegenRSLsEntry(info, problemCollection, "placeholderRsls", rslInfo.placeholderRSLs)) {
                ++infoEntries;
            }
        }
        if (this.codegenLegacyRSLs(info, rsls)) {
            ++infoEntries;
        }
        info.addInstruction(85, infoEntries);
        info.addInstruction(42);
        info.addInstruction(208);
        info.addInstruction(43);
        info.addInstruction(97, infoSlotName);
        info.labelNext(infoL1);
        info.addInstruction(72);
        classGen.addITraitsMethod(new Name("info"), Collections.<Name>emptyList(), new Name("Object"), Collections.<Object>emptyList(), false, true, true, info);
        ITraitsVisitor itraitsVisitor = classGen.getITraitsVisitor();
        ITraitVisitor infoSlotVisitor = itraitsVisitor.visitSlotTrait(0, infoSlotName, 0, new Name("Object"), LexicalScope.noInitializer);
        infoSlotVisitor.visitStart();
        infoSlotVisitor.visitEnd();
    }

    private int codegenRootNodeAttributes(ITargetAttributes targetAttributes, InstructionList info, IASNode rootNode, Collection<ICompilerProblem> problemCollection) throws InterruptedException {
        String backgroundColorString;
        int entries = 0;
        Map<String, String> attributes = targetAttributes.getRootInfoAttributes();
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            info.addInstruction(44, e.getKey());
            info.addInstruction(44, e.getValue());
            ++entries;
        }
        Boolean usePreloader = targetAttributes.getUsePreloader();
        if (usePreloader != null) {
            info.addInstruction(44, "usePreloader");
            info.addInstruction(usePreloader != false ? 38 : 39);
            ++entries;
        }
        if ((backgroundColorString = targetAttributes.getBackgroundColor()) != null) {
            try {
                int backgroundColor = this.flexProject.getColorAsInt(backgroundColorString);
                String hexString = "0x" + Integer.toHexString(backgroundColor).toUpperCase();
                info.addInstruction(44, "backgroundColor");
                info.addInstruction(44, hexString);
                ++entries;
            }
            catch (NumberFormatException numberFormatExpression) {
                problemCollection.add(new InvalidBackgroundColorProblem(rootNode.getFileSpecification().getPath(), backgroundColorString));
            }
        }
        return entries;
    }

    private boolean codegenRSLsEntry(InstructionList info, Collection<ICompilerProblem> problemCollection, String entryLabel, List<RSLSettings> rslSettingsList) {
        ISWCManager swcManager = this.flexProject.getWorkspace().getSWCManager();
        info.addInstruction(44, entryLabel);
        IResolvedQualifiersReference mxCoreRSLDataReference = ReferenceFactory.packageQualifiedReference(this.flexProject.getWorkspace(), "mx.core.RSLData");
        Name mxCoreRSLDataSlotName = mxCoreRSLDataReference.getMName();
        Object[] mxCoreRSLDataCtor = new Object[]{mxCoreRSLDataSlotName, 7};
        for (RSLSettings rslSettings : rslSettingsList) {
            int rslCount = 0;
            for (RSLSettings.RSLAndPolicyFileURLPair urls : rslSettings.getRSLURLs()) {
                info.addInstruction(93, mxCoreRSLDataSlotName);
                info.addInstruction(44, urls.getRSLURL());
                info.addInstruction(44, urls.getPolicyFileURL());
                ISWC swc = swcManager.get(new File(rslSettings.getLibraryFile().getPath()));
                boolean isSignedRSL = RSLSettings.isSignedRSL(urls.getRSLURL());
                ISWCDigest swcDigest = this.getSWCDigest((ISWCLibrary)Iterables.getFirst(swc.getLibraries(), null), isSignedRSL);
                if (swcDigest == null) {
                    if (isSignedRSL) {
                        problemCollection.add(new MissingSignedDigestProblem(swc.getSWCFile().getAbsolutePath()));
                        continue;
                    }
                    problemCollection.add(new MissingUnsignedDigestProblem(swc.getSWCFile().getAbsolutePath()));
                    continue;
                }
                info.addInstruction(44, swcDigest.getValue());
                info.addInstruction(44, swcDigest.getType());
                info.addInstruction(isSignedRSL ? 38 : 39);
                info.addInstruction(rslSettings.getVerifyDigest() ? 38 : 39);
                info.addInstruction(44, rslSettings.getApplicationDomain().getApplicationDomainValue());
                info.addInstruction(74, mxCoreRSLDataCtor);
                ++rslCount;
            }
            info.addInstruction(86, rslCount);
        }
        info.addInstruction(86, rslSettingsList.size());
        return true;
    }

    private ISWCDigest getSWCDigest(ISWCLibrary swcLibrary, boolean signedDigest) {
        for (ISWCDigest swcDigest : swcLibrary.getDigests()) {
            if (swcDigest.isSigned() != signedDigest) continue;
            return swcDigest;
        }
        return null;
    }

    private boolean codegenLegacyRSLs(InstructionList info, List<String> rsls) {
        if (rsls != null && rsls.size() > 0) {
            info.addInstruction(44, "rsls");
            for (String rsl : rsls) {
                info.addInstruction(44, "url");
                info.addInstruction(44, rsl);
                info.addInstruction(44, "size");
                info.addInstruction(36, -1);
                info.addInstruction(85, 2);
            }
            info.addInstruction(86, rsls.size());
        }
        return rsls != null && rsls.size() > 0;
    }

    public Target.DirectDependencies getAccessibilityDependencies(ICompilationUnit compilationUnit) throws InterruptedException {
        assert (this.targetSettings.isAccessible()) : "This method should only be called if accessibility is enabled!";
        HashSet<ICompilationUnit> accessibleCompilationUnits = new HashSet<ICompilationUnit>();
        IFileScopeRequestResult result = compilationUnit.getFileScopeRequest().get();
        for (IDefinition def : result.getExternallyVisibleDefinitions()) {
            String accessibilityClass;
            IMetaTag md = def.getMetaTagByName("AccessibilityClass");
            if (md == null || (accessibilityClass = md.getAttributeValue("implementation")) == null) continue;
            IResolvedQualifiersReference ref = ReferenceFactory.packageQualifiedReference(this.flexProject.getWorkspace(), accessibilityClass);
            assert (ref != null);
            this.accessibleClassNames.add(accessibilityClass);
            IDefinition accessibilityClassDefinition = ref.resolve(this.flexProject);
            if (accessibilityClassDefinition == null || accessibilityClassDefinition.isImplicit()) continue;
            ICompilationUnit cu = this.flexProject.getScope().getCompilationUnitForDefinition(accessibilityClassDefinition);
            assert (cu != null) : "Unable to find compilation unit for definition!";
            accessibleCompilationUnits.add(cu);
        }
        return new Target.DirectDependencies(accessibleCompilationUnits, Collections.<ICompilerProblem>emptyList());
    }

    public void addProductInfoToSWF(ISWF swf) {
        ProductInfoTag productInfo = new ProductInfoTag(ProductInfoTag.Product.FLEX, ProductInfoTag.Edition.NONE, (byte)Integer.parseInt("4"), (byte)Integer.parseInt("7"), VersionInfo.getBuildLong(), 0L);
        swf.setProductInfo(productInfo);
    }
}

