/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.targets;

import com.adobe.flash.compiler.definitions.IClassDefinition;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.ITypeDefinition;
import com.adobe.flash.compiler.definitions.metadata.IMetaTag;
import com.adobe.flash.compiler.definitions.references.IResolvedQualifiersReference;
import com.adobe.flash.compiler.definitions.references.ReferenceFactory;
import com.adobe.flash.compiler.internal.projects.FlexProject;
import com.adobe.flash.compiler.internal.targets.FlexFrame1Info;
import com.adobe.flash.compiler.internal.units.ASCompilationUnit;
import com.adobe.flash.compiler.internal.units.MXMLCompilationUnit;
import com.adobe.flash.compiler.problems.CompiledAsAComponentProblem;
import com.adobe.flash.compiler.problems.ICompilerProblem;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.targets.ITargetSettings;
import com.adobe.flash.compiler.units.ICompilationUnit;
import com.adobe.flash.compiler.units.requests.IFileScopeRequestResult;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

final class FlexApplicationFrame1Info
extends FlexFrame1Info {
    private final ITargetSettings targetSettings;
    private final IClassDefinition mainApplicationClassDefinition;
    private final boolean generateSystemManagerAndFlexInit;
    private final ApplicationAndModuleDefinitions appAndModuleDefs;
    final TreeSet<String> mixinClassNames;
    final HashSet<String> contributingSWCs;

    FlexApplicationFrame1Info(FlexProject flexProject, ITargetSettings targetSettings, IClassDefinition mainApplicationClassDefinition, boolean generateSystemManagerAndFlexInit, ImmutableSet<ICompilationUnit> builtCompilationUnits) throws InterruptedException {
        super(flexProject);
        this.targetSettings = targetSettings;
        this.mainApplicationClassDefinition = mainApplicationClassDefinition;
        this.generateSystemManagerAndFlexInit = generateSystemManagerAndFlexInit;
        this.mixinClassNames = new TreeSet();
        this.contributingSWCs = new HashSet();
        this.appAndModuleDefs = new ApplicationAndModuleDefinitions();
        this.collectFromCompilationUnits((Iterable<ICompilationUnit>)builtCompilationUnits);
    }

    @Override
    protected void collectFromCompilationUnit(ICompilationUnit cu) throws InterruptedException {
        super.collectFromCompilationUnit(cu);
        if (this.generateSystemManagerAndFlexInit) {
            this.collectMixinMetaData(this.mixinClassNames, cu);
            this.collectContributingSWCs(this.contributingSWCs, cu);
            this.checkForCompiledAsAComponentProblem(this.appAndModuleDefs, this.problems, cu);
        }
    }

    private void collectMixinMetaData(TreeSet<String> mixinClassNames, ICompilationUnit compilationUnit) throws InterruptedException {
        IFileScopeRequestResult result = compilationUnit.getFileScopeRequest().get();
        for (IDefinition def : result.getExternallyVisibleDefinitions()) {
            IMetaTag md = def.getMetaTagByName("Mixin");
            if (md == null) continue;
            mixinClassNames.add(def.getQualifiedName());
        }
    }

    private void collectContributingSWCs(HashSet<String> contributingSWCs, ICompilationUnit cu) {
        if (!this.targetSettings.removeUnusedRuntimeSharedLibraryPaths()) {
            return;
        }
        if (cu.getCompilationUnitType() == ICompilationUnit.UnitType.SWC_UNIT) {
            contributingSWCs.add(cu.getAbsoluteFilename());
        }
    }

    private void checkForCompiledAsAComponentProblem(ApplicationAndModuleDefinitions appAndModuleDefs, ArrayList<ICompilerProblem> problems, ICompilationUnit cu) throws InterruptedException {
        if (!(cu instanceof MXMLCompilationUnit) && !(cu instanceof ASCompilationUnit) || this.mainApplicationClassDefinition == null) {
            return;
        }
        IFileScopeRequestResult result = cu.getFileScopeRequest().get();
        for (IDefinition def : result.getExternallyVisibleDefinitions()) {
            if (!appAndModuleDefs.isApplicationOrModule(def)) continue;
            assert (def instanceof ITypeDefinition);
            ITypeDefinition typeDef = (ITypeDefinition)def;
            assert (this.mainApplicationClassDefinition instanceof ITypeDefinition);
            if (this.mainApplicationClassDefinition.isInstanceOf(typeDef, (ICompilerProject)this.flexProject)) continue;
            problems.add(new CompiledAsAComponentProblem(cu.getName(), this.mainApplicationClassDefinition.getBaseName()));
        }
    }

    @Override
    Set<String> getMixins() {
        return this.mixinClassNames;
    }

    private class ApplicationAndModuleDefinitions {
        final ITypeDefinition sparkApplication;
        final ITypeDefinition haloApplication;
        final ITypeDefinition iModule;

        ApplicationAndModuleDefinitions() {
            IResolvedQualifiersReference sparkAppRef = ReferenceFactory.packageQualifiedReference(FlexApplicationFrame1Info.this.flexProject.getWorkspace(), "spark.components.Application");
            IResolvedQualifiersReference haloAppRef = ReferenceFactory.packageQualifiedReference(FlexApplicationFrame1Info.this.flexProject.getWorkspace(), "mx.core.Application");
            IResolvedQualifiersReference iModuleRef = ReferenceFactory.packageQualifiedReference(FlexApplicationFrame1Info.this.flexProject.getWorkspace(), "mx.modules.IModule");
            this.sparkApplication = this.resolveType(sparkAppRef);
            this.haloApplication = this.resolveType(haloAppRef);
            this.iModule = this.resolveType(iModuleRef);
        }

        boolean isApplicationOrModule(IDefinition def) {
            if (!(def instanceof ITypeDefinition)) {
                return false;
            }
            ITypeDefinition typeDef = (ITypeDefinition)def;
            if (typeDef == this.sparkApplication || typeDef == this.iModule || typeDef == this.haloApplication) {
                return false;
            }
            return this.sparkApplication != null && typeDef.isInstanceOf(this.sparkApplication, (ICompilerProject)FlexApplicationFrame1Info.this.flexProject) || this.iModule != null && typeDef.isInstanceOf(this.iModule, (ICompilerProject)FlexApplicationFrame1Info.this.flexProject) || this.haloApplication != null && typeDef.isInstanceOf(this.iModule, (ICompilerProject)FlexApplicationFrame1Info.this.flexProject);
        }

        private ITypeDefinition resolveType(IResolvedQualifiersReference ref) {
            IDefinition def = ref.resolve(FlexApplicationFrame1Info.this.flexProject);
            if (!(def instanceof ITypeDefinition)) {
                return null;
            }
            return (ITypeDefinition)def;
        }
    }
}

