/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.scopes;

import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.internal.scopes.IMutableDefinitionSet;

public class SmallDefinitionSet
implements IMutableDefinitionSet {
    private static final int MAX_SIZE = 2;
    private IDefinition definition0;
    private IDefinition definition1;

    public SmallDefinitionSet(IDefinition definition0, IDefinition definition1) {
        assert (definition0 != null && definition1 != null);
        this.definition0 = definition0;
        this.definition1 = definition1;
    }

    @Override
    public boolean isEmpty() {
        return this.definition0 == null && this.definition1 == null;
    }

    @Override
    public int getSize() {
        int size = 0;
        if (this.definition0 != null) {
            ++size;
        }
        if (this.definition1 != null) {
            ++size;
        }
        return size;
    }

    @Override
    public int getMaxSize() {
        return 2;
    }

    @Override
    public IDefinition getDefinition(int i) {
        if (i == 0) {
            return this.definition0;
        }
        if (i == 1) {
            return this.definition1;
        }
        return null;
    }

    @Override
    public void addDefinition(IDefinition definition) {
        assert (definition != null) : "Can't add a null definition to a definition set";
        if (this.definition0 == null) {
            this.definition0 = definition;
        } else if (this.definition1 == null) {
            this.definition1 = definition;
        } else assert (false) : "SmallDefinitionSet is full";
    }

    @Override
    public void removeDefinition(IDefinition definition) {
        assert (definition != null) : "Can't remove a null definition from a definition set";
        if (this.definition1 == definition) {
            this.definition1 = null;
        }
        if (this.definition0 == definition) {
            this.definition0 = this.definition1;
            this.definition1 = null;
        }
    }

    @Override
    public void replaceDefinition(int i, IDefinition newDefinition) {
        assert (newDefinition != null) : "Can't replace a definition in a definition set with null";
        if (i == 0) {
            this.definition0 = newDefinition;
        } else if (i == 1) {
            this.definition1 = newDefinition;
        } else assert (false) : "Invalid index " + i + " in SmallDefinitionSet";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.definition0 != null) {
            sb.append(this.definition0.toString());
        }
        sb.append('\n');
        if (this.definition1 != null) {
            sb.append(this.definition1.toString());
        }
        return sb.toString();
    }
}

