/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.flash.compiler.internal.scopes;

import com.adobe.flash.compiler.common.ASModifier;
import com.adobe.flash.compiler.definitions.IDefinition;
import com.adobe.flash.compiler.definitions.INamespaceDefinition;
import com.adobe.flash.compiler.definitions.references.INamespaceReference;
import com.adobe.flash.compiler.internal.definitions.NamespaceDefinition;
import com.adobe.flash.compiler.internal.definitions.ScopedDefinitionBase;
import com.adobe.flash.compiler.internal.definitions.VariableDefinition;
import com.adobe.flash.compiler.internal.projects.CompilerProject;
import com.adobe.flash.compiler.internal.scopes.ASScope;
import com.adobe.flash.compiler.internal.scopes.NamespaceSetPredicate;
import com.adobe.flash.compiler.internal.scopes.TypeScope;
import com.adobe.flash.compiler.projects.ICompilerProject;
import com.adobe.flash.compiler.scopes.IDefinitionSet;
import com.adobe.flash.compiler.workspaces.IWorkspace;
import java.util.Collection;
import java.util.Set;

public abstract class ScopeView
extends ASScope {
    TypeScope typeScope;

    ScopeView(ASScope containingScope, TypeScope typeScope) {
        super(containingScope);
        this.typeScope = typeScope;
    }

    protected abstract TypeScope.ScopeKind getScopeKind();

    @Override
    protected void getPropertyForScopeChain(CompilerProject project, Collection<IDefinition> defs, String baseName, NamespaceSetPredicate namespaceSet, boolean findAll) {
        this.typeScope.getPropertyForScopeChain(project, defs, baseName, namespaceSet, findAll, this.getScopeKind());
    }

    @Override
    protected void getPropertyForMemberAccess(CompilerProject project, Collection<IDefinition> defs, String baseName, NamespaceSetPredicate namespaceSet, boolean findAll) {
        this.typeScope.getPropertyForMemberAccess(project, defs, baseName, namespaceSet, findAll, this.getScopeKind());
    }

    @Override
    public void getAllPropertiesForScopeChain(CompilerProject project, Collection<IDefinition> defs, Set<INamespaceDefinition> namespaceSet) {
        this.typeScope.getAllPropertiesForScopeChain(project, defs, namespaceSet, this.getScopeKind());
    }

    @Override
    public void getAllPropertiesForMemberAccess(CompilerProject project, Collection<IDefinition> defs, Set<INamespaceDefinition> namespaceSet) {
        this.typeScope.getAllPropertiesForMemberAccess(project, defs, namespaceSet, this.getScopeKind());
    }

    @Override
    public final void getAllLocalProperties(CompilerProject project, Collection<IDefinition> defs, Set<INamespaceDefinition> namespaceSet, INamespaceDefinition extraNamespace) {
        this.typeScope.getAllLocalProperties(project, defs, namespaceSet, extraNamespace);
    }

    @Override
    protected boolean namespaceSetSameAsContainingScopeNamespaceSet() {
        return false;
    }

    @Override
    public void addImplicitOpenNamespaces(CompilerProject compilerProject, Set<INamespaceDefinition> result) {
        this.typeScope.addImplicitOpenNamespaces(compilerProject, result, this.getScopeKind());
    }

    @Override
    public void addDefinition(IDefinition d) {
        assert (this.isStaticScope() == (d.hasModifier(ASModifier.STATIC) || d instanceof NamespaceDefinition || d instanceof VariableDefinition && ((VariableDefinition)d).declaredInControlFlow()));
        this.typeScope.addDefinition(d);
    }

    @Override
    public ScopedDefinitionBase getDefinition() {
        return this.typeScope.getDefinition();
    }

    @Override
    public IDefinitionSet getLocalDefinitionSetByName(String name) {
        IDefinitionSet d = this.typeScope.getLocalDefinitionSetByName(name);
        if (d != null && (d = new FilteredDefinitionSet(d, this.getScopeKind())).isEmpty()) {
            d = null;
        }
        return d;
    }

    @Override
    public String getContainingSourcePath(String baseName, ICompilerProject project) {
        return this.typeScope.getContainingSourcePath(baseName, project);
    }

    @Override
    public void addImport(String target) {
        this.typeScope.addImport(target);
    }

    @Override
    public void addLocalImportsToNamespaceSet(IWorkspace workspace, Set<INamespaceDefinition> namespaceSet) {
        if (this.getScopeKind() == TypeScope.ScopeKind.STATIC) {
            this.typeScope.addLocalImportsToNamespaceSet(workspace, namespaceSet);
        }
    }

    @Override
    public Set<INamespaceDefinition> getExplicitImportQualifiers(CompilerProject project, String name) {
        if (this.getScopeKind() == TypeScope.ScopeKind.STATIC) {
            return this.typeScope.getExplicitImportQualifiers(project, name);
        }
        return super.getExplicitImportQualifiers(project, name);
    }

    @Override
    protected INamespaceReference[] getUsedNamespaces() {
        if (this.getScopeKind() == TypeScope.ScopeKind.STATIC) {
            return this.typeScope.getUsedNamespaces();
        }
        return EMPTY_USE_ARRAY;
    }

    @Override
    public void addUseDirective(NamespaceDefinition.IUseNamespaceDirective useDirective) {
        this.typeScope.addUseDirective(useDirective);
    }

    @Override
    public void addNamespaceDirective(NamespaceDefinition.INamespaceDirective directive) {
        this.typeScope.addNamespaceDirective(directive);
    }

    @Override
    public NamespaceDefinition.INamespaceDirective getFirstNamespaceDirective() {
        if (this.getScopeKind() == TypeScope.ScopeKind.STATIC) {
            return this.typeScope.getFirstNamespaceDirective();
        }
        return null;
    }

    @Override
    public final ScopedDefinitionBase getContainingDefinition() {
        return this.typeScope.getDefinition();
    }

    @Override
    public final boolean isPackageName(String p) {
        return this.typeScope.isPackageName(p);
    }

    public boolean isInstanceScope() {
        return this.getScopeKind() == TypeScope.ScopeKind.INSTANCE;
    }

    public boolean isStaticScope() {
        return this.getScopeKind() == TypeScope.ScopeKind.STATIC;
    }

    public ASScope resolveSuperScope(ICompilerProject project) {
        return this.typeScope.resolveSuperScope(project, this.getScopeKind());
    }

    private static class FilteredDefinitionSet
    implements IDefinitionSet {
        IDefinitionSet definitionSet;
        TypeScope.ScopeKind scopeKind;
        int filteredSize;

        FilteredDefinitionSet(IDefinitionSet definitionSet, TypeScope.ScopeKind scopeKind) {
            this.definitionSet = definitionSet;
            this.scopeKind = scopeKind;
            int count = 0;
            int n = definitionSet.getSize();
            for (int i = 0; i < n; ++i) {
                IDefinition definition = definitionSet.getDefinition(i);
                if (!scopeKind.findDefinition(definition)) continue;
                ++count;
            }
            this.filteredSize = count;
        }

        @Override
        public boolean isEmpty() {
            return this.filteredSize == 0;
        }

        @Override
        public int getSize() {
            return this.filteredSize;
        }

        @Override
        public int getMaxSize() {
            return this.definitionSet.getMaxSize();
        }

        @Override
        public IDefinition getDefinition(int i) {
            if (i < 0 || i >= this.filteredSize) {
                return null;
            }
            int count = 0;
            int m = this.definitionSet.getSize();
            for (int j = 0; j < m; ++j) {
                IDefinition definition = this.definitionSet.getDefinition(j);
                if (!this.scopeKind.findDefinition(definition) || count++ != i) continue;
                return definition;
            }
            return null;
        }
    }
}

